//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXButton.cpp
 * @brief		{^Rg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXButton_CPP_

//======================================================================
// include
#include <windowsx.h>
#include "WXButton.h"
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * BM_CLICK
 *
*//***********************************************************************/
void	Button_Click(HWND hWnd)
{
#if(WINVER >= 0x0400)
	SendMessage(hWnd, BM_CLICK, 0, 0);
#else
	SendMessage(hWnd, WM_LBUTTONDOWN, 0, 0);
	SendMessage(hWnd, WM_LBUTTONUP, 0, 0);
#endif
}
//**********************************************************************
//
// BM_GETCHECK
//
//**********************************************************************
//BOOL	Button_GetCheck(HWND hWnd)
//{
//	return (BOOL)SendMessage(hWnd, BM_GETCHECK, 0, 0);
//}
/**********************************************************************//**
 *
 * BM_GETIMAGE
 *
 ----------------------------------------------------------------------
 * @param [in]	Image	= IMAGE_BITMAP or IMAGE_ICON
 * @return	C[W̃nh
*//***********************************************************************/
LRESULT	Button_GetImage(HWND hWnd, int Image)
{
#if	defined(BM_GETIMAGE)
	return SendMessage(hWnd, BM_GETIMAGE, (WPARAM)Image, 0);
#else
	return 0;
#endif
}
//**********************************************************************
//
// BM_GETSTATE
//
//**********************************************************************
//int		Button_GetState(HWND hWnd)
//{
//	return (int)SendMessage(hWnd, BM_GETSTATE, 0, 0);
//}
//**********************************************************************
//
// BM_SETCHECK
//
//**********************************************************************
//void	Button_SetCheck(HWND hWnd, BOOL Check)
//{
//	return SendMessage(hWnd, BM_SETCHECK, (WPARAM)Check, 0);
//}
/**********************************************************************//**
 *
 * BM_SETIMAGE
 *
 ----------------------------------------------------------------------
 * @param [in]	Image	= IMAGE_BITMAP or IMAGE_ICON
 * @param [in]	hImgae	= C[W̃nh
 * @return	
*//***********************************************************************/
LRESULT	Button_SetImage(HWND hWnd, int Image, LPARAM hImgae)
{
#if	defined(BM_GETIMAGE)
	return SendMessage(hWnd, BM_GETIMAGE, (WPARAM)Image, hImgae);
#else
	return 0;
#endif
}
//**********************************************************************
//
// BM_SETSTATE
//
//**********************************************************************
//LRESULT	Button_SetState(HWND hWnd, int State)
//{
//	return SendMessage(hWnd, BM_SETSTATE, (WPARAM)State, 0);
//}
//**********************************************************************
//
// BM_SETSTYLE
//
//**********************************************************************
//void	Button_SetStyle(HWND hWnd, DWORD dwStyle, BOOL ReDraw)
//{
//	return SendMessage(hWnd, BM_SETSTYLE, (WPARAM)dwStyle, (LPARAM)ReDraw);
//}

//======================================================================
// class
// CButton
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CButton::CButton(void)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CButton::CButton(HWND hWnd)
: CSubClass(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CButton::~CButton(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CButton::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(WC_BUTTON
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CButton::Create( DWORD dwStyle
					 , LPCTSTR lpszWindowName
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(WC_BUTTON
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CButton::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, WC_BUTTON
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CButton::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, WC_BUTTON
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CButton::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
void	CButton::Click(void)							{ Button_Click(m_hWnd); }
LRESULT	CButton::GetImage(int Image)					{ return Button_GetImage(m_hWnd, Image); }
BOOL	CButton::GetCheck(void)							{ return Button_GetCheck(m_hWnd); }
int		CButton::GetState(void)							{ return Button_GetState(m_hWnd); }
void	CButton::SetCheck(BOOL Check)					{ Button_SetCheck(m_hWnd,Check); }
LRESULT	CButton::SetImage(int Image, LPARAM hImage)		{ return Button_SetImage(m_hWnd, Image, hImage); }
LRESULT	CButton::SetState(int State)					{ return Button_SetState(m_hWnd, State); }
void	CButton::SetStyle(DWORD dwStyle, BOOL ReDraw)	{ Button_SetStyle(m_hWnd,dwStyle, ReDraw); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
