//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXTabCtrl.cpp
 * @brief		^uRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXTabCtrl_CPP_

//======================================================================
// include
#include "WXTabCtrl.h"
#include "WXComControl.h"

//======================================================================
// define
#ifndef TabCtrl_SetMinTabWidth
#define TabCtrl_SetMinTabWidth(...)	0	// empty
#endif
#ifndef TabCtrl_DeselectAll
#define	TabCtrl_DeselectAll(...)		// empty
#endif
#ifndef TabCtrl_HighlightItem
#define	TabCtrl_HighlightItem(...)	0	// empty
#endif
#ifndef TabCtrl_SetExtendedStyle
#define	TabCtrl_SetExtendedStyle(hwnd, dw)	(DWORD)SetWindowLong(hwnd,GWL_EXSTYLE,dw)
#endif
#ifndef TabCtrl_GetExtendedStyle
#define	TabCtrl_GetExtendedStyle(hwnd)		(DWORD)GetWindowLong(hwnd,GWL_EXSTYLE)
#endif

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * ACȇ}
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	nItem		= 
 * @param [in]	unMask		= 
 * @param [in]	lpszItem	= 
 * @param [in]	nImage		= 
 * @param [in]	lParam		= 
 * @return 
*//***********************************************************************/
int TabCtrl_InsertItemEx(HWND hWnd, int nItem, UINT unMask, LPTSTR lpszItem, int nImage, LPARAM lParam )
{
	TCITEM itm = {0};
	itm.mask = unMask;
	itm.iImage	= nImage;
	itm.pszText = lpszItem;
	itm.lParam	= lParam;
	return TabCtrl_InsertItem(hWnd,nItem,&itm);
}

/**********************************************************************//**
 *
 * `̈̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [out]	lprc	= o
*//***********************************************************************/
int	TabCtrl_GetDrawRect(HWND hWnd, LPRECT lprc)
{
	GetClientRect(hWnd, lprc);
	return TabCtrl_AdjustRect(hWnd, 0, (LPARAM)lprc);
}

/**********************************************************************//**
 *
 * `̈悩NCAg̈ɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [io]	lprc	= ϊ̈
 * @return 
*//***********************************************************************/
int	TabCtrl_DrawToClientRect(HWND hWnd, LPRECT lprc)
{
	return TabCtrl_AdjustRect(hWnd, 1, (LPARAM)lprc);
}

/**********************************************************************//**
 *
 * `̈悩EBhËɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [io]	lprc	= ϊ̈
 * @return 
*//***********************************************************************/
int	TabCtrl_DrawToWindowRect(HWND hWnd, LPRECT lprc)
{
	int ret = TabCtrl_AdjustRect(hWnd, 1, (LPARAM)lprc);
	DWORD style = (DWORD)GetWindowLong(hWnd, GWL_STYLE);
	AdjustWindowRect(lprc, style, 0);	// TODO:j[͂Ȃł傤
	return ret;
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CTabCtrl::CTabCtrl(void)
{
	CComCtrl::Initialize(ICC_TAB_CLASSES);
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CTabCtrl::CTabCtrl(HWND hWnd)
: CSubClass(hWnd)
{
	CComCtrl::Initialize(ICC_TAB_CLASSES);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CTabCtrl::~CTabCtrl(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CTabCtrl::Create( DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CWindow::Create(WC_TABCONTROL
		, nullptr
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CTabCtrl::Create( DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CreateWindow(WC_TABCONTROL
		, nullptr
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CTabCtrl::CreateEx( DWORD dwExStyle
					 , DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CWindow::CreateEx(dwExStyle
		, WC_TABCONTROL
		, nullptr
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CTabCtrl::CreateEx( DWORD dwExStyle
					 , DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CreateWindowEx(dwExStyle
		, WC_TABCONTROL
		, nullptr
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CTabCtrl::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
HIMAGELIST	CTabCtrl::GetImageList(void)						{ return TabCtrl_GetImageList(m_hWnd); }
HIMAGELIST	CTabCtrl::SetImageList(HIMAGELIST hImgList)			{ return TabCtrl_SetImageList(m_hWnd, hImgList); }
int			CTabCtrl::GetItemCount(void)						{ return TabCtrl_GetItemCount(m_hWnd); }
BOOL		CTabCtrl::GetItem(int nItem, TCITEM* pItem)			{ return TabCtrl_GetItem(m_hWnd, nItem, pItem); }
BOOL		CTabCtrl::SetItem(int nItem, TCITEM* pItem)			{ return TabCtrl_SetItem(m_hWnd, nItem, pItem); }
int			CTabCtrl::InsertItem(int nItem, const TCITEM* pItem)			{ return TabCtrl_InsertItem(m_hWnd, nItem, pItem); }
int			CTabCtrl::InsertItem(int nItem, LPTSTR lpszItem)				{ return InsertItem(nItem, TCIF_TEXT, lpszItem, 0, 0); }
int			CTabCtrl::InsertItem(int nItem, LPTSTR lpszItem, int nImage)	{ return InsertItem(nItem, TCIF_TEXT|TCIF_IMAGE, lpszItem, nImage, 0); }
int			CTabCtrl::InsertItem(UINT unMask, int nItem, LPTSTR lpszItem, int nImage, LPARAM lParam)
																{ return TabCtrl_InsertItemEx(m_hWnd, nItem, unMask, lpszItem, nImage, lParam); }
int			CTabCtrl::GetCurSel(void)							{ return TabCtrl_GetCurSel(m_hWnd); }
int			CTabCtrl::SetCurSel(int nItem)						{ return TabCtrl_SetCurSel(m_hWnd, nItem); }
BOOL		CTabCtrl::DeleteItem(int nItem)						{ return TabCtrl_DeleteItem(m_hWnd, nItem); }
BOOL		CTabCtrl::DeleteAllItems(void)						{ return TabCtrl_DeleteAllItems(m_hWnd); }
BOOL		CTabCtrl::GetItemRect(int nItem, LPRECT lprc)		{ return TabCtrl_GetItemRect(m_hWnd, nItem, lprc); }
int			CTabCtrl::HitTest(TC_HITTESTINFO* pInfo)			{ return TabCtrl_HitTest(m_hWnd, pInfo); }
BOOL		CTabCtrl::SetItemExtra(void* pExItem)				{ return TabCtrl_SetItemExtra(m_hWnd, pExItem); }
int			CTabCtrl::AdjustRect(BOOL bLarger, LPRECT lprc)		{ return TabCtrl_AdjustRect(m_hWnd, bLarger, lprc); }
DWORD		CTabCtrl::SetItemSize(WORD x, WORD y)				{ return TabCtrl_SetItemSize(m_hWnd, x, y); }
void		CTabCtrl::RemoveImage(int nItem)					{ TabCtrl_RemoveImage(m_hWnd, nItem); }
void		CTabCtrl::SetPadding(WORD cx, WORD cy)				{ TabCtrl_SetPadding(m_hWnd, cx, cy); }
int			CTabCtrl::GetRowCount(void)							{ return TabCtrl_GetRowCount(m_hWnd); }
#if	!defined(IRIS_WIN32_WCE)
HWND		CTabCtrl::GetToolTips(void)							{ return TabCtrl_GetToolTips(m_hWnd); }
void		CTabCtrl::SetToolTips(HWND hWndTT)					{ TabCtrl_SetToolTips(m_hWnd, hWndTT); }
#endif
int			CTabCtrl::GetCurFocus(void)							{ return TabCtrl_GetCurFocus(m_hWnd); }
LRESULT		CTabCtrl::SetCurFocus(int nItem)					{ return TabCtrl_SetCurFocus(m_hWnd, nItem); }
int			CTabCtrl::SetMinTabWidth(LPARAM x)					{ return TabCtrl_SetMinTabWidth(m_hWnd, x); }
void		CTabCtrl::DeselectAll(WPARAM fFocus)				{ TabCtrl_DeselectAll(m_hWnd, fFocus); }
BOOL		CTabCtrl::HighlightItem(int nItem, WORD fHighlight)	{ return TabCtrl_HighlightItem(m_hWnd, nItem, fHighlight); }
DWORD		CTabCtrl::GetExtendedStyle(void)					{ return TabCtrl_GetExtendedStyle(m_hWnd); }
DWORD		CTabCtrl::SetExtendedStyle(DWORD dwExStyle)			{ return TabCtrl_SetExtendedStyle(m_hWnd, dwExStyle); }
#if	!defined(IRIS_WIN32_WCE)
BOOL		CTabCtrl::SetUnicodeFormat(BOOL Unicode)			{ return TabCtrl_SetUnicodeFormat(m_hWnd, Unicode); }
BOOL		CTabCtrl::GetUnicodeFormat(void)					{ return TabCtrl_GetUnicodeFormat(m_hWnd); }
#endif
BOOL		CTabCtrl::SetCCMVersion(DWORD dwVersion)			{ return ComControl_SetVersion(m_hWnd, dwVersion); }

int			CTabCtrl::GetDrawRect(LPRECT lprc)					{ return TabCtrl_GetDrawRect(m_hWnd, lprc); }
int			CTabCtrl::DrawToClientRect(LPRECT lprc)				{ return TabCtrl_DrawToClientRect(m_hWnd, lprc); }
int			CTabCtrl::DrawToWindowRect(LPRECT lprc)				{ return TabCtrl_DrawToWindowRect(m_hWnd, lprc); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
