//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProgressBar.h
 * @brief		ProgressBart@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXProgressBar_H_
#define INCG_IRIS_WXProgressBar_H_

//======================================================================
// icnlude
#include "../app/WXSubClass.h"

//======================================================================
// define
// bar colorftHgɂƂɎw肷鐔l
#define WX_PB_DEFAULT_BARCOLOR	(0xFF000000)

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CProgressBar;

//======================================================================
// function
// ʒuw肵i߂
LRESULT		ProgressBar_DeltaPos(HWND hWnd, int nDelta);
// ʒu擾
int			ProgressBar_GetPos(HWND hWnd);
// ͈͂̎擾
int			ProgressBar_GetRange(HWND hWnd, BOOL bLow);
void		ProgressBar_GetRange(HWND hWnd, int& nLower, int& nUpper);
int			ProgressBar_GetRangeMax(HWND hWnd);
int			ProgressBar_GetRangeMin(HWND hWnd);
// o[̐Fݒ
COLORREF	ProgressBar_SetBarColor(HWND hWnd, COLORREF color);
// wiF̐ݒ
COLORREF	ProgressBar_SetBkColor(HWND hWnd, COLORREF color);
// ʒuݒ
int			ProgressBar_SetPos(HWND hWnd, int nPos);
// ͈͂̐ݒ
LRESULT		ProgressBar_SetRange(HWND hWnd, WORD wLower, WORD wUpper);
LRESULT		ProgressBar_SetRange32(HWND hWnd, int nLower, int nUpper);
// l̐ݒ
int			ProgressBar_SetStep(HWND hWnd, int nStep);
// ʒu𑝕li߂
int			ProgressBar_StepIt(HWND hWnd);

//======================================================================
// class
//! vOXo[NX
class CProgressBar : public CSubClass
{
public:
	// RXgN^
	CProgressBar(void);
	CProgressBar(HWND hWnd);
	// fXgN^
	~CProgressBar(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
public:
	// wrap
	// ʒuw肵i߂
	LRESULT	DeltaPos(int nDelta);
	// ʒu擾
	int		GetPos(void);
	// ͈͂̎擾
	int		GetRange(BOOL bLow);
	void	GetRange(int& nLower, int& nUpper);
	int		GetRangeMax(void);
	int		GetRangeMin(void);
	// o[̐Fݒ
	LRESULT	SetBarColor(COLORREF color);
	// wiF̐ݒ
	LRESULT	SetBkColor(COLORREF color);
	// ʒuݒ
	int		SetPos(int nPos);
	// ͈͂̐ݒ
	LRESULT	SetRange(WORD wLower, WORD wUpper);
	LRESULT	SetRange32(int nLower, int nUpper);
	// l̐ݒ
	int		SetStep(int nStep);
	// ʒu𑝕li߂
	LRESULT	StepIt(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
