//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHotKey.h
 * @brief		zbgL[֘At@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXHotKey_H_
#define INCG_IRIS_WXHotKey_H_

//======================================================================
// include
#include "../app/WXSubClass.h"

#if	defined(IRIS_WIN32_WCE)
#error not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CHotKey;

//======================================================================
// function
// zbgL[ϊ
BYTE	HKM_TransHotKeyF(BYTE mod);
BYTE	HKM_TransMod(BYTE hotkeyf);
// 擾
WORD	HKM_GetHotKey(HWND hWnd, void* mod, void* key);
WORD	HKM_GetHotKey(HWND hWnd);
// ݒ
void	HKM_SetHotKey(HWND hWnd, BYTE key, BYTE mod);
void	HKM_SetHotKey(HWND hWnd, WPARAM wParam );
// [ݒ
void	HKM_SetRules(HWND hWnd, WORD HkComb, WORD HkMod);

//======================================================================
// class
//! zbgL[NX
class CHotKey : public CSubClass
{
public:
	// RXgN^
	CHotKey(void);
	CHotKey(HWND hWnd);
	// fXgN^
	~CHotKey(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
public:
	// wrap
	// 擾
	WORD	GetHotKey(void* mod, void* key);
	WORD	GetHotKey(void);
	// ݒ
	void	SetHotKey(BYTE key, BYTE mod);
	void	SetHotKey(WPARAM wParam );
	// [ݒ
	void	SetRules(WORD HkComb, WORD HkMod);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
