//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDockingWindow.cpp
 * @brief		hbLOEBhENXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDokingWindow_CPP_

//======================================================================
// include
#include "WXDockingWindow.h"
#include <commctrl.h>
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
// CDokableWindow
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDockableWindow::CDockableWindow(void)
: m_pParent(nullptr)
, m_Direction(-1)
{
	for( int i=0; i < DIR_NUM; ++i ) m_pJoin[i] = nullptr;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDockableWindow::~CDockableWindow(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CDockableWindow::Create(LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent
					, HINSTANCE hInstance
					, void *pParam)
{
	DWORD dwStyle = WS_CHILD | WS_CAPTION | WS_VISIBLE | WS_SYSMENU | WS_THICKFRAME;
	DWORD dwExStyel = WS_EX_TOOLWINDOW;
	return CWindow::CreateEx(dwExStyel
		, WC_WXWINDOW
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, 0
		, hInstance
		, pParam);
}

/**********************************************************************//**
 *
 * EBhEgɃhbLO
 *
 ----------------------------------------------------------------------
 * @param [in]	dir		= hbLO
 * @param [in]	pDock	= EBhE
 * @return	
*//***********************************************************************/
bool CDockableWindow::Joint(int dir, CDockableWindow* pDock)
{
	IRIS_ASSERT( dir >= 0 && dir < DIR_NUM );
	if( pDock == nullptr ) return false;
	CWindow* pWindow = dcast<CWindow*>(pDock);
	if( m_pJoin[dir] != nullptr ) return false;
	if( pDock->m_pParent != nullptr )
	{
		pDock->m_pParent->m_pJoin[pDock->m_Direction] = nullptr;
	}
	pDock->m_pParent = this;
	pDock->m_Direction = dir;
	m_pJoin[dir] = pDock;
	RECT rc = {0};
	RECT drc;
	GetWindowRect(&rc);
	pDock->GetWindowRect(&drc);
	int w = rc.right-rc.left;
	int h = rc.bottom-rc.top;
	int dw = drc.right-drc.left;
	int dh = drc.bottom-drc.top;
	LPPOINT pt = (LPPOINT)&rc;
	::ScreenToClient(GetParent(), pt);
	MINMAXINFO mm;
	GetMinMaxInfo(&mm);
	switch( dir )
	{
	case DIR_TOP:
		if( dh > h ) dh = h - mm.ptMinTrackSize.y;
		pWindow->SetWindowPos(nullptr, pt->x,   pt->y, w,   dh, TRUE);
		CWindow::SetWindowPos(nullptr, pt->x, pt->y+h, w, h-dh, TRUE);
		break;
	case DIR_BOTTOM:
		if( dh > h ) dh = h - mm.ptMinTrackSize.y;
		pWindow->SetWindowPos(nullptr, pt->x, pt->y+h-dh, w,   dh, TRUE);
		CWindow::SetWindowPos(nullptr, pt->x,      pt->y, w, h-dh, TRUE);
		break;
	case DIR_LEFT:
		if( dw > w ) dw = w - mm.ptMinTrackSize.x;
		pWindow->SetWindowPos(nullptr,    pt->x, pt->y,   dw, h, TRUE);
		CWindow::SetWindowPos(nullptr, pt->x+dw, pt->y, w-dw, h, TRUE);
		break;
	case DIR_RIGHT:
		if( dw > w ) dw = w - mm.ptMinTrackSize.x;
		pWindow->SetWindowPos(nullptr, pt->x+w-dw, pt->y,   dw, h, TRUE);
		CWindow::SetWindowPos(nullptr,      pt->x, pt->y, w-dw, h, TRUE);
		break;
	}

	return true;
}

/**********************************************************************//**
 *
 * EBhEgɃhbLO
 *
 ----------------------------------------------------------------------
 * @param [in]	pWindow	= EBhE
*//***********************************************************************/
bool CDockableWindow::Docking(CWindow* pWindow)
{
	if( pWindow == nullptr ) return false;
	CWindow* pParent = this;
	// X^C̕ύX
	LONG doc_style = pWindow->GetWindowLong(GWL_STYLE);
	LONG style = GetWindowLong(GWL_STYLE);
	LONG doc_exstyle = pWindow->GetWindowLong(GWL_EXSTYLE);
	if( !(doc_style & WS_SYSMENU) ) 
	{
		style &= ~WS_SYSMENU;
		SetWindowLong(GWL_STYLE, style);
	}

	doc_style &= ~(WS_CAPTION|WS_BORDER|WS_POPUP|WS_THICKFRAME|WS_SYSMENU|DS_MODALFRAME);
	doc_style |= WS_CHILD | WS_CLIPCHILDREN;
	doc_exstyle = 0;
	pWindow->SetWindowLong(GWL_EXSTYLE, doc_exstyle);
	pWindow->SetWindowLong(GWL_STYLE, doc_style);

	// ^Cg̓o^
	if( m_List.empty() )
	{
		SetTitle(pWindow);
	}
	else
	{
		if( !m_Tab.IsWindow() )
		{
			CreateTabWindow();
			CWindow* pWin = nullptr;
			for( CDockList::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
			{
				pWin = (*it);
				std::_tstring str = TEXT("no title");
				pWin->GetWindowText(str);
				m_Tab.InsertItem(TCIF_PARAM|TCIF_TEXT, 0, (LPTSTR)str.c_str(), 0, (LPARAM)pWin);
				// eEBhE̕ύX
				pWin->SetParent(m_Tab.GetHWND());
			}
		}
		if( m_Tab.GetHWND() != nullptr )
		{
			pParent = &m_Tab;
		}
		{
			std::_tstring str = TEXT("no title");
			pWindow->GetWindowText(str);
			int curr = m_Tab.InsertItem(TCIF_PARAM|TCIF_TEXT, 0, (LPTSTR)str.c_str(), 0, (LPARAM)pWindow);
			m_Tab.SetCurSel(curr);
		}
		for( CDockList::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
		{
			(*it)->ShowWindow(SW_HIDE);
		}
	}
	if( pWindow->GetSubject() != nullptr )
	{
		pParent->AttachObserver(pWindow);
	}
	// eEBhE̕ύX
	pWindow->SetParent(pParent->GetHWND());
	ShowWindow(SW_SHOW);
	// o^
	m_List.push_back(pWindow);
	return true;
}

/**********************************************************************//**
 *
 * AĂ\ݒEBhE擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dir	= A
 * @return hbLOEBhENXAhX
*//***********************************************************************/
CDockableWindow* CDockableWindow::GetVisibleJointWindow(int dir)
{ 
	if( m_pJoin[dir] == nullptr ) return nullptr;
	if( m_pJoin[dir]->IsWindowEnabled() || m_pJoin[dir]->IsWindowVisible() ) 
		return m_pJoin[dir]; 
	return nullptr; 
}

/**********************************************************************//**
 *
 * hbLOEBhE
 *
 ----------------------------------------------------------------------
 * @param [in]	pWindow	= EBhE
 * @return hbLOEBhENXAhX
*//***********************************************************************/
CDockingFrameWindow* CDockableWindow::GetFrameWindow(void)
{
	return dcast<CDockingFrameWindow*>(CWindow::Find(GetParent()));
}

/**********************************************************************//**
 *
 * hbLOEBhE
 *
 ----------------------------------------------------------------------
 * @param [in]	pWindow	= EBhE
 * @return hbLOEBhENXAhX
*//***********************************************************************/
CDockableWindow* CDockableWindow::Find(CWindow* pWindow)
{
	if( IsDocking(pWindow) ) return this;
	for( int i=0; i < DIR_NUM; ++i )
	{
		if( m_pJoin[i] != nullptr )
		{
			CDockableWindow* ret = m_pJoin[i]->Find(pWindow);
			if( ret != nullptr ) return ret;
		}
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * SetWindowSize
 *
 ----------------------------------------------------------------------
 * @param [in]	w			= 
 * @param [in]	h			= 
 * @param [in]	bRepaint	= ĕ`tO
 * @return	
*//***********************************************************************/
BOOL CDockableWindow::SetWindowPos(int x, int y, int w, int h, BOOL bRepaint)
{
	m_NcHitTest = HTNOWHERE;
	if( !IsHasChild() )
	{
		CWindow::MoveWindow(x, y, w, h, TRUE);
		return TRUE;
	}

	CDockableWindow* pVisible[DIR_NUM];
	MINMAXINFO mm;
	RECT rc;
	GetWindowRect(&rc);
	int cw = rc.right-rc.left;
	int ch = rc.bottom-rc.top;
	BOOL bVisible = IsWindowVisible();
	if( bVisible == FALSE )
	{
		cw = 0; ch = 0;
	}
	for( int i=0; i < DIR_NUM; ++i ) pVisible[i] = GetVisibleJointWindow(i);
	if( pVisible[DIR_LEFT] != nullptr || pVisible[DIR_RIGHT] != nullptr )
	{
		int rx = 0, lx = 0;
		if( pVisible[DIR_LEFT] != nullptr )
		{
			pVisible[DIR_LEFT]->GetMinMaxInfo(&mm);
			lx = mm.ptMinTrackSize.x;
		}
		if( pVisible[DIR_RIGHT] != nullptr )
		{
			pVisible[DIR_RIGHT]->GetMinMaxInfo(&mm);
			rx = mm.ptMinTrackSize.x;
		}
		int tw = w - cw;
		if( tw < rx+lx ) cw = w - rx - lx;
		if( pVisible[DIR_LEFT] != nullptr )
		{
			if( pVisible[DIR_RIGHT] == nullptr ) lx = w-cw;
			pVisible[DIR_LEFT]->SetWindowPos(x, y, lx, h, bRepaint);
		}
		if( bVisible ) CWindow::MoveWindow(x+lx, y, cw, h, bRepaint);
		if( pVisible[DIR_RIGHT] != nullptr )
		{
			pVisible[DIR_RIGHT]->SetWindowPos(x+cw+lx, y, w-cw-lx, h, bRepaint);
		}
	}
	else
	if( pVisible[DIR_TOP] != nullptr || pVisible[DIR_BOTTOM] != nullptr )
	{
		int ty = 0, by = 0;
		if( pVisible[DIR_TOP] != nullptr )
		{
			pVisible[DIR_TOP]->GetMinMaxInfo(&mm);
			ty = mm.ptMinTrackSize.y;
		}
		if( pVisible[DIR_BOTTOM] != nullptr )
		{
			pVisible[DIR_BOTTOM]->GetMinMaxInfo(&mm);
			by = mm.ptMinTrackSize.y;
		}
		int th = h - ch;
		if( th < ty+by ) ch = h - ty - by;
		if( pVisible[DIR_TOP] != nullptr )
		{
			if( pVisible[DIR_BOTTOM] == nullptr ) ty = h-ch;
			pVisible[DIR_TOP]->SetWindowPos(x, y, w, ty, bRepaint);
		}
		if( bVisible ) CWindow::MoveWindow(x, y+ty, w, ch, bRepaint);
		if( pVisible[DIR_BOTTOM] != nullptr )
		{
			pVisible[DIR_BOTTOM]->SetWindowPos(x, y+ch+ty, w, h-ch-ty, bRepaint);
		}
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * hbLOĂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CDockableWindow::IsDocking(void)
{
	return (m_pParent != nullptr);
}

/**********************************************************************//**
 *
 * hbLOĂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pWindow	= EBhE
 * @return	^Ul
*//***********************************************************************/
bool CDockableWindow::IsDocking(CWindow* pWindow)
{
	for( CDockList::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
	{
		if( *it == pWindow ) return true;
	}
	return false;
}

/**********************************************************************//**
 *
 * hbLOĂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CDockableWindow::IsHasChild(void)
{
	for( int i=0; i < DIR_NUM; ++i )
		if( m_pJoin[i] != nullptr ) return true;
	return false;
}

/**********************************************************************//**
 *
 * hbLOĂ  \Ԃǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CDockableWindow::IsHasVisibleChild(void)
{
	for( int i=0; i < DIR_NUM; ++i )
		if( GetVisibleJointWindow(i) != nullptr ) return true;
	return false;
}

/**********************************************************************//**
 *
 * ^Cgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	pWindow	= EBhE
*//***********************************************************************/
void CDockableWindow::SetTitle(CWindow* pWindow)
{
	if( pWindow == nullptr ) return;
	std::_tstring str;
	if( pWindow->GetWindowText(str) )
	{
		SetWindowText(str.c_str());
	}
}

/**********************************************************************//**
 *
 * ^uEBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CDockableWindow::CreateTabWindow(void)
{
	HGDIOBJ hFont = GetStockObject(DEFAULT_GUI_FONT);
	if( m_Tab.CreateEx(0
		, WS_CHILD | WS_TABSTOP | TCS_BOTTOM | TCS_FLATBUTTONS
		, 0, 0, 10, 10
		, m_hWnd
		, 0
		, nullptr
		) == nullptr ) return false;
	m_Tab.SetFont(hFont, 1);
	m_Tab.ShowWindow(SW_SHOW);
	return true;
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
 * @note	q󂯎WM_COMMAND߂̂܂ܐeɑM
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CDockableWindow::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_NCHITTEST:
		return OnNcHitTest(hWnd, wParam, lParam);
	case WM_GETMINMAXINFO:
		return OnMinMaxInfo(hWnd, wParam, lParam);
	case WM_SIZE:
		OnSize(hWnd, wParam, lParam);
		break;
	case WM_NOTIFY:
		OnNotify(hWnd, wParam, lParam);
		break;
	case WM_CLOSE:
		return OnClose(hWnd, wParam, lParam);
	}
	return CWindow::WndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * on WM_NCHITTEST
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CDockableWindow::OnNcHitTest(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
//	int x = LOWORD(lParam);
//	int y = HIWORD(lParam);
	RECT rc;
	GetWindowRect(&rc);
	LRESULT ret = CWindow::WndProc(hWnd, WM_NCHITTEST, wParam, lParam);
	// 
	switch( ret )
	{
	case HTCAPTION:
		ret = HTNOWHERE;
		break;
	case HTLEFT:
		if( GetVisibleJointWindow(DIR_LEFT) == nullptr ) ret = HTBORDER;
		break;
	case HTTOP:
		if( GetVisibleJointWindow(DIR_TOP) == nullptr ) ret = HTBORDER;
		break;
	case HTTOPLEFT:
		if( GetVisibleJointWindow(DIR_TOP ) != nullptr ) { ret =  HTTOP; break; }
		if( GetVisibleJointWindow(DIR_LEFT) != nullptr ) { ret = HTLEFT; break; }
		ret = HTBORDER;
		break;
	case HTTOPRIGHT:
		if( GetVisibleJointWindow(DIR_TOP  ) != nullptr ) { ret =   HTTOP; break; }
		if( GetVisibleJointWindow(DIR_RIGHT) != nullptr ) { ret = HTRIGHT; break; }
		ret = HTBORDER;
		break;
	case HTRIGHT:
		if( GetVisibleJointWindow(DIR_RIGHT) == nullptr ) ret = HTBORDER;
		break;
	case HTBOTTOM:
		if( GetVisibleJointWindow(DIR_BOTTOM) == nullptr ) ret = HTBORDER;
		break;
	case HTBOTTOMLEFT:
		if( GetVisibleJointWindow(DIR_BOTTOM) != nullptr ) { ret = HTBOTTOM; break; }
		if( GetVisibleJointWindow(DIR_LEFT  ) != nullptr ) { ret =  HTLEFT; break; }
		ret = HTBORDER;
		break;
	case HTBOTTOMRIGHT:
		if( GetVisibleJointWindow(DIR_BOTTOM) != nullptr ) { ret = HTBOTTOM; break; }
		if( GetVisibleJointWindow(DIR_RIGHT ) != nullptr ) { ret =  HTRIGHT; break; }
		ret = HTBORDER;
		break;
	}

	// max track size
	m_MaxTrackSize.x = rc.right-rc.left;
	m_MaxTrackSize.y = rc.bottom-rc.top;
	MINMAXINFO mm = {0};
	switch( ret )
	{
	case HTLEFT:
		m_pJoin[DIR_LEFT]->GetMinMaxInfo(&mm);
		m_MaxTrackSize.x += m_pJoin[DIR_LEFT]->GetWindowWidth() - mm.ptMinTrackSize.x;
		break;
	case HTRIGHT:
		m_pJoin[DIR_RIGHT]->GetMinMaxInfo(&mm);
		m_MaxTrackSize.x += m_pJoin[DIR_RIGHT]->GetWindowWidth() - mm.ptMinTrackSize.x;
		break;
	case HTTOP:
		m_pJoin[DIR_TOP]->GetMinMaxInfo(&mm);
		m_MaxTrackSize.y += m_pJoin[DIR_TOP]->GetWindowHeight() - mm.ptMinTrackSize.y;
		break;
	case HTBOTTOM:
		m_pJoin[DIR_BOTTOM]->GetMinMaxInfo(&mm);
		m_MaxTrackSize.y += m_pJoin[DIR_BOTTOM]->GetWindowHeight() - mm.ptMinTrackSize.y;
		break;
	}
	m_NcHitTest = (int)ret;
	return ret;
}

/**********************************************************************//**
 *
 * on WM_MINMAXINFO
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CDockableWindow::OnMinMaxInfo(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(wParam);
	LPMINMAXINFO lpmm = reinterpret_cast<LPMINMAXINFO>(lParam);
	lpmm->ptMinTrackSize.x = GetSystemMetrics(SM_CXSIZE)*2 + (GetSystemMetrics(SM_CXSIZEFRAME) + GetSystemMetrics(SM_CXBORDER)) * 2;
	lpmm->ptMinTrackSize.y = GetSystemMetrics(SM_CYMINTRACK) + (GetSystemMetrics(SM_CYSIZEFRAME) + GetSystemMetrics(SM_CYBORDER)) * 2;
	for( CDockList::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
	{
		MINMAXINFO mm = {0};
		(*it)->GetMinMaxInfo(&mm);
		if( mm.ptMinTrackSize.x > 0 && (lpmm->ptMinTrackSize.x < mm.ptMinTrackSize.x) )
			lpmm->ptMinTrackSize.x = mm.ptMinTrackSize.x;
		if( mm.ptMinTrackSize.y > 0 && (lpmm->ptMinTrackSize.y < mm.ptMinTrackSize.y) ) 
			lpmm->ptMinTrackSize.y = mm.ptMinTrackSize.y;

		if( mm.ptMaxTrackSize.x > 0 && (lpmm->ptMaxTrackSize.x > mm.ptMaxTrackSize.x) )
			lpmm->ptMaxTrackSize.x = mm.ptMaxTrackSize.x;
		if( mm.ptMaxTrackSize.y > 0 && (lpmm->ptMaxTrackSize.y > mm.ptMaxTrackSize.y) )
			lpmm->ptMaxTrackSize.y = mm.ptMaxTrackSize.y;
	}
	switch( m_NcHitTest )
	{
	case HTLEFT:
	case HTTOP:
	case HTRIGHT:
	case HTBOTTOM:
		lpmm->ptMaxTrackSize = m_MaxTrackSize;
		break;
	}
	return 0;
}

/**********************************************************************//**
 *
 * on WM_SIZE
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CDockableWindow::OnSize(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(wParam);
	int w = LOWORD(lParam);
	int h = HIWORD(lParam);
	RECT wrc, drc, rc;
	GetClientRectFromParent(&wrc);
	switch( m_NcHitTest )
	{
	case HTLEFT:
		{
			CDockableWindow* pDock = GetLeft();
			pDock->GetClientRectFromParent(&drc);
			pDock->SetWindowSize(wrc.left-drc.left, drc.bottom-drc.top, TRUE);
		}
		break;
	case HTTOP:
		{
			CDockableWindow* pDock = GetTop();
			pDock->GetClientRectFromParent(&drc);
			pDock->SetWindowSize(drc.right-drc.left, wrc.top-drc.top, TRUE);
		}
		break;
	case HTRIGHT:
		{
			CDockableWindow* pDock = GetRight();
			pDock->GetClientRectFromParent(&drc);
			pDock->MoveWindow(wrc.right, drc.top, drc.right-wrc.right, drc.bottom-drc.top, TRUE);
		}
		break;
	case HTBOTTOM:
		{
			CDockableWindow* pDock = GetBottom();
			pDock->GetClientRectFromParent(&drc);
			pDock->MoveWindow(drc.left, wrc.bottom, drc.right-drc.left, drc.bottom-wrc.bottom, TRUE);
		}
		break;
	}
	if( m_Tab.IsWindow() && m_Tab.IsWindowVisible() )
	{
		m_Tab.SetWindowSize(w, h, TRUE);
		m_Tab.GetDrawRect(&rc);
	}
	else
	{
		GetClientRect(&rc);
	}
	int dw = rc.right-rc.left;
	int dh = rc.bottom-rc.top;
	for( CDockList::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
	{
		(*it)->MoveWindow(rc.left, rc.top, dw, dh, TRUE);
	}
	return 0;
}

/**********************************************************************//**
 *
 * on WM_NCHITTEST
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CDockableWindow::OnNotify(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(wParam);
	switch(((NMHDR*)lParam)->code) 
	{
	// Ⴄy[Wꂽ
	case TCN_SELCHANGE:
		{
			for( CDockList::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
			{
				(*it)->ShowWindow(SW_HIDE);
			}
			int curr = m_Tab.GetCurSel();
			TCITEM item;
			m_Tab.GetItem(curr, &item);
			IRIS_ASSERT( item.mask & TCIF_PARAM );
			CWindow* pWindow = reinterpret_cast<CWindow*>(item.lParam);
			pWindow->ShowWindow(SW_SHOW);
			SetTitle(pWindow);
		}
		break;
	}
	return 0;
}

/**********************************************************************//**
 *
 * on WM_CLOSE
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CDockableWindow::OnClose(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(wParam);
	IRIS_UNUSED_VARIABLE(lParam);
	ShowWindow(SW_HIDE);
	IRIS_ASSERT( GetFrameWindow() != nullptr );
	GetFrameWindow()->CallSetDockableWindowPos();
	return 0;
}

// CDockingFrameWindow
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDockingFrameWindow::CDockingFrameWindow(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDockingFrameWindow::~CDockingFrameWindow(void)
{
	RelaseDockableWindow();
}

/**********************************************************************//**
 *
 * hbLO\ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pWindow	= EBhE
 * @return ^Ul
*//***********************************************************************/
bool CDockingFrameWindow::IsDockable(CWindow* pWindow)
{
	return Find(pWindow) != nullptr;
}

/**********************************************************************//**
 *
 * hbLOEBhEo^
 *
 ----------------------------------------------------------------------
 * @param [in]	pWindow	= EBhE
 * @return hbLOEBhENXAhX
*//***********************************************************************/
CDockableWindow* CDockingFrameWindow::Dockable(CWindow* pWindow)
{
	if( pWindow == nullptr ) return nullptr;
	CDockableWindow* pDock = new CDockableWindow;
	RECT rc;
	pWindow->GetWindowRect(&rc);
	ScreenToClientRect(pWindow->GetHWND(), &rc);
	if( pDock->Create(TEXT(""), rc, m_hWnd, nullptr, nullptr) == nullptr ) 
	{
		delete pDock;
		return nullptr;
	}
	pDock->Docking(pWindow);
	AttachObserver(pDock);
	return pDock;
}

/**********************************************************************//**
 *
 * hbLO
 *
 ----------------------------------------------------------------------
 * @param [in]	pParent	= eEBhE
 * @param [in]	dir		= hbLO
 * @param [in]	pWindow	= EBhE
 * @return 
*//***********************************************************************/
bool CDockingFrameWindow::Docking(CDockableWindow* pDock, CWindow* pWindow)
{
	IRIS_ASSERT( pDock != nullptr );
	return pDock->Docking(pWindow);
}

/**********************************************************************//**
 *
 * hbLO
 *
 ----------------------------------------------------------------------
 * @param [in]	pParent	= eEBhE
 * @param [in]	dir		= hbLO
 * @param [in]	pWindow	= EBhE
 * @return 
*//***********************************************************************/
bool CDockingFrameWindow::Joint(CDockableWindow* pParent, int dir, CDockableWindow* pWindow)
{
	IRIS_ASSERT( pParent != nullptr );
	return pParent->Joint(dir, pWindow);
}

/**********************************************************************//**
 *
 * hbLOEBhE
 *
 ----------------------------------------------------------------------
 * @param [in]	pWindow	= EBhE
 * @return hbLOEBhENXAhX
*//***********************************************************************/
CDockableWindow* CDockingFrameWindow::Find(CWindow* pWindow)
{
	return m_root.Find(pWindow);
}

/**********************************************************************//**
 *
 * \ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	pWindow		= EBhENX
 * @param [in]	nShowCmd	= \ݒ
 * @return	
*//***********************************************************************/
BOOL CDockingFrameWindow::ShowDockableWindow(CWindow* pWindow, int nShowCmd)
{
	CDockableWindow* pDock = Find(pWindow);
	if( pDock == nullptr ) return FALSE;
	pDock->ShowWindow(nShowCmd);
	return CallSetDockableWindowPos();
}

/**********************************************************************//**
 *
 * TCYݒ̃Zbg
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CDockingFrameWindow::CallSetDockableWindowPos(void)
{
	RECT rc;
	if( !GetClientRect(&rc) ) return FALSE;
	return m_root.SetWindowPos(0, 0, rc.right-rc.left, rc.bottom-rc.top, TRUE);
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
 * @note	q󂯎WM_COMMAND߂̂܂ܐeɑM
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CDockingFrameWindow::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_SIZE:
		{
			int w = LOWORD(lParam);
			int h = HIWORD(lParam);
			m_root.SetWindowPos(0, 0, w, h, TRUE);
		}
		break;
	}
	return CFrameWindow::WndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * evV[W󂯂bZ[WM
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= eEBhE
 * @param [in]	uMsg	= evV[W󂯂
 * @param [in]	wParam	= evV[W󂯂
 * @param [in]	lParam	= evV[W󂯂
*//***********************************************************************/
LRESULT	CDockingFrameWindow::RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_GETMINMAXINFO:
		{
			LPMINMAXINFO lpmm = reinterpret_cast<LPMINMAXINFO>(lParam);
			MINMAXINFO mm = {0};
			CWndProcSubject& subject = GetWndProcSubject();
			CWindow* pWindow = dcast<CWindow*>(subject.GetObserver());
			while( pWindow != nullptr )
			{
				MINMAXINFO tmm = {0};
				pWindow->GetMinMaxInfo(&tmm);
				if( tmm.ptMinTrackSize.x > 0 ) mm.ptMinTrackSize.x += tmm.ptMinTrackSize.x;
				if( tmm.ptMinTrackSize.y > 0 ) mm.ptMinTrackSize.y += tmm.ptMinTrackSize.y;
				pWindow = dcast<CWindow*>(pWindow->GetNext());
			}
			RECT wrc, crc;
			::GetWindowRect(hWnd, &wrc);
			::GetClientRect(hWnd, &crc);
			ClientToScreenRect(hWnd, &crc);
			mm.ptMinTrackSize.x += wrc.right-crc.right + crc.left-wrc.left;
			mm.ptMinTrackSize.y += wrc.bottom-crc.bottom + crc.top-wrc.top;

			if( lpmm->ptMinTrackSize.x < mm.ptMinTrackSize.x ) lpmm->ptMinTrackSize.x = mm.ptMinTrackSize.x;
			if( lpmm->ptMinTrackSize.y < mm.ptMinTrackSize.y ) lpmm->ptMinTrackSize.y = mm.ptMinTrackSize.y;
		}
		return 0;
	}
	return CFrameWindow::RecvParentMessage(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * o^ĂhbLOEBhE
 *
*//***********************************************************************/
void CDockingFrameWindow::RelaseDockableWindow(void)
{
	RelaseDockableWindow(m_root.GetLeft());
	RelaseDockableWindow(m_root.GetTop());
	RelaseDockableWindow(m_root.GetRight());
	RelaseDockableWindow(m_root.GetBottom());
}

/**********************************************************************//**
 *
 * o^ĂhbLOEBhE
 *
*//***********************************************************************/
void CDockingFrameWindow::RelaseDockableWindow(CDockableWindow* pWindow)
{
	if( pWindow == nullptr ) return;
	RelaseDockableWindow(pWindow->GetLeft());
	RelaseDockableWindow(pWindow->GetTop());
	RelaseDockableWindow(pWindow->GetRight());
	RelaseDockableWindow(pWindow->GetBottom());
	delete pWindow;
}

}	// end of namespace wx
}	// end of namespace iris
