//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXVariant.h
 * @brief		oAg^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 * 
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXVariant_H_
#define INCG_IRIS_WXVariant_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	VARIANT NX
*/
class CVariant : public IIrisObject
{
private:
	mutable VARIANT m_Var;	//!< oAg^

public:
	/// oAgێ^
	template<VARTYPE _Type>class Type
	{
		template<VARTYPE _TT>struct _type_impl
		{
			typedef void			type; 
		};
		template<> struct _type_impl<VT_I2>			{ typedef IrisS16		type; };
		template<> struct _type_impl<VT_I4>			{ typedef IrisS32		type; };
		template<> struct _type_impl<VT_R4>			{ typedef IrisF32		type; };
		template<> struct _type_impl<VT_R8>			{ typedef IrisF64		type; };
		template<> struct _type_impl<VT_CY>			{ typedef CY			type; };
		template<> struct _type_impl<VT_BSTR>		{ typedef BSTR			type; };
		template<> struct _type_impl<VT_DISPATCH>	{ typedef IDispatch		*type; };
		template<> struct _type_impl<VT_BOOL>		{ typedef bool			type; };
		template<> struct _type_impl<VT_VARIANT>	{ typedef CVariant		*type; };
		template<> struct _type_impl<VT_UNKNOWN>	{ typedef IUnknown		*type; };
		template<> struct _type_impl<VT_I1>			{ typedef IrisS8		type; };
		template<> struct _type_impl<VT_UI1>		{ typedef IrisU8		type; };
		template<> struct _type_impl<VT_UI2>		{ typedef IrisU16		type; };
		template<> struct _type_impl<VT_UI4>		{ typedef IrisU32		type; };
		template<> struct _type_impl<VT_I8>			{ typedef IrisS64		type; };
		template<> struct _type_impl<VT_UI8>		{ typedef IrisU64		type; };
		template<> struct _type_impl<VT_INT>		{ typedef IrisInt		type; };
		template<> struct _type_impl<VT_UINT>		{ typedef IrisUInt		type; };
		template<> struct _type_impl<VT_DECIMAL>	{ typedef DECIMAL		*type; };
		template<> struct _type_impl<VT_ARRAY>		{ typedef SAFEARRAY		*type; };
		template<> struct _type_impl<VT_VOID>		{ typedef void			type; };
		template<> struct _type_impl<VT_PTR>		{ typedef void			*type; };
	public:
		typedef typename _type_impl<_Type>::type type;
	};
	/// oAg^Cv
	template<typename _TN>class VT
	{
		template<typename _TT>struct _vt_impl_ref
		{
			enum { value = VT_RECORD };
		};
		template<typename _TT>struct _vt_impl_ref<_TT*>
		{ 
			enum { value = _vt_impl<_TT>::value | VT_BYREF };
		};

		template<typename _TT>struct _vt_impl
		{ 
			enum { value = _vt_impl_ref<_TT>::value };
		};
		template<> struct _vt_impl<signed short>		{ enum { value = VT_I2 }; };
		template<> struct _vt_impl<signed long>			{ enum { value = VT_I4 }; };
		template<> struct _vt_impl<float>				{ enum { value = VT_R4 }; };
		template<> struct _vt_impl<double>				{ enum { value = VT_R8 }; };
		template<> struct _vt_impl<CY>					{ enum { value = VT_CY }; };
		template<> struct _vt_impl<BSTR>				{ enum { value = VT_BSTR }; };
		//template<> struct _vt_impl<DATE>				{ enum { value = VT_DATE }; };
		template<> struct _vt_impl<IDispatch*>			{ enum { value = VT_DISPATCH }; };
		template<> struct _vt_impl<bool>				{ enum { value = VT_BOOL }; };
		template<> struct _vt_impl<CVariant*>			{ enum { value = VT_VARIANT }; };
		template<> struct _vt_impl<VARIANT>				{ enum { value = VT_VARIANT }; };
		template<> struct _vt_impl<IUnknown*>			{ enum { value = VT_UNKNOWN }; };
		template<> struct _vt_impl<char>				{ enum { value = VT_I1 }; };
		template<> struct _vt_impl<signed char>			{ enum { value = VT_I1 }; };
		template<> struct _vt_impl<unsigned char>		{ enum { value = VT_UI1 }; };
		template<> struct _vt_impl<unsigned short>		{ enum { value = VT_UI2 }; };
		template<> struct _vt_impl<unsigned long>		{ enum { value = VT_UI4 }; };
		template<> struct _vt_impl<LONGLONG>			{ enum { value = VT_I8 }; };
		template<> struct _vt_impl<ULONGLONG>			{ enum { value = VT_UI8 }; };
		template<> struct _vt_impl<signed int>			{ enum { value = VT_INT }; };
		template<> struct _vt_impl<unsigned int>		{ enum { value = VT_UINT }; };
		template<> struct _vt_impl<LPDECIMAL>			{ enum { value = VT_DECIMAL }; };
		template<> struct _vt_impl<LPSAFEARRAY>			{ enum { value = VT_ARRAY }; };
		template<> struct _vt_impl<void>				{ enum { value = VT_VOID }; };
		template<> struct _vt_impl<LPVOID>				{ enum { value = VT_PTR }; };

	public:
		enum { value = _vt_impl<_TN>::value };
	};

public:
	/**
	 * @brief	RXgN^
	*/
	CVariant(void)
	{
		VariantInit(&m_Var);
	}
	/**
	 * @brief	RXgN^
	 * @tparam [in]	_TN	= l^
	 * @param [in]	v = l
	*/
	template<typename _TN>
	CVariant(_TN v)
	{
		init(v);
	}
	/**
	 * @brief	RXgN^
	 * @param [in]	var = CVariant
	*/
	CVariant(const CVariant& var)
	{
		copy(var);
	}

	/**
	 * @brief	fXgN^
	*/
	~CVariant(void)
	{
		clear();
	}

public:
	/**
	 * @brief	NA
	*/
	void	clear(void)
	{
		VariantClear(&m_Var);
	}

	/**
	 * @brief	Rs[
	 * @param [in]	var = CVariant
	*/
	void	copy(const CVariant& var)
	{
		clear();
		VariantInit(&m_Var);
		VariantCopy(&m_Var, &var.m_Var);
	}

	/**
	 * @brief	LXg
	*/
	void	cast(VARTYPE vt)
	{
		VariantChangeType(&m_Var, &m_Var, 0, vt);
	}

public:
	/**
	 * @brief	
	 * @tparam [in]	_TN	= ^
	 * @param [in]	val = l
	*/
	template<typename _TN>
	void	init(_TN val)
	{
		VariantInit(&m_Var);
		reference<_TN>() = val;
		m_Var.vt = VT<_TN>::value;
	}

public:
	/**
	 * @brief	l̐ݒ
	 * @tparam [in]	_TN	= ^
	 * @param [in]	val = l
	*/
	template<typename _TN>
	void	assign(_TN val)
	{
		if( m_Var.vt == VT<_TN>::value )
		{
			reference<_TN>() = val;
		}
		else
		{
			clear();
			init(val);
		}
	}

public:
	/**
	 * @brief	l̎擾
	 * @tparam [in]	_TN	= o͌^
	 * @return	l
	*/
	template<typename _TN>
	_TN			value(void)
	{
		if( VT<_TN>::value == m_Var.vt )
			return *(reinterpret_cast<_TN*>(&m_Var.dblVal));
		CVariant var(*this);
		var.cast(VT<_TN>::value);
		return var.value<_TN>();
	}

	/**
	 * @brief	ϐ̎擾
	 * @tparam [in]	_TN	= ϐ̌^
	 * @return	ϐ̎Qƌ^
	*/
	template<typename _TN>
	_TN&		reference(void)
	{
		return *(reinterpret_cast<_TN*>(&m_Var.dblVal));
	}

	/**
	 * @brief	oAg^Cv
	 * @return	oAg^Cv
	*/
	VARTYPE		type(void)
	{
		return m_Var.vt;
	}

public:
	void		round(int decimals)
	{
		VarRound(&m_Var, decimals, &m_Var);
	}


public:
	template<typename _TN>
	void	operator = (const _TN& v)			{ assign(v); }

	template<typename _TN>
	operator _TN	(void)						{ return value<_TN>(); }
	template<typename _TN>
	operator const _TN	(void)			const	{ return value<_TN>(); }


#if	!defined(IRIS_WIN32_WCE)
	bool	operator == (const CVariant& v)	const
	{ 
		CVariant var = v;
		if( var.m_Var.vt != m_Var.vt ) var.cast(m_Var.vt);
		HRESULT hr = VarCmp(&m_Var, &var.m_Var, 0, 0);
		if( FAILED(hr) )
			return *reinterpret_cast<u64*>(&m_Var.dblVal) == *reinterpret_cast<u64*>(&var.m_Var.dblVal);
		return hr == VARCMP_EQ;
	}
	bool	operator <  (const CVariant& v)	const
	{
		HRESULT hr = VarCmp(&m_Var, &v.m_Var, 0, 0);
		// TODO : 
		if( FAILED(hr) )
			return *reinterpret_cast<u64*>(&m_Var.dblVal) < *reinterpret_cast<u64*>(&v.m_Var.dblVal);
		return hr == VARCMP_LT;
	}
	bool	operator >  (const CVariant& v)	const
	{
		HRESULT hr = VarCmp(&m_Var, &v.m_Var, 0, 0);
		// TODO : 
		if( FAILED(hr) )
			return *reinterpret_cast<u64*>(&m_Var.dblVal) > *reinterpret_cast<u64*>(&v.m_Var.dblVal);
		return hr == VARCMP_GT;
	}
	bool	operator <= (const CVariant& v)	const	{ HRESULT hr = VarCmp(&m_Var, &v.m_Var, (LCID)LOCALE_SYSTEM_DEFAULT, 0); return (hr == VARCMP_LT) || (hr == VARCMP_EQ); }
	bool	operator >= (const CVariant& v)	const	{ HRESULT hr = VarCmp(&m_Var, &v.m_Var, (LCID)LOCALE_SYSTEM_DEFAULT, 0); return (hr == VARCMP_GT) || (hr == VARCMP_EQ); }

	const CVariant	operator + (CVariant& v)	{ CVariant ret; VarAdd(&m_Var, &v.m_Var, &ret.m_Var); return ret; }
	CVariant&		operator += (CVariant& v)	{ VarAdd(&m_Var, &v.m_Var, &m_Var); return *this; }
	const CVariant	operator - (CVariant& v)	{ CVariant ret; VarSub(&m_Var, &v.m_Var, &ret.m_Var); return ret; }
	CVariant&		operator -= (CVariant& v)	{ VarSub(&m_Var, &v.m_Var, &m_Var); return *this; }
	const CVariant	operator * (CVariant& v)	{ CVariant ret; VarMul(&m_Var, &v.m_Var, &ret.m_Var); return ret; }
	CVariant&		operator *= (CVariant& v)	{ VarMul(&m_Var, &v.m_Var, &m_Var); return *this; }
	const CVariant	operator / (CVariant& v)	{ CVariant ret; VarDiv(&m_Var, &v.m_Var, &ret.m_Var); return ret; }
	CVariant&		operator /= (CVariant& v)	{ VarDiv(&m_Var, &v.m_Var, &m_Var); return *this; }
	const CVariant	operator & (CVariant& v)	{ CVariant ret; VarAnd(&m_Var, &v.m_Var, &ret.m_Var); return ret; }
	CVariant&		operator &= (CVariant& v)	{ VarAnd(&m_Var, &v.m_Var, &m_Var); return *this; }
	const CVariant	operator | (CVariant& v)	{ CVariant ret; VarOr(&m_Var, &v.m_Var, &ret.m_Var); return ret; }
	CVariant&		operator |= (CVariant& v)	{ VarOr(&m_Var, &v.m_Var, &m_Var); return *this; }
	const CVariant	operator ^ (CVariant& v)	{ CVariant ret; VarXor(&m_Var, &v.m_Var, &ret.m_Var); return ret; }
	CVariant&		operator ^= (CVariant& v)	{ VarXor(&m_Var, &v.m_Var, &m_Var); return *this; }
	CVariant&		operator ! (void)			{ VarNot(&m_Var, &m_Var); return *this; }
#endif

};

}	// end of namespace wx
}	// end of namespace iris

#endif
