//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSafeArray.h
 * @brief		WXSafeArray t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSafeArray_H_
#define INCG_IRIS_WXSafeArray_H_

//======================================================================
// include
#include "WXVariant.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	SAFEARRAY NX
 * @note	P̂ݑΉ
 * @tparam _TN	= i[^
 * @tparam _VT	= i[^̃^Cvl
*/
template< typename _TN, u16 _VT=wx::CVariant::VT<_TN>::value >
class CSafeArray : public IIrisObject
{
	typedef CSafeArray<_TN>	_Myt;
public:
	typedef _TN	value_type;
	typedef _TN	*value_ptr;
	typedef _TN	&value_ref;

	enum 
	{
		VT = _VT,	//!< i[^̃^Cv
	};

public:
	/**
	 * @brief	vfNX
	*/
	class CElement : public INonCopyable<CElement>
	{
		friend CSafeArray;
	private:
		LPSAFEARRAY	m_array;
		value_ptr	m_ptr;
		u8			m_unlock;
	private:
		CElement(LPSAFEARRAY pArray, value_ptr ptr, u8 unlock=1) : m_array(pArray), m_ptr(ptr), m_unlock(unlock) {}
	public:
		// Rs[ł͂Ȃړ
		CElement(CElement& obj) : m_array(obj.m_array), m_ptr(obj.m_ptr), m_unlock(obj.m_unlock)
		{
			obj.m_array = nullptr;
			obj.m_ptr = nullptr;
		}
		~CElement(void) 
		{ 
			if( m_ptr != nullptr ) 
			{
				HRESULT hr = S_OK;
				switch( m_unlock )
				{
				case 0:
					break;
				case 1:
					hr = SafeArrayUnlock(m_array);
					break;
				default:
					hr = SafeArrayUnaccessData(m_array);
					break;
				}
				IRIS_ASSERT( SUCCEEDED(hr) );
			}
		}
	public:
		operator value_type	(void)			const	{ return *m_ptr; }
		CElement& operator = (value_type v)			{ *m_ptr = v; return *this; }
		bool	operator == (value_type v)	const	{ return *m_ptr == v; }

		template<typename _TT>
		value_ref	operator [] (_TT idx)	{ return m_ptr[idx]; }
	};

protected:
	LPSAFEARRAY		m_pArray;	//!< zi[^
	SAFEARRAYBOUND	m_Bound;
public:

	/**
	 * @brief	RXgN^
	*/
	CSafeArray(void) : m_pArray(nullptr)	{}

	/**
	 * @brief	RXgN^
	 * @param [in]	ulElement	= vf
	 * @param [in]	lLbound		= ̉(擪AhX[]CfbNX)
	*/
	CSafeArray(ULONG ulElement, LONG lLbound=0)
		: m_pArray(nullptr)
	{
		resize(ulElement, lLbound);
	}

	/**
	 * @brief	Rs[RXgN^
	 * @param [in]	rObj	= Rs[
	*/
	CSafeArray(const _Myt& rObj)
	{
		copy(rObj);
	}

	/**
	 * @brief	fXgN^
	*/
	~CSafeArray(void)
	{
		release();
	}

public:
	/**
	 * @brief	z̍쐬
	 * @param [in]	ulElement	= vf
	 * @param [in]	lLbound		= ̉(擪AhX[]CfbNX)
	*/
	void	resize(ULONG ulElement, LONG lLbound=0)
	{
		release();
#if 0
		m_pArray = SafeArrayCreateVector(_VT, lLbound, ulElement);
#else
		m_Bound.lLbound = lLbound, m_Bound.cElements = ulElement;
		m_pArray = SafeArrayCreate(_VT, 1, &m_Bound);
#endif
	}

	/**
	 * @brief	
	*/
	void	release(void)
	{
		if( m_pArray != nullptr )
		{
			SafeArrayDestroy(m_pArray);
			m_pArray = nullptr;
		}
	}

public:
	/**
	 * @brief	Rs[
	 * @param [in]	rArray	= Rs[
	 * @return	
	*/
	bool	copy(const _Myt& rArray)
	{
		release();
		return SUCCEEDED(SafeArrayCopy(rArray.m_pArray, &m_pArray));
	}

	/**
	 * @brief	f[^̃Rs[
	 * @param [in]	rArray	= Rs[
	 * @return	
	*/
	bool	copy_data(const _Myt& rArray)
	{
		if( !is_valid() ) return false;
		return SUCCEEDED( SafeArrayCopyData(rArray.m_pArray, m_pArray) );
	}

public:

	/**
	 * @brief	LȃoێĂ邩ǂ
	 * @return	^Ul
	*/
	bool	is_valid(void)
	{
		return m_pArray != nullptr;
	}

	/**
	 * @brief	󂩂ǂ
	 * @return	^Ul
	*/
	bool	empty(void)
	{
		if( m_pArray == nullptr ) return true;
		return size() == 0;
	}

public:
	/**
	 * @brief	[] Iy[^
	 * @note	擾unlock邱
	 * @param [in]	index	= CfbNX
	 * @return	vf
	*/
	template<typename _TT>
	value_ref	operator []	(_TT index)	{ return at(static_cast<LONG>(index)); }
	//template<typename _TT>
	//CElement	operator []	(_TT index)	{ return at(static_cast<LONG>(index)); }

public:
	/**
	 * @brief	̎擾
	 * @return	
	*/
	UINT	dim(void)
	{
		return SafeArrayGetDim(m_pArray);
	}

	/**
	 * @brief	vf̃oCgTCY̎擾
	 * @return	vf̃oCgTCY
	*/
	UINT	elem_size(void)
	{
		return SafeArrayGetElemsize(m_pArray);
	}

	/**
	 * @brief	vf̎擾
	 * @param [in]	dim	= 
	 * @return	vf
	*/
	UINT	size(UINT dim=0)
	{
		if( !is_valid() ) return 0;
		return m_Bound.cElements;
		//return ubound(dim) - lbound(dim) + 1;
	}

	/**
	 * @brief	̉擾
	 * @param [in]	dim	= 
	 * @return	̉
	*/
	LONG	lbound(UINT dim=0)
	{
		LONG lb = 0;
		HRESULT hr = SafeArrayGetLBound(m_pArray, dim, &lb);
		IRIS_VERIFY( SUCCEEDED(hr) );
		return lb;
	}

	/**
	 * @brief	̏擾
	 * @param [in]	dim	= 
	 * @return	̏
	*/
	LONG	ubound(UINT dim=0)
	{
		LONG ub = 0;
		HRESULT hr = SafeArrayGetUBound(m_pArray, dim, &ub);
		IRIS_VERIFY( SUCCEEDED(hr) );
		return ub;
	}

public:
	/**
	 * @brief	vfANZX
	 * @note	擾unlock邱
	 * @prarm [in]	uIndex	= CfbNX
	 * @return	f[^
	*/
#if 1
	value_ref	at(LONG uIndex)
	{
		value_ptr ptr = nullptr;
		SafeArrayPtrOfIndex(m_pArray, &uIndex, reinterpret_cast<void**>(&ptr) );
		IRIS_ASSERT( ptr != nullptr );
		return *ptr;
	}
#else
	CElement	at(LONG uIndex)
	{
		value_ptr ptr = nullptr;
		if( FAILED(SafeArrayPtrOfIndex(m_pArray, &uIndex, reinterpret_cast<void**>(&ptr) ) ) )
		{
			return CElement(m_pArray, nullptr);
		}
		IRIS_ASSERT( ptr != nullptr );
		return CElement(m_pArray, ptr, 0);
	}
#endif

	/**
	 * @brief	vf擾
	 * @prarm [in]	uIndex	= CfbNX
	 * @return	f[^
	*/
	value_type	get(LONG uIndex)
	{
		value_type val;
		HRESULT hr = SafeArrayGetElement(m_pArray, &uIndex, reinterpret_cast<void*>(&val));
		IRIS_ASSERT( SUCCEEDED(hr) );
		return val;
	}

	/**
	 * @brief	vfݒ
	 * @param [in]	uIndex	= CfbNX
	 * @param [in]	value	= l
	*/
	void		assign(LONG uIndex, value_type value)
	{
		SafeArrayPutElement(m_pArray, &uIndex, &value);
	}

	/**
	 * @brief	vf̃NA
	*/
	void		clear(void)
	{
		SafeArrayDestroyData(m_pArray);
	}

public:

	/**
	 * @brief	f[^̎擾
	 * @return	obt@
	*/
	CElement	data(void)
	{
		value_ptr addr = nullptr;
		if( FAILED( SafeArrayAccessData(m_pArray, reinterpret_cast<void**>(&addr)) ) )
			return CElement(m_pArray, nullptr);
		return CElement(m_pArray, addr, 2);
	}

	/**
	 * @brief	f[^ANZX̃AbN
	*/
	void		unaccess(void)
	{
		SafeArrayUnaccessData(m_pArray);
	}

	/**
	 * @brief	bN
	 * @return	obt@
	*/
	bool		lock(void)
	{
		if( FAILED(SafeArrayLock(m_pArray) ) ) return false;
		return true;
	}

	/**
	 * @brief	AbN
	*/
	void		unlock(void)
	{
		SafeArrayUnlock(m_pArray);
	}
	 


};

}	// end of namespace wx
}	// end of namespace iris

#endif
