//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCurrentDirectory.h
 * @brief		CurrentDirectory t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXCurrentDirectory_H_
#define INCG_IRIS_WXCurrentDirectory_H_

//======================================================================
// include
#include "iris_object.h"
#include <vector>
#include <string>

#if	defined(IRIS_WIN32_WCE)
#error not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// declare
class CCurrentDirectoryA;
class CCurrentDirectoryW;

//======================================================================
// typedef
#ifdef UNICODE
typedef CCurrentDirectoryW	CCurrentDirectory;
#else
typedef CCurrentDirectoryA	CCurrentDirectory;
#endif

//======================================================================
// class
/**
 * @brief	}`oCg JgfBNgNX
*/
class CCurrentDirectoryA : public IIrisObject
{
	typedef	std::string				_Mystring;
	typedef std::vector<_Mystring>	_Myvec;
private:
	_Myvec	m_Store;	//!< ޔ
public:
	// RXgN^
	CCurrentDirectoryA(void);
	// fXgN^
	~CCurrentDirectoryA(void);

public:
	// JgfBNgpX̎擾
	BOOL	GetPath(DWORD dwLength, LPSTR lpPath)	const;
	LPSTR	GetPath(void)	const;
public:
	// ݂̐ݒޔĐݒ
	BOOL	Push(LPCSTR lpDirectory);
	// ޔݒP߂
	BOOL	Pop(void);
	// ޔݒׂĖ߂
	BOOL	PopAll(void);

public:
	operator LPSTR	(void)			{ return GetPath(); }
	operator LPCSTR	(void)	const	{ return GetPath(); }
};

/**
 * @brief	UNICODE JgfBNgNX
*/
class CCurrentDirectoryW : public IIrisObject
{
	typedef	std::wstring			_Mystring;
	typedef std::vector<_Mystring>	_Myvec;
private:
	_Myvec	m_Store;	//!< ޔ
public:
	// RXgN^
	CCurrentDirectoryW(void);
	// fXgN^
	~CCurrentDirectoryW(void);

public:
	// JgfBNgpX̎擾
	BOOL	GetPath(DWORD dwLength, LPWSTR lpPath)	const;
	LPWSTR	GetPath(void)	const;
public:
	// ݂̐ݒޔĐݒ
	BOOL	Push(LPCWSTR lpDirectory);
	// ޔݒP߂
	BOOL	Pop(void);
	// ޔݒׂĖ߂
	BOOL	PopAll(void);

public:
	operator LPWSTR		(void)			{ return GetPath(); }
	operator LPCWSTR	(void)	const	{ return GetPath(); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
