//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCurrentDirectory.cpp
 * @brief		CurrentDirectory t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCurrentDirectory_CPP_

//======================================================================
// include
#include "WXCurrentDirectory.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

// CCurrentDirectoryA
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCurrentDirectoryA::CCurrentDirectoryA(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCurrentDirectoryA::~CCurrentDirectoryA(void)
{
	PopAll();
}

/**********************************************************************//**
 *
 * JgfBNgpX̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	dwLength	= o͕
 * @param [out]	lpPath		= o̓obt@
 * @return	
*//***********************************************************************/
BOOL CCurrentDirectoryA::GetPath(DWORD dwLength, LPSTR lpPath) const
{
	return ::GetCurrentDirectoryA(dwLength, lpPath);
}

/**********************************************************************//**
 *
 * JgfBNgpX̎擾
 *
 -----------------------------------------------------------------------
 * @return	JgfBNg
*//***********************************************************************/
LPSTR CCurrentDirectoryA::GetPath(void) const
{
	static CHAR path[MAX_PATH];
	GetPath(MAX_PATH, path);
	return path;
}

/**********************************************************************//**
 *
 * ݂̐ݒޔĐݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpDirectory	= VJgfBNg
 * @return	
*//***********************************************************************/
BOOL CCurrentDirectoryA::Push(LPCSTR lpDirectory)
{
	IRIS_ASSERT( lpDirectory != nullptr );
	CHAR path[MAX_PATH];
	::GetCurrentDirectoryA(MAX_PATH, path);
	m_Store.push_back(path);
	return ::SetCurrentDirectoryA(lpDirectory);
}

/**********************************************************************//**
 *
 * ޔݒP߂
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CCurrentDirectoryA::Pop(void)
{
	if( m_Store.size() == 0 ) return FALSE;
	_Mystring path = m_Store.back();
	m_Store.pop_back();
	return ::SetCurrentDirectoryA(path.c_str());
}

/**********************************************************************//**
 *
 * ޔݒׂĖ߂
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CCurrentDirectoryA::PopAll(void)
{
	if( m_Store.size() == 0 ) return FALSE;
	_Mystring path = *m_Store.begin();
	m_Store.clear();
	return ::SetCurrentDirectoryA(path.c_str());
}

// CCurrentDirectoryW
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCurrentDirectoryW::CCurrentDirectoryW(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCurrentDirectoryW::~CCurrentDirectoryW(void)
{
	PopAll();
}

/**********************************************************************//**
 *
 * JgfBNgpX̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	dwLength	= o͕
 * @param [out]	lpPath		= o̓obt@
 * @return	
*//***********************************************************************/
BOOL CCurrentDirectoryW::GetPath(DWORD dwLength, LPWSTR lpPath) const
{
	return ::GetCurrentDirectoryW(dwLength, lpPath);
}

/**********************************************************************//**
 *
 * JgfBNgpX̎擾
 *
 -----------------------------------------------------------------------
 * @return	JgfBNg
*//***********************************************************************/
LPWSTR CCurrentDirectoryW::GetPath(void) const
{
	static WCHAR path[MAX_PATH];
	GetPath(MAX_PATH, path);
	return path;
}

/**********************************************************************//**
 *
 * ݂̐ݒޔĐݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpDirectory	= VJgfBNg
 * @return	
*//***********************************************************************/
BOOL CCurrentDirectoryW::Push(LPCWSTR lpDirectory)
{
	IRIS_ASSERT( lpDirectory != nullptr );
	WCHAR path[MAX_PATH];
	::GetCurrentDirectoryW(MAX_PATH, path);
	m_Store.push_back(path);
	return ::SetCurrentDirectoryW(lpDirectory);
}

/**********************************************************************//**
 *
 * ޔݒP߂
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CCurrentDirectoryW::Pop(void)
{
	if( m_Store.size() == 0 ) return FALSE;
	_Mystring path = m_Store.back();
	m_Store.pop_back();
	return ::SetCurrentDirectoryW(path.c_str());
}

/**********************************************************************//**
 *
 * ޔݒׂĖ߂
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CCurrentDirectoryW::PopAll(void)
{
	if( m_Store.size() == 0 ) return FALSE;
	_Mystring path = *m_Store.begin();
	m_Store.clear();
	return ::SetCurrentDirectoryW(path.c_str());
}

}	// end of namespace wx
}	// end of namespace iris

