//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWindow.h
 * @brief		EBhEx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXWindow_H_
#define INCG_IRIS_WXWindow_H_

//======================================================================
// include
#include "WXWindowProc.h"
#include <map>
#include <string>

#if	defined(IRIS_WIN32_WCE)
#  include <commctrl.h>
#endif

//======================================================================
// define
#define WC_WXWINDOWA	"WXWindow"
#define WC_WXWINDOWW	L"WXWindow"
#ifdef UNICODE
#define WC_WXWINDOW		WC_WXWINDOWW
#else
#define WC_WXWINDOW		WC_WXWINDOWA
#endif

namespace iris {
namespace wx
{

//======================================================================
// function
// NCAg̈悩XN[̈ɕϊ
BOOL	ClientToScreenRect(HWND hWnd, LPRECT lprc);
// XN[̈悩NCAg̈ɕϊ
BOOL	ScreenToClientRect(HWND hWnd, LPRECT lprc);

//======================================================================
// class
//! EBhEx[XNX
class CWindow : public CWndProcObserver, public CWindowProc
{
public:
	typedef std::map<HWND, CWindow*>	CWndMap;
	typedef std::pair<HWND, CWindow*>	CWndPair;
private:
    static CWndMap	s_WndMap;	// EBhEXg
protected:
    static CWindow*	s_pWindow;	//!< WM_CREATEp̃[NGA
protected:
	HWND				m_hWnd;	//!< EBhEnh

private:
	// Observer
	CWndProcSubject		m_Subject;

public:
	// RXgN^
	CWindow(void);
	CWindow(HWND hWnd);
	// fXgN^
	virtual ~CWindow(void);
	
protected:
	// set, get
	void	SetHWND(HWND hWnd)		{ m_hWnd = hWnd; }
public:
	// set, get
	virtual	HWND	GetHWND(void)	{ return m_hWnd; }
    // EBhEnh̎擾
	HWND	operator()(void)		{ return GetHWND(); }
			operator HWND (void)	{ return GetHWND(); }
public:
    // EBhEXgɕt
	virtual	bool	Attach(HWND hWnd);
	// EBhEXgO
			HWND	Detach(void);
public:
	// EBhE
	static CWindow*	Find(HWND hWnd);

public:
	// Observer
	CWndProcSubject&	GetWndProcSubject(void)						{ return m_Subject; }
	virtual void		AttachObserver(CWndProcObserver* observer)	{ m_Subject.AttachObserver(observer); }
	virtual bool		InsertObserver(CWndProcObserver* pos, CWndProcObserver* observer)	
																	{ return m_Subject.InsertObserver(pos, observer); }
	virtual void		DetachObserver(CWndProcObserver* observer)	{ m_Subject.DetachObserver(observer); }

public:
    // EBhEvV[W
    static LRESULT CALLBACK _DefWindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

protected:
	// bZ[WO
	virtual BOOL PreTranslateMessage(LPMSG msg) { IRIS_UNUSED_VARIABLE(msg); return FALSE; }
public:
	// EBhENX̓o^
	static	ATOM RegisterClassA(UINT uStyle, HINSTANCE hInstance
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCSTR pClassName = WC_WXWINDOWA
							   , LPCSTR pMenuName = nullptr
							   , WNDPROC wndproc = _DefWindowProc );
	static	ATOM RegisterClassW(UINT uStyle, HINSTANCE hInstance
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCWSTR pClassName = WC_WXWINDOWW
							   , LPCWSTR pMenuName = nullptr
							   , WNDPROC wndproc = _DefWindowProc );
#if	defined(IRIS_WIN32_WCE)
	static	ATOM RegisterClassEx (UINT uStyle, HINSTANCE hInstance
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCTSTR pClassName = WC_WXWINDOW
							   , LPCTSTR pMenuName = nullptr, HICON hIconSm = nullptr
							   , WNDPROC wndproc = _DefWindowProc );
#endif
	static	ATOM RegisterClassExA(UINT uStyle, HINSTANCE hInstance
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCSTR pClassName = WC_WXWINDOWA
							   , LPCSTR pMenuName = nullptr, HICON hIconSm = nullptr
							   , WNDPROC wndproc = _DefWindowProc );
	static	ATOM RegisterClassExW(UINT uStyle, HINSTANCE hInstance
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCWSTR pClassName = WC_WXWINDOWW
							   , LPCWSTR pMenuName = nullptr, HICON hIconSm = nullptr
							   , WNDPROC wndproc = _DefWindowProc );

   // EBhE̍쐬
    virtual HWND Create(LPCTSTR lpszClassName
					 , LPCTSTR lpszWindowName, DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr);
    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle, LPCTSTR lpszClassName
					   , LPCTSTR lpszWindowName, DWORD dwStyle
					   , const RECT &rRect
					   , HWND hWndParent, UINT nID
					   , HINSTANCE hInstance
					   , void *pParam = nullptr);

    // EBhE̍쐬
    virtual HWND CreateWindowExA(DWORD dwExStyle, LPCSTR pClassName
							  , LPCSTR pWindowName, DWORD dwStyle
							  , int nX, int nY, int nWidth, int nHeight
							  , HWND hWndParent = nullptr, HMENU hMenu = nullptr
							  , HINSTANCE hInstance = nullptr, void *pParam = nullptr );

    // EBhE̍쐬
    virtual HWND CreateWindowExW(DWORD dwExStyle, LPCWSTR pClassName
							  , LPCWSTR pWindowName, DWORD dwStyle
							  , int nX, int nY, int nWidth, int nHeight
							  , HWND hWndParent = nullptr, HMENU hMenu = nullptr
							  , HINSTANCE hInstance = nullptr, void *pParam = nullptr );

public:

	// function wrap
	int		MessageBoxA(LPCSTR  lpText, LPCSTR  lpCaption, UINT uType)	{ return ::MessageBoxA(m_hWnd, lpText, lpCaption, uType); }
	int		MessageBoxW(LPCWSTR lpText, LPCWSTR lpCaption, UINT uType)	{ return ::MessageBoxW(m_hWnd, lpText, lpCaption, uType); }
	BOOL	YesNoBoxA(LPCSTR  lpText, LPCSTR  lpCaption)				{ return IRIS_TO_BOOL(MessageBoxA(lpText, lpCaption, MB_YESNO) == IDYES); }
	BOOL	YesNoBoxW(LPCWSTR lpText, LPCWSTR lpCaption)				{ return IRIS_TO_BOOL(MessageBoxW(lpText, lpCaption, MB_YESNO) == IDYES); }
#ifdef UNICODE
	BOOL	YesNoBox (LPCWSTR lpText, LPCWSTR lpCaption)				{ return YesNoBoxW(lpText, lpCaption); }
#else
	BOOL	YesNoBox (LPCSTR  lpText, LPCSTR  lpCaption)				{ return YesNoBoxA(lpText, lpCaption); }
#endif

	LRESULT	SendMessageA(UINT Msg, WPARAM wParam, LPARAM lParam)		{ return ::SendMessageA(m_hWnd, Msg, wParam, lParam); }
	LRESULT	SendMessageW(UINT Msg, WPARAM wParam, LPARAM lParam)		{ return ::SendMessageW(m_hWnd, Msg, wParam, lParam); }

	BOOL	PostMessageA(UINT Msg, WPARAM wParam, LPARAM lParam)		{ return ::PostMessageA(m_hWnd, Msg, wParam, lParam); }
	BOOL	PostMessageW(UINT Msg, WPARAM wParam, LPARAM lParam)		{ return ::PostMessageW(m_hWnd, Msg, wParam, lParam); }

	BOOL	SetWindowTextA(LPCSTR  lpText)								{ return ::SetWindowTextA(m_hWnd, lpText); }
	BOOL	SetWindowTextW(LPCWSTR lpText)								{ return ::SetWindowTextW(m_hWnd, lpText); }
	int		GetWindowTextA(LPSTR  lpText, int nMaxCount)	const		{ return ::GetWindowTextA(m_hWnd, lpText, nMaxCount); }
	int		GetWindowTextW(LPWSTR lpText, int nMaxCount)	const		{ return ::GetWindowTextW(m_hWnd, lpText, nMaxCount); }
	int		GetWindowTextLengthA(void)	const							{ return ::GetWindowTextLengthA(m_hWnd); }
	int		GetWindowTextLengthW(void)	const							{ return ::GetWindowTextLengthW(m_hWnd); }

	LONG	SetWindowLongA(int nIndex, LONG dwNewLong)				{ return ::SetWindowLongA(m_hWnd, nIndex, dwNewLong); }
	LONG	SetWindowLongW(int nIndex, LONG dwNewLong)				{ return ::SetWindowLongW(m_hWnd, nIndex, dwNewLong); }
	LONG	GetWindowLongA(int nIndex)	const						{ return ::GetWindowLongA(m_hWnd, nIndex); }
	LONG	GetWindowLongW(int nIndex)	const						{ return ::GetWindowLongW(m_hWnd, nIndex); }
#ifdef _WIN64
	LONG_PTR	SetWindowLongPtrA(int nIndex, LONG_PTR dwNewLong)	{ return ::SetWindowLongPtrA(m_hWnd, nIndex, dwNewLong); }
	LONG_PTR	SetWindowLongPtrW(int nIndex, LONG_PTR dwNewLong)	{ return ::SetWindowLongPtrW(m_hWnd, nIndex, dwNewLong); }
	LONG_PTR	GetWindowLongPtrA(int nIndex)	const				{ return ::GetWindowLongPtrA(m_hWnd, nIndex); }
	LONG_PTR	GetWindowLongPtrW(int nIndex)	const				{ return ::GetWindowLongPtrW(m_hWnd, nIndex); }
#endif

#if	!defined(IRIS_WIN32_WCE)
	BOOL	GetWindowInfo(PWINDOWINFO pw)							{ return ::GetWindowInfo(m_hWnd, pw); }
#endif

	int		GetClassNameA(LPSTR  lpClassName, int nMaxCount)	const	{ return ::GetClassNameA(m_hWnd, lpClassName, nMaxCount); }
	int		GetClassNameW(LPWSTR lpClassName, int nMaxCount)	const	{ return ::GetClassNameW(m_hWnd, lpClassName, nMaxCount); }
public:
	// function wrap
	HDC		GetDC(void)				const							{ return ::GetDC(m_hWnd); }
	int		ReleaseDC(HDC hDC)										{ return ::ReleaseDC(m_hWnd, hDC); }

	BOOL	EnableWindow(BOOL bEnable)								{ return ::EnableWindow(m_hWnd, bEnable); }
	BOOL	IsWindowEnabled(void)	const							{ return ::IsWindowEnabled(m_hWnd); }
	BOOL	IsWindowVisible(void)	const							{ return ::IsWindowVisible(m_hWnd); }
#if	!defined(IRIS_WIN32_WCE)
	BOOL	IsWindowUnicode(void)	const							{ return ::IsWindowUnicode(m_hWnd); }
	BOOL	IsIconic(void)			const							{ return ::IsIconic(m_hWnd); }
	BOOL	IsZoomed(void)			const							{ return ::IsZoomed(m_hWnd); }
#endif

	BOOL	IsWindow(void)			const							{ return ::IsWindow(m_hWnd); }
	BOOL	IsChild(HWND hWnd)		const							{ return ::IsChild(m_hWnd, hWnd); }
	HWND	GetChild(void)			const							{ return ::GetWindow(m_hWnd, GW_CHILD); }
	HWND	GetParent(void)			const							{ return ::GetParent(m_hWnd); }
	HWND	SetParent(HWND hNewParent)								{ return ::SetParent(m_hWnd, hNewParent); }

#if	!defined(IRIS_WIN32_WCE)
	HMENU	GetMenu(void)			const							{ return ::GetMenu(m_hWnd); }
	BOOL	SetMenu(HMENU hMenu)									{ return ::SetMenu(m_hWnd, hMenu); }
#else
	HMENU	GetMenu(WORD iButton=0)	const							{ return ::CommandBar_GetMenu(GetCommandBar(), iButton); }
	HWND	GetCommandBar(void)		const							{ return nullptr; }
#endif
	BOOL	DrawMenuBar(void)										{ return ::DrawMenuBar(m_hWnd); }

	BOOL	GetWindowRect(LPRECT lprc)		const					{ return ::GetWindowRect(m_hWnd, lprc); }
	BOOL	GetClientRect(LPRECT lprc)								{ return ::GetClientRect(m_hWnd, lprc); }
	BOOL	ClientToScreen(LPPOINT lppt)	const					{ return ::ClientToScreen(m_hWnd, lppt); }
	BOOL	ScreenToClient(LPPOINT lppt)	const					{ return ::ScreenToClient(m_hWnd, lppt); }

	BOOL	BringWindowToTop(void)									{ return ::BringWindowToTop(m_hWnd); }
#if	!defined(IRIS_WIN32_WCE)
	BOOL	AnimateWindow(DWORD dwTime, DWORD dwFlags)				{ return ::AnimateWindow(m_hWnd,dwTime,dwFlags); }
	BOOL	FlashWindow(BOOL bInvert)								{ return ::FlashWindow(m_hWnd,bInvert); }			// EBhE̓_
	void	DragAcceptFiles(BOOL bAccept)							{ ::DragAcceptFiles(m_hWnd, bAccept); }

	BOOL	ShowOwnedPopups(BOOL bShow)								{ return ::ShowOwnedPopups(m_hWnd,bShow); }			// EBhE|bvAbvEBhE̕\؂ւ
	BOOL	OpenIcon(void)											{ return ::OpenIcon(m_hWnd); }
#endif

	HWND	SetFocus(void)											{ return ::SetFocus(m_hWnd); }
	BOOL	SetForegroundWindow(void)								{ return ::SetForegroundWindow(m_hWnd); }
	BOOL	ShowWindow(int nCmdShow)								{ return ::ShowWindow(m_hWnd, nCmdShow); }
	BOOL	MoveWindow(int x, int y, int w, int h, BOOL bRepaint)	{ return ::MoveWindow(m_hWnd, x, y, w, h, bRepaint); }
	BOOL	SetWindowPos(HWND hWndInsertAfter, int nX, int nY, int w, int h, int nFlag)
																	{ return ::SetWindowPos(m_hWnd, hWndInsertAfter, nX, nY, w, h, nFlag); }
#if	!defined(IRIS_WIN32_WCE)
	BOOL	GetWindowPlacement(WINDOWPLACEMENT* lpwndpl)	const	{ return ::GetWindowPlacement(m_hWnd, lpwndpl); }
	BOOL	SetWindowPlacement(WINDOWPLACEMENT* lpwndpl)			{ return ::SetWindowPlacement(m_hWnd, lpwndpl); }
#endif

	BOOL	SetWindowRgn(HRGN hRgn, BOOL bRedraw)					{ return ::SetWindowRgn(m_hWnd, hRgn, bRedraw); }

	BOOL	InvalidateRect(const RECT* lprc, BOOL bErase)			{ return ::InvalidateRect(m_hWnd, lprc, bErase); }
	BOOL	ValidateRect(const RECT* lprc)							{ return ::ValidateRect(m_hWnd, lprc); }
	BOOL	UpdateWindow(void)										{ return ::UpdateWindow(m_hWnd); }
	BOOL	DestroyWindow(void)										{ return ::DestroyWindow(m_hWnd); }

	BOOL	GetScrollRange(int nBar, LPINT lpMin, LPINT lpMax)	const	{ return ::GetScrollRange(m_hWnd, nBar, lpMin, lpMax); }
	BOOL	SetScrollRange(int nBar, int nMin, int nMax, BOOL bRedraw)	
																	{ return ::SetScrollRange(m_hWnd, nBar, nMin, nMax, bRedraw); }
	BOOL	GetScrollInfo(int nBar, LPSCROLLINFO lpsi)	const		{ return ::GetScrollInfo(m_hWnd, nBar, lpsi); }
	BOOL	SetScrollInfo(int nBar, LPSCROLLINFO lpsi, BOOL bRedraw){ return ::SetScrollInfo(m_hWnd, nBar, lpsi, bRedraw); }

	int		GetDlgCtrlID(void)	const								{ return ::GetDlgCtrlID(m_hWnd); }
public:
	// message wrap
	LRESULT	SetFont(HGDIOBJ hFont, BOOL ReDraw)	{ return SendMessage(WM_SETFONT, (WPARAM)hFont, (LPARAM)ReDraw); }
	BOOL	SetIcon(UINT uType, HICON hIcon)	{ return (BOOL)SendMessage(WM_SETICON, (WPARAM)uType, (LPARAM)hIcon); }

public:
	// wrap custom
#if	!defined(IRIS_WIN32_WCE)
	BOOL		GetMinMaxInfo(LPMINMAXINFO lpmm);
	BOOL		FlashWindowEx(DWORD dwTimeout, DWORD dwFlags, UINT uCount);
#endif
	BOOL		AdjustRect(LPRECT lprc)	const;
	BOOL		SetClientSize(int w, int h, BOOL bRepaint);
	BOOL		GetClientRectFromParent(LPRECT lprc);
	SIZE		GetWindowSize(void);
	BOOL		SetWindowSize(int w, int h, BOOL bRepaint);
	BOOL		SetWindowPos(HWND hWndInsertAfter, int nX, int nY, int nFlag);
	LONG		GetWindowWidth(void)	const;
	LONG		GetWindowHeight(void)	const;
	BOOL		GetScrollInfo(int nBar, LPSCROLLINFO lpsi, int nMask)	const;
	int			GetScrollLimit(int nBar)	const;
	HINSTANCE	GetInstanceHandle(void);
	BOOL		IsHScrollVisible(void)	const;
	BOOL		IsVScrollVisible(void)	const;

	BOOL		GetWindowTextA(std::string&  str)	const;
	BOOL		GetWindowTextW(std::wstring& str)	const;

	BOOL		ClientToScreen(LPRECT lprc)	const;
	BOOL		ScreenToClient(LPRECT lprc)	const;

#ifdef _IRIS_DEBUG
	int		DebugMessage(LPCTSTR lpText, LPCTSTR lpCaption=nullptr, UINT uType=MB_OK) { return MessageBox(lpText,lpCaption,uType); }
#else
	int		DebugMessage(LPCTSTR lpText, LPCTSTR lpCaption=nullptr, UINT uType=MB_OK) { return 1; }
#endif	// #ifdef _IRIS_DEBUG

public:

	virtual	UINT Error(LPCTSTR text, LPCTSTR cap=nullptr, UINT uType=MB_OK);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
