//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMDIApplication.cpp
 * @brief		MDIAvP[Vx[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMDIApplication_CPP_

//======================================================================
// include
#include "WXMDIApplication.h"
#include "../wx_inchead.h"
#include <commctrl.h>
#include <tchar.h>
#include "iris_debug.h"

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// define
// ID
#define IDM_FIRSTCHILD	100
// CxgR[
#define MDIEVENT_CALL(ptr, name)	(ptr) = Find(hWnd);			\
									if( (ptr) == nullptr ) break;	\
									lr = (ptr)->__IrisDocEventFuncName(name)(hWnd, wParam, lParam)

//======================================================================
// variable
// O[õ_~[EBhEvV[WANZXpϐ
IMDIApplication* IMDIApplication::s_pApp = nullptr;

/**********************************************************************//**
 *
 * EBhENXo^pEBhEvV[W
 *
*//***********************************************************************/
LRESULT CALLBACK IMDIApplication::DocumentProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return s_pApp->DocProc(hWnd , uMsg , wParam , lParam);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	AppName	= AvP[V
*//***********************************************************************/
IMDIApplication::IMDIApplication(LPCTSTR AppName)
: CApplication(AppName)
, m_hMDIClient(nullptr)
{
	_tcscpy_s(m_DocName, sizeof(m_DocName)/sizeof(TCHAR), m_AppName);
	_tcscat_s(m_DocName, sizeof(m_DocName)/sizeof(TCHAR), TEXT(":Document"));
	s_pApp = this;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IMDIApplication::~IMDIApplication()
{
	s_pApp = nullptr;
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT IMDIApplication::DocProc(HWND hWnd , UINT uMsg , WPARAM wParam , LPARAM lParam)
{
	LRESULT lr = 1;
	ptr p = nullptr;
	switch( uMsg )
	{
	// EBhE
	case WM_CREATE:
		{
			LPMDICREATESTRUCT lpmcs = (LPMDICREATESTRUCT)lParam;
			// hLgNX̐
			p = New(hWnd, lpmcs->lParam);
			if( p == nullptr ) break;

			if( p->__IrisDocEventFuncName(Create)(hWnd, wParam, lParam) != -1)
			{
				m_Doc.insert(Pair(hWnd, p));
				::InvalidateRect(hWnd, nullptr, FALSE);
			}
			else
			{
				IRIS_WARNING("failed Create MDI Child Window.\n");
				Delete(p);
				p = nullptr;
				::SendMessage(hWnd, WM_CLOSE, 0, 0);
			}
		}
		break;
	// 
	case WM_CLOSE:
		{
			p = Find(hWnd);
			if( p != nullptr )
			{
				if(p->__IrisDocEventFuncName(Close)(hWnd,wParam,lParam) == 0)
					return 0;
				// WM_DESTROY΂ p ̂łŏ
				p->GetWndProcSubject().SendParentMessage( hWnd, uMsg, wParam, lParam);
				return (DefMDIChildProc(hWnd, uMsg, wParam, lParam));
			}
		}
		break;
	// 폜
	case WM_DESTROY:
		{
			p = Find(hWnd);
			if( p != nullptr )
			{
				p->__IrisDocEventFuncName(Destroy)(hWnd,wParam,lParam);
				m_Doc.erase(hWnd);
				Delete(p);
				p = nullptr;
			}
		}
		break;
	case WM_ACTIVATE:
		MDIEVENT_CALL(p, Activate);
		break;
	// `
	case WM_PAINT:
		MDIEVENT_CALL(p, Paint);
		break;

	// TCY
	case WM_MOVE:
		MDIEVENT_CALL(p, Move);
		break;
	case WM_SIZE:
		MDIEVENT_CALL(p, Size);
		break;

	// tH[JX
	case WM_SETFOCUS:
		MDIEVENT_CALL(p, SetFocus);
		break;
	case WM_KILLFOCUS:
		MDIEVENT_CALL(p, KillFocus);
		break;
	case WM_ENABLE:
		MDIEVENT_CALL(p, Enable);
		break;

	case WM_ERASEBKGND:
		MDIEVENT_CALL(p, EraseBkGnd);
		break;
	case WM_SHOWWINDOW:
		MDIEVENT_CALL(p, ShowWindow);
		break;

	case WM_SETCURSOR:
		MDIEVENT_CALL(p, SetCursor);
		break;

	case WM_MOUSEACTIVATE:
		MDIEVENT_CALL(p, MouseActivate);
		break;
	case WM_CHILDACTIVATE:
		MDIEVENT_CALL(p, ChildActivate);
		break;

	case WM_GETMINMAXINFO:
		MDIEVENT_CALL(p, GetMinMaxInfo);
		break;

	case WM_DRAWITEM:
		MDIEVENT_CALL(p, DrawItem);
		break;
	case WM_MEASUREITEM:
		MDIEVENT_CALL(p, MeasureItem);
		break;

	case WM_NOTIFY:
		MDIEVENT_CALL(p, Notify);
		break;
	case WM_HELP:
		MDIEVENT_CALL(p, Help);
		break;

	// key
	case WM_KEYDOWN:
		MDIEVENT_CALL(p, KeyDown);
		break;
	case WM_KEYUP:
		MDIEVENT_CALL(p, KeyUp);
		break;
	case WM_CHAR:
		MDIEVENT_CALL(p, Char);
		break;
	case WM_DEADCHAR:
		MDIEVENT_CALL(p, DeadChar);
		break;
	case WM_SYSKEYDOWN:
		MDIEVENT_CALL(p, SysKeyDown);
		break;
	case WM_SYSKEYUP:
		MDIEVENT_CALL(p, SysKeyUp);
		break;
	case WM_SYSCHAR:
		MDIEVENT_CALL(p, SysChar);
		break;
	case WM_SYSDEADCHAR:
		MDIEVENT_CALL(p, SysDeadChar);
		break;
	case WM_KEYLAST:
		MDIEVENT_CALL(p, KeyLast);
		break;

	case WM_COMMAND:
		MDIEVENT_CALL(p, Command);
		break;
	case WM_SYSCOMMAND:
		MDIEVENT_CALL(p, SysCommand);
		break;
	case WM_TIMER:
		MDIEVENT_CALL(p, Timer);
		break;
	case WM_HSCROLL:
		MDIEVENT_CALL(p, HScroll);
		break;
	case WM_VSCROLL:
		MDIEVENT_CALL(p, VScroll);
		break;
	case WM_MENUSELECT:
		MDIEVENT_CALL(p, MenuSelect);
		break;
	case WM_MENUCHAR:
		MDIEVENT_CALL(p, MenuChar);
		break;
	case WM_ENTERMENULOOP:
		MDIEVENT_CALL(p, EnterMenuLoop);
		break;
	case WM_EXITMENULOOP:
		MDIEVENT_CALL(p, ExitMenuLoop);
		break;

	// mouse
	case WM_MOUSEMOVE:
		MDIEVENT_CALL(p, MouseMove);
		break;
	case WM_LBUTTONDOWN:
		MDIEVENT_CALL(p, LButtonDown);
		break;
	case WM_LBUTTONUP:
		MDIEVENT_CALL(p, LButtonUp);
		break;
	case WM_LBUTTONDBLCLK:
		MDIEVENT_CALL(p, LButtonDblClk);
		break;
	case WM_RBUTTONDOWN:
		MDIEVENT_CALL(p, RButtonDown);
		break;
	case WM_RBUTTONUP:
		MDIEVENT_CALL(p, RButtonUp);
		break;
	case WM_RBUTTONDBLCLK:
		MDIEVENT_CALL(p, RButtonDblClk);
		break;
	case WM_MBUTTONDOWN:
		MDIEVENT_CALL(p, MButtonDown);
		break;
	case WM_MBUTTONUP:
		MDIEVENT_CALL(p, MButtonUp);
		break;
	case WM_MBUTTONDBLCLK:
		MDIEVENT_CALL(p, MButtonDblClk);
		break;

	// MDI
	// MDIhLg̃ANeBx[gύX
    case WM_MDIACTIVATE:
		{
			MDIEVENT_CALL(p, MDIActivate);
			__IrisMDIEventFuncName(MDIActivate)(hWnd, wParam, lParam);
		}
		break;

	case WM_DROPFILES:
		MDIEVENT_CALL(p, DropFiles);
		break;

	case WM_DRAWCLIPBOARD:
		MDIEVENT_CALL(p, DrawClipboard);
		break;
	}

	if( p != nullptr )
	{
		p->GetWndProcSubject().SendParentMessage(hWnd, uMsg, wParam, lParam);
	}
	if( lr != 0 ) lr = (DefMDIChildProc(hWnd, uMsg, wParam, lParam));
	return lr;
}

/**********************************************************************//**
 *
 * ftHgEBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT IMDIApplication::DefWndProc(HWND hWnd , UINT uMsg , WPARAM wParam , LPARAM lParam)
{
	return DefFrameProc(hWnd, m_hMDIClient, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool IMDIApplication::OnInit(void)
{
	// hLgNX̐ݒ
	if(!RegisterClassEntry((WNDPROC)DocumentProc, m_DocName, (HBRUSH)GetStockObject(WHITE_BRUSH)))
	{
		Error(TEXT("G[߁AAvP[VI܂B\n\n!!----->>\nEBhE̍쐬Ɏs(hLg)"));
		return false;
	}
	return CApplication::OnInit();
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void IMDIApplication::Term(void)
{
	UnregisterClass(m_DocName, m_hInst);
	CApplication::Term();
}

/**********************************************************************//**
 *
 * XV
 *
*//***********************************************************************/
void IMDIApplication::Transaction(void)
{
	if( m_Flags.IsFlag(MAF_TRANS_ALL) )
	{
		for( Map::iterator it = m_Doc.begin(); it != m_Doc.end(); ++it )
		{
			it->second->Transaction();
		}
	}
	else
	{
		ptr p = Find( MDIGetActive() );
		if( p != nullptr )
		{
			// hLgNX̍XVcall
			p->Transaction();
		}
	}
}

/**********************************************************************//**
 *
 * ANZ[^L[̊mF
 *
 ----------------------------------------------------------------------
 * @param [in]	msg	= sꂽbZ[W
 * @return	
*//***********************************************************************/
BOOL IMDIApplication::PreTranslateMessage(MSG* msg)
{
	int ret = CApplication::PreTranslateMessage(msg);
	if( !ret )
	{
		return TranslateMDISysAccel(m_hMDIClient, msg);
	}
	return ret;
}

/**********************************************************************//**
 *
 * MDIEBhEJ
 *
 ----------------------------------------------------------------------
 * @param [in]	title	= ^Cg
 * @param [in]	sytle	= X^C
 * @param [in]	width	= 
 * @param [in]	height	= 
 * @param [in]	lParam	= 
*//***********************************************************************/
HWND IMDIApplication::CreateDoc(LPCTSTR title, DWORD style, int width, int height, LPARAM lParam)
{
	//MDICREATESTRUCT mdic;
	//mdic.szClass = m_DocName;
	//mdic.szTitle = title;
	//mdic.hOwner = m_hInst;
	//mdic.x = CW_USEDEFAULT;
	//mdic.y = CW_USEDEFAULT;
	//mdic.cx = width;
	//mdic.cy = height;
	//mdic.style = style;
	//mdic.lParam = lParam;
	//SendMessage(m_hMDIClient, WM_MDICREATE, 0, (LPARAM)&mdic);
	return ::CreateMDIWindow(m_DocName, title, style
		, CW_USEDEFAULT, CW_USEDEFAULT, width, height
		, m_hMDIClient, m_hInst, lParam ); 
}

/**********************************************************************//**
 *
 * MDIqEBhEׂĕ
 *
*//***********************************************************************/
void IMDIApplication::MDIDestroyAll(void)
{
	HWND hActive = MDIGetActive();
	while( hActive != nullptr )
	{
		MDIDestroy(hActive);
		hActive = MDIGetActive();
	}
}

/**********************************************************************//**
 *
 * MDIɃj[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hMenu		= j[o[nh
 * @param [in]	hWindowMenu	= EBhEj[̒ǉ惁j[nh(NULL)
*//***********************************************************************/
void IMDIApplication::MDISetMenu(HMENU hMenu, HMENU hWindowMenu)
{
	::SendMessage(m_hMDIClient, WM_MDISETMENU, (WPARAM)hMenu, (LPARAM)hWindowMenu);
}

/**********************************************************************//**
 *
 * Create
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(IMDIApplication, Create)
{
	IRIS_UNUSED_VARIABLE(wParam);
	IRIS_UNUSED_VARIABLE(lParam);
	// MDĨNCAgEBhE̍쐬
	CLIENTCREATESTRUCT ccs;
	ccs.hWindowMenu = GetMDIWindowMenuHandle(GetMenu());
	ccs.idFirstChild = IDM_FIRSTCHILD;
	m_hMDIClient = ::CreateWindow(
		TEXT("MDICLIENT"),
		nullptr,
		WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN,
		0, 0, 0, 0,
		hWnd,
		(HMENU)1,
		m_hInst,
		(LPTSTR)&ccs);

	return 0;
}

/**********************************************************************//**
 *
 * WM_SIZE
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(IMDIApplication, Size)
{
#if 1
	DefFrameProc(hWnd, m_hMDIClient, WM_SIZE, wParam, lParam);
	// status barꍇ́ANCAgEBhETCYύX
	CWndProcSubject& subject = GetWndProcSubject();
	CWndProcObserver* observer = subject.GetObserver();
	TCHAR cls_name[64];
	while( observer != nullptr )
	{
		HWND hWnd = observer->GetHWND();
		if( ::IsWindowVisible(hWnd) )
		{
			::GetClassName(hWnd, cls_name, 64);
			if( _tcscmp(cls_name, STATUSCLASSNAME) == 0 )
			{
				RECT rc;
				int height = 0;
				GetClientRect(&rc);
				RECT sbrc;
				::GetWindowRect(hWnd, &sbrc);
				height = sbrc.bottom - sbrc.top;
				::MoveWindow(m_hMDIClient, rc.left, rc.top, rc.right-rc.left, rc.bottom-rc.top - height, TRUE);
				break;
			}
		}
		observer = observer->GetNext();
	}
	return 0;
#else
	return CApplication::__IrisAppEventFuncName(Size)(hWnd, wParam, lParam);;
#endif
}

/**********************************************************************//**
 *
 * MDIActivate
 *
*//***********************************************************************/
__IrisMDIEventFuncImpl(IMDIApplication, MDIActivate)
{
	HMENU hMenu = GetMDIMenuHandle(((HWND)lParam == hWnd));
	MDISetMenu(hMenu, GetMDIWindowMenuHandle(hMenu));
	DrawMenuBar();
	return 1;
}

/**********************************************************************//**
 *
 * MDIEBhER[obN֐
 *
*//***********************************************************************/
BOOL CALLBACK MDICloseAllEnumFunc(HWND hWnd, LPARAM lParam)
{
	IRIS_UNUSED_VARIABLE(lParam);
    SendMessage(GetParent(hWnd), WM_MDIDESTROY, (WPARAM)hWnd, 0);
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris
