//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDXDoc.cpp
 * @brief		MDIhLgNX(DirectX)t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDXDoc_CPP_

//======================================================================
// include
#include "WXDXDoc.h"
#include "../debug/WXDebug.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	lParam	= CreateMDIWindowɓnp[^
 * @param [in]	pTimer	= ^C}[NX
*//***********************************************************************/
CDXDoc::CDXDoc(HWND hWnd, LPDOCPARAMS pDocParam, fnd::ITimer* pTimer)
: CMDIDocument(hWnd, pDocParam)
, m_pTimer(pTimer)
, m_pDevice(nullptr)
{
	if( pDocParam->cbSize == sizeof(DXDOCPARAMS) )
	{
		m_pDevice = ((LPDXDOCPARAMS)pDocParam)->pDevice;
	}
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXDoc::~CDXDoc(void)
{
}

/**********************************************************************//**
 *
 * XV
 * FPSUpdate,Draw̃R[
 *
*//***********************************************************************/
void CDXDoc::Transaction(void)
{
	if( m_pTimer->Sync(false) )
	{
		float time = m_pTimer->GetSyncElapsedSecond();
		Update(time);
		Draw();
	}
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXDoc::Update(float time)
{
	m_SwapChain.Update(time);
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CDXDoc::Draw(void)
{
	if( m_SwapChain.BeginScene() )
	{
		m_SwapChain.Draw();
		if( m_SwapChain.EndScene() )
		{
			m_SwapChain.Present();
		}
	}
}

/**********************************************************************//**
 *
 * Create
 *
 * @note	DirectXfoCX̏s܂
 *
 ----------------------------------------------------------------------
*//***********************************************************************/
__IrisDocEventFuncImpl(CDXDoc, Create)
{
	RECT rc;
	::GetClientRect(hWnd, &rc);
	if( m_pDevice->IsState(dx::CDXDevice::DXDS_DEVICE_LOST) ) m_pDevice->RestoreDevice();
	m_SwapChain.Initialize(hWnd, rc.right-rc.left, rc.bottom-rc.top);
	// Xbv`FC̍쐬
	if( !m_pDevice->RegisterDeviceObject(&m_SwapChain) )
	{
		return -1;
	}
	m_pTimer->Reset();
	return CMDIDocument::__IrisDocEventFuncName(Create)(hWnd, wParam, lParam);
}

/**********************************************************************//**
 *
 * Paint
 *
 * @note	`֐̃R[s܂
 *
 ----------------------------------------------------------------------
*//***********************************************************************/
__IrisDocEventFuncImpl(CDXDoc, Paint)
{
	Draw();
	::ValidateRect(hWnd, nullptr);
	return CMDIDocument::__IrisDocEventFuncName(Paint)(hWnd, wParam, lParam);
}

/**********************************************************************//**
 *
 * Destroy
 *
*//***********************************************************************/
__IrisDocEventFuncImpl(CDXDoc, Destroy)
{
	return CMDIDocument::__IrisDocEventFuncName(Destroy)(hWnd, wParam, lParam);
}

/**********************************************************************//**
 *
 * Size
 *
 * @note	DirectXfoCX̃TCYs܂
 *
 ----------------------------------------------------------------------
*//***********************************************************************/
__IrisDocEventFuncImpl(CDXDoc, Size)
{
	UINT width = LOWORD(lParam);
	UINT height= HIWORD(lParam);
	m_SwapChain.ReSize(width,height);
	return CMDIDocument::__IrisDocEventFuncName(Size)(hWnd, wParam, lParam);
}

/**********************************************************************//*-
 *
 * EraseBkGnd
 *
 * @note	InvalidateRect̔s
 *
 ----------------------------------------------------------------------
*//***********************************************************************/
__IrisDocEventFuncImpl(CDXDoc, EraseBkGnd)
{
	//::InvalidateRect(hWnd,nullptr,0);
	return CMDIDocument::__IrisDocEventFuncName(EraseBkGnd)(hWnd, wParam, lParam);
}

/**********************************************************************//*-
 *
 * SetFocus
 *
 * @note	FPS^C}[Resumes܂
 *
 ----------------------------------------------------------------------
*//***********************************************************************/
__IrisDocEventFuncImpl(CDXDoc, SetFocus)
{
	m_pTimer->Resume();
	return CMDIDocument::__IrisDocEventFuncName(SetFocus)(hWnd, wParam, lParam);
}

/**********************************************************************//*-
 *
 * KillFocus
 *
 * @note	FPS^C}[Suspends܂
 *
 ----------------------------------------------------------------------
*//***********************************************************************/
__IrisDocEventFuncImpl(CDXDoc, KillFocus)
{
	m_pTimer->Suspend();
	return CMDIDocument::__IrisDocEventFuncName(KillFocus)(hWnd, wParam, lParam);
}

/**********************************************************************//*-
 *
 * Enable
 *
 * @note	FPS^C}[Resume,Suspends܂
 *
 ----------------------------------------------------------------------
*//***********************************************************************/
__IrisDocEventFuncImpl(CDXDoc, Enable)
{
	if( wParam )	m_pTimer->Resume();
	else			m_pTimer->Suspend();
	return CMDIDocument::__IrisDocEventFuncName(Enable)(hWnd, wParam, lParam);
}

}	// end of namespace wx
}	// end of namespace iris
