//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDXApplication.cpp
 * @brief		DirectX@AvP[Vx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDXApplication_CPP_

//======================================================================
// include
#include "WXDXApplication.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXApplication::CDXApplication(LPCTSTR AppName, fnd::ITimer* pTimer)
: CApplication(AppName)
, m_Device(nullptr)
, m_pTimer(pTimer)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXApplication::~CDXApplication(void)
{
}

/**********************************************************************//**
 *
 * XV
 *
*//***********************************************************************/
void CDXApplication::Transaction(void)
{
	if( m_pTimer->Sync(false) )
	{
		float time = m_pTimer->GetSyncElapsedSecond();
		Update(time);
		Draw();
	}
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXApplication::Update(float time)
{
	m_Device.Update(time);
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CDXApplication::Draw(void)
{
	if( m_Device.GetDXSwapChain().BeginScene() )
	{
		m_Device.Draw();
		if( m_Device.EndScene() )
		{
			m_Device.Present();
		}
	}
}

/**********************************************************************//**
 *
 * Create
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(CDXApplication, Create)
{
	LRESULT ret = CApplication::__IrisAppEventFuncName(Create)(hWnd, wParam, lParam);
	RECT rc;
	::GetClientRect(hWnd, &rc);
	// foCX̍쐬
	m_Device.SetHWND(hWnd);
	if( !m_Device.CreateDevice(rc.right-rc.left, rc.bottom-rc.top, false, false, false, false, false, true) )
	{
		return -1;
	}
	return ret;
}

/**********************************************************************//**
 *
 * Paint
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(CDXApplication, Paint)
{
	Draw();
	::ValidateRect(hWnd, nullptr);
	//if( m_Device.IsState(dx::CDXDevice::DXDS_DEVICE_LOST) ) m_Device.RestoreDevice();
	return CApplication::__IrisAppEventFuncName(Paint)(hWnd, wParam, lParam);
}

/**********************************************************************//**
 *
 * SetFocus
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(CDXApplication, SetFocus)
{
	m_pTimer->Resume();
	m_Device.TestCooperativeLevel();
	if( m_Device.IsState(dx::CDXDevice::DXDS_DEVICE_LOST) ) m_Device.RestoreDevice();
	return CApplication::__IrisAppEventFuncName(SetFocus)(hWnd, wParam, lParam);
}

/**********************************************************************//*-
 *
 * KillFocus
 *
 * @note	FPS^C}[Suspends܂
 *
 ----------------------------------------------------------------------
*//***********************************************************************/
__IrisAppEventFuncImpl(CDXApplication, KillFocus)
{
	m_pTimer->Suspend();
	return CApplication::__IrisAppEventFuncName(KillFocus)(hWnd, wParam, lParam);
}

/**********************************************************************//*-
 *
 * Enable
 *
 * @note	FPS^C}[Resume,Suspends܂
 *
 ----------------------------------------------------------------------
*//***********************************************************************/
__IrisAppEventFuncImpl(CDXApplication, Enable)
{
	if( wParam )	m_pTimer->Resume();
	else			m_pTimer->Suspend();
	return CApplication::__IrisAppEventFuncName(Enable)(hWnd, wParam, lParam);
}

/**********************************************************************//**
 *
 * Size
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(CDXApplication, Size)
{
	UINT width = LOWORD(lParam);
	UINT height= HIWORD(lParam);
	m_Device.ReSize(width, height);
	return CApplication::__IrisAppEventFuncName(Size)(hWnd, wParam, lParam);
}

}	// end of namespace wx
}	// end of namespace iris
