//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MfcUniMap.h
 * @brief		d֎~ \[g Map t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MfcUniMap_H_
#define INCG_IRIS_MfcUniMap_H_

//======================================================================
// include
#include "MfcSortArray.h"

namespace iris {
namespace mfc
{

//======================================================================
// class
/**
 * @brief	d֎~ \[g map
 * @tparam KEY			= L[̌^
 * @tparam ARG_KEY		= L[̈p̌^
 * @tparam VALUE		= ľ^
 * @tparam ARG_VALUE	= l̈p̌^
 * @tparam COMPARE		= \[gprIuWFNg
*/
template<class KEY
		, class ARG_KEY
		, class VALUE
		, class ARG_VALUE
		, class COMPARE >
class CUniMap : public IIrisObject
{
public:
	/**
	 * @brief	CUniMap i[p yA
	*/
	struct CPair
	{
		const KEY key;
		VALUE value;
	protected:
		CPair(ARG_KEY keyval) : key( keyval )	{}
	public:
		CPair(void) : key(KEY()) {}
		CPair(ARG_KEY keyval, ARG_VALUE val) : key(keyval), value(val) {}
		CPair(const CPair& rhs) : key(rhs.key), value(rhs.value) {}
	public:
		CPair& operator = (const CPair& rhs)	{ KEY* pk = const_cast<KEY*>(&key); *pk = rhs.key; value = rhs.value; return *this; }

	public:
		// \[gpr֐iL[̒lŃ\[g܂j
		bool	operator <  (const CPair& rhs)	const	{ return key <  rhs.key; }
		bool	operator <= (const CPair& rhs)	const	{ return key <= rhs.key; }
		bool	operator >  (const CPair& rhs)	const	{ return key >  rhs.key; }
		bool	operator >= (const CPair& rhs)	const	{ return key >= rhs.key; }
	};
	typedef CSortArray<CPair, COMPARE>	Array;

private:
	Array	m_array;	//!< vfz

public:
	/**
	 * @brief	vf̎擾 
	 * @return vf
	*/
	INT_PTR GetCount(void) const	{ return m_array.GetCount(); }

	/**
	 * @brief	vf̎擾 
	 * @return vf
	*/
	INT_PTR GetSize(void) const		{ return m_array.GetSize(); }

	/**
	 * @brief	vf󂩂ǂ
	 * @return ^Ul
	*/
	BOOL IsEmpty(void) const		{ return m_array.IsEmpty(); }

public:
	/**
	 * @brief	zQ operator
	*/
	const CPair& operator[](INT_PTR nIndex) const	{ return m_array[nIndex]; }
	CPair& operator[](INT_PTR nIndex)				{ return m_array[nIndex]; }

public:
	/**
	 * @brief	vf̒ǉ
	 * @param [in]	newElement	= ǉ CPair vf
	*/
	INT_PTR	Add(const CPair& newElement)
	{
		if( GetAtOfKey(newElement.key) >= 0 ) return -1;
		return m_array.Add(newElement);
	}

	/**
	 * @brief	vf̒ǉ
	 * @param [in]	newKey		= ǉvf̃L[
	 * @param [in]	newValue	= ǉvf̒l
	*/
	INT_PTR	Add(ARG_KEY newKey, ARG_VALUE newValue)
	{
		if( GetAtOfKey(newKey) >= 0 ) return -1;
		return m_array.Add(CPair(newKey, newValue));
	}

	/**
	 * @brief	w̃CfbNX̃yA擾
	 * @param [in]	nIndex	= CfbNX
	 * @return yA
	*/
	const CPair& GetAt(INT_PTR nIndex) const
	{
		return m_array.GetAt(nIndex);
	}

	/**
	 * @brief	w̃CfbNX̃yA擾
	 * @param [in]	nIndex	= CfbNX
	 * @return yA
	*/
	CPair& GetAt(INT_PTR nIndex)
	{
		return m_array.GetAt(nIndex);
	}

	/**
	 * @brief	w̃CfbNX̗vf폜
	 * @param [in]	nIndex	= CfbNX
	*/
	void RemoveAt(INT_PTR nIndex)
	{
		m_array.RemoveAt(nIndex);
	}

	/**
	 * @brief	\[g֐
	 *			OIvɂтꂽꍇpɃ\[g
	*/
	void Sort(void)
	{
		m_array.Sort();
	}

public:
	/**
	 * @brief	w̃L[̐擪CfbNX擾
	 * @param [in]	Key	= L[
	 * @return CfbNX
	*/
	INT_PTR GetAtOfKey(ARG_KEY key)
	{
		COMPARE comp;
		INT_PTR s = 0;
		INT_PTR e = GetSize()-1;
		INT_PTR n = s + ((e-s+1)>>1);
		while(s<=e)
		{
			const KEY& temp = GetAt(n).key;
			if( comp(key, temp) >= 0 )
			{
				if( comp(temp, key) >= 0 )
				{
					return n;
				}
				s = n+1;
			}
			else						e = n-1;
			n = s + ((e-s+1)>>1);
		}
		return -1;
	}

	/**
	 * @brief	vfS폜
	*/
	void RemoveAll()
	{
		m_array.RemoveAll();
	}
};

}	// end of namespace mfc
}	// end of namespace iris

#endif
