//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSoundBuffer.cpp
 * @brief		directX TEhobt@[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXSoundBuffer_CPP_

//======================================================================
// include
#include "DXSoundBuffer.h"
#include "../DXError.h"

#include "../../win/debug/WXDebug.h"
#include "../../win/debug/WXDebugLeakCheckMacro.h"

//======================================================================
// link
#pragma comment ( lib, "dsound.lib" )

namespace iris {
namespace dx
{

//======================================================================
// class

//======================================================================
// CDXSound
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXSoundBuffer::CDXSoundBuffer(void)
: m_ppBuffer(nullptr)
, m_pFile(nullptr)
, m_dwBufferNum(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXSoundBuffer::~CDXSoundBuffer(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXSoundBuffer::Release(void)
{
	if( m_dwBufferNum <= 0 ) m_dwBufferNum = 0;

	if( m_ppBuffer != nullptr )
	{
		for( DWORD i = 0; i < m_dwBufferNum; ++ i )
		{
			Stop( i );
			DX_SAFE_RELEASE( m_ppBuffer[i] );
		}
	}
	DX_SAFE_DELETE_ARRAY( m_ppBuffer );
	m_dwBufferNum = 0;
}

/**********************************************************************//**
 *
 * IDirectSoundBuffer8IuWFNg̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	num = 쐬鐔
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::CreateBuffer(DWORD num)
{
	if( num <= 0 ) return S_FALSE;
	Release();

	m_ppBuffer = new LPDXSOUNDBUFFER [num];
	if( m_ppBuffer == nullptr ) return S_FALSE;

	for( DWORD i = 0; i < num; ++i )
	{
		m_ppBuffer[i] = nullptr;
	}
	m_dwBufferNum = num;
	return S_OK;
}

/**********************************************************************//**
 *
 * IDirectSoundBuffer8IuWFNg̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	id	= CfbNX
 * @return	IDirectSoundBuffer8IuWFNg
*//***********************************************************************/
LPDXSOUNDBUFFER* CDXSoundBuffer::GetBuffer(DWORD id)
{
	if( m_ppBuffer == nullptr ) return nullptr;
	if( id >= m_dwBufferNum ) return nullptr;
	return &m_ppBuffer[id];
}

/**********************************************************************//**
 *
 * 󂢂ĂIDirectSoundBuffer8IuWFNg̎擾
 *
 ----------------------------------------------------------------------
 * @return	IDirectSoundBuffer8IuWFNg
*//***********************************************************************/
LPDXSOUNDBUFFER CDXSoundBuffer::GetFreeBuffer(void)
{
	return *GetBuffer( GetFreeBufferID() );
}

/**********************************************************************//**
 *
 * 󂢂ĂIDirectSoundBuffer8IuWFNgindex擾
 *
 ----------------------------------------------------------------------
 * @return	ID
*//***********************************************************************/
DWORD CDXSoundBuffer::GetFreeBufferID(void)
{
	if( m_ppBuffer != nullptr )
	{
		for( DWORD i = 0; i < m_dwBufferNum; ++ i )
		{
			if( IsPlaying( i ) == S_FALSE )
			{
				return i;
			}
		}
	}
	//return m_dwBufferNum;
	return (DWORD)-1;
}

/**********************************************************************//**
 *
 * obt@Ƀf[^i[
 *
 ----------------------------------------------------------------------
 * @param [in]	pBuffer = i[obt@
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::FillBuffer(LPDXSOUNDBUFFER pBuffer)
{
	if( pBuffer == nullptr )	return S_FALSE;
	if( m_pFile == nullptr )	return S_FALSE;

	HRESULT hr			= S_OK;	// G[擾p
	void	*pvData1	= nullptr;	// f[^1
	void	*pvData2	= nullptr;	// f[^2
	DWORD	DataSize1	= 0;	// f[^1̃TCY
	DWORD	DataSize2	= 0;	// f[^2̃TCY

	// ZJ_obt@̃bN(xsĂxs)
	hr = pBuffer->Lock(	0
		, m_pFile->GetSize()
		, &pvData1
		, &DataSize1
		, &pvData2
		, &DataSize2
		, 0 );

	// obt@̃Xg
	if( hr == DSERR_BUFFERLOST )
	{
		DX_ERROR(hr);
		// XgA
		hr = pBuffer->Restore();
		// obt@XgĂȂ
		if( hr != DSERR_BUFFERLOST )
		{
			// ZJ_obt@̃bN
			hr = pBuffer->Lock(	0
				, m_pFile->GetSize()
				, &pvData1
				, &DataSize1
				, &pvData2
				, &DataSize2
				, 0 );
		}
	}
	if( FAILED( hr ) ) { DX_ERROR(hr); return hr; }

	m_pFile->ReadPCM(pvData1, DataSize1);

	if( DataSize2 > 0 )
		m_pFile->ReadPCM(pvData2, DataSize2);

	// ZJ_obt@̃AbN
	hr = pBuffer->Unlock( pvData1, DataSize1, pvData2, DataSize2 );

	//G[
	if( FAILED( hr ) ) { DX_ERROR(hr); }
	return hr;
}

/**********************************************************************//**
 *
 * Đ
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @param [in]	dwPriority	= Dx
 * @param [in]	dwFlags		= tO
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::Play(DWORD id, DWORD dwPriority, DWORD dwFlags)
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	HRESULT hr = m_ppBuffer[id]->Play( 0, dwPriority, dwFlags );
	// 
	if( SUCCEEDED( hr ) ) return hr;
	// obt@̃Xg
	if( hr == DSERR_BUFFERLOST )
	{
		// XgA
		hr = m_ppBuffer[id]->Restore();
		// obt@XgĂȂ
		if( hr != DSERR_BUFFERLOST )
		{
			// obt@̕
			hr = FillBuffer( m_ppBuffer[id] );
		}
	}
	DX_ERROR(hr);
	return hr;
}

/**********************************************************************//**
 *
 * Đi󂢂Ăobt@Ij
 *
 ----------------------------------------------------------------------
 * @param [in]	dwPriority	= Dx
 * @param [in]	dwFlags		= tO
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::Play(DWORD dwPriority, DWORD dwFlags)
{
	DWORD id = GetFreeBufferID();
	return Play( id, dwPriority, dwFlags );
}

/**********************************************************************//**
 *
 * ~
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::Stop(DWORD id)
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	return m_ppBuffer[id]->Stop();
}

/**********************************************************************//**
 *
 * ~iSj
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::Stop(void)
{
	HRESULT hr = S_OK;
	for( DWORD i=0; i < m_dwBufferNum; ++i )
	{
		hr |= Stop( i );
	}
	return hr;
}

/**********************************************************************//**
 *
 * Đׂ
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @return	ĐȂS_OK, ĐĂȂƂS_FALSE
*//***********************************************************************/
HRESULT CDXSoundBuffer::IsPlaying(DWORD id)
{
	if( m_ppBuffer == nullptr )		return E_INVALIDARG;
	if( id >= m_dwBufferNum )		return E_INVALIDARG;
	if( m_ppBuffer[id] == nullptr )	return E_INVALIDARG;

	DWORD	dwStatus	= 0;
	HRESULT hr = m_ppBuffer[id]->GetStatus( &dwStatus );
	if( FAILED( hr ) ) { DX_ERROR(hr); return hr; }

	if( ( dwStatus & DSBSTATUS_PLAYING ) != 0 )
		return S_OK;
	return S_FALSE;
}

/**********************************************************************//**
 *
 * Đׂ
 *
 ----------------------------------------------------------------------
 * @return	PłĐȂS_OK, ׂčĐĂȂƂS_FALSE
*//***********************************************************************/
HRESULT CDXSoundBuffer::IsPlaying(void)
{
	for( DWORD i=0; i < m_dwBufferNum; ++i )
	{
		if( IsPlaying( i ) == S_OK ) return S_OK;
	}
	return S_FALSE;
}

/**********************************************************************//**
 *
 * ʂ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @param [in]	lVolume		= 
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::SetVolume( DWORD id, long lVolume )
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	return m_ppBuffer[id]->SetVolume( lVolume );
}

/**********************************************************************//**
 *
 * ʂ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lVolume		= 
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::SetVolume(long lVolume)
{
	HRESULT hr = S_OK;
	for( DWORD i=0; i < m_dwBufferNum; ++i )
	{
		hr |= SetVolume( i, lVolume );
	}
	return hr;
}

/**********************************************************************//**
 *
 * ʂ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @param [in]	plVolume	= óB
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::GetVolume(DWORD id, long *plVolume)
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	return m_ppBuffer[id]->GetVolume( plVolume );
}

/**********************************************************************//**
 *
 * p̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @param [in]	lPan		= p
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::SetPan(DWORD id, long lPan)
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	return m_ppBuffer[id]->SetPan( lPan );
}

/**********************************************************************//**
 *
 * p̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lPan		= p
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::SetPan( long lPan )
{
	HRESULT hr = S_OK;
	for( DWORD i=0; i < m_dwBufferNum; ++i )
	{
		hr |= SetPan( i, lPan );
	}
	return hr;
}

/**********************************************************************//**
 *
 * p̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @param [in]	plPan		= óBp
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::GetPan( DWORD id, long *plPan )
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	return m_ppBuffer[id]->GetPan( plPan );
}

/**********************************************************************//**
 *
 * g̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @param [in]	dwFrequency	= g
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::SetFrequency(DWORD id, DWORD dwFrequency)
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	return m_ppBuffer[id]->SetFrequency( dwFrequency );
}

/**********************************************************************//**
 *
 * g̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFrequency	= g
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::SetFrequency(DWORD dwFrequency)
{
	HRESULT hr = S_OK;
	for( DWORD i=0; i < m_dwBufferNum; ++i )
	{
		hr |= SetFrequency( i, dwFrequency );
	}
	return hr;
}

/**********************************************************************//**
 *
 * g̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	id				= obt@̃CfbNX
 * @param [in]	pdwFrequency	= óBg
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::GetFrequency( DWORD id, DWORD *pdwFrequency )
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	return m_ppBuffer[id]->GetFrequency( pdwFrequency );
}

/**********************************************************************//**
 *
 * ĐJ[\ʒu̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @param [in]	dwPosition	= ĐJ[\ʒu
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::SetCurrentPosition( DWORD id, DWORD dwPosition )
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	return m_ppBuffer[id]->SetCurrentPosition( dwPosition );
}

/**********************************************************************//**
 *
 * ĐJ[\ʒu̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	id			= obt@̃CfbNX
 * @param [in]	pdwPosition	= óBĐJ[\ʒu
 * @return	
*//***********************************************************************/
HRESULT CDXSoundBuffer::GetCurrentPosition( DWORD id, DWORD *pdwPosition )
{
	if( m_ppBuffer == nullptr )		return S_FALSE;
	if( id >= m_dwBufferNum )		return S_FALSE;
	if( m_ppBuffer[id] == nullptr )	return S_FALSE;
	return m_ppBuffer[id]->GetCurrentPosition( pdwPosition, nullptr );
}

}	// end of namespace dx
}	// end of namespace iris
