//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSound.h
 * @brief		directX TEhfoCXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXSound_H_
#define INCG_IRIS_DXSound_H_

//======================================================================
// include
#include "DXSoundBuffer.h"

namespace iris {
namespace dx
{

//======================================================================
// define

//======================================================================
// declare

//======================================================================
// class

//======================================================================
//! TEhfoCXNX
class CDXSound : public INonCopyable<>
{
private:
	LPDXSOUND				m_pDxSound;
	LPDIRECTSOUNDBUFFER		m_pPrimaryBuffer;	// vC}TEhobt@
public:
	// RXgN^
	CDXSound(void);
	// fXgN^
	virtual ~CDXSound(void);

public:
	// 
	virtual	HRESULT	Initialize(HWND hWnd, DWORD dwCoopLevel = DSSCL_PRIORITY);
	// 
	virtual void	Release(void);

public:
	// vC}obt@̍쐬
	virtual	HRESULT	CreatePrimaryBuffer(DWORD dwFlags);

public:
	// WAVEt@C̓ǂݍ
	virtual HRESULT LoadSoundFile (CDXSoundBuffer* pSound
		, LPTSTR pFileName
		, DWORD dwFlags = 0
		, GUID guid3DAlgorithm = GUID_NULL
		, DWORD dwNumBuffers = 1 );
	virtual HRESULT LoadSoundFileA(CDXSoundBuffer* pSound
		, LPSTR  pFileName
		, DWORD dwFlags = 0
		, GUID guid3DAlgorithm = GUID_NULL
		, DWORD dwNumBuffers = 1 );
	virtual HRESULT LoadSoundFileW(CDXSoundBuffer* pSound
		, LPWSTR pFileName
		, DWORD dwFlags = 0
		, GUID guid3DAlgorithm = GUID_NULL
		, DWORD dwNumBuffers = 1 );

	// TEhobt@̍쐬
	virtual HRESULT CreateSoundFile(CDXSoundBuffer* pSound
		, ax::IAXFile* pSoundFile
		, DWORD dwFlags = 0
		, GUID guid3DAlgorithm = GUID_NULL
		, DWORD dwNumBuffers = 1 );
public:
	// obt@̕
	virtual HRESULT DuplicateSoundBuffer(LPDXSOUNDBUFFER pDSBufferOriginal
		, LPDXSOUNDBUFFER* ppDSBufferDuplicate );

public:
	// set, get
	LPDXSOUND			GetDirectSound(void)	{ return m_pDxSound; }
	LPDIRECTSOUNDBUFFER	GetPrimaryBuffer(void)	{ return m_pPrimaryBuffer; }

public:
	// wrap
	HRESULT			SetPrimaryVolume(LONG lVolume);
	HRESULT			GetPrimaryVolume(PLONG plVolume);
	HRESULT			SetPrimaryPan(LONG lPan);
	HRESULT			GetPrimaryPan(PLONG plPan);
	HRESULT			SetPrimaryFormat(LPCWAVEFORMATEX pwfx);
	HRESULT			GetPrimaryFormat(LPWAVEFORMATEX  pwfx, DWORD dwSizeAlloced, LPDWORD pdwSizeWirtten);

};

}	// end of namespace dx
}	// end of namespace iris

#endif
