//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMusic.cpp
 * @brief		directX Music t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXMusic_CPP_

//======================================================================
// include
#include "DXMusic.h"

#ifdef _IRIS_DX_SUPPORT_DXMUSIC

#include "../../iris_debug.h"
#include <stdio.h>

//======================================================================
// link
#pragma comment ( lib, "dxguid.lib" )

namespace iris {
namespace dx
{
//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXMusic::CDXMusic(void)
: m_bIsCOM(false)
, m_pLoader(nullptr)
, m_pPerformance(nullptr)
, m_pComposer(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXMusic::~CDXMusic(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= EBhEnh
 * @param [in]	dwPChannelCount	= `l
 * @param [in]	dwFlags			= tO
 * @param [in]	pDS				= IDirectSoundIuWFNg
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::Initialize(HWND hWnd, DWORD dwPChannelCount, DWORD dwFlags, IDirectSound *pDS )
{
	HRESULT hr = S_OK;
	hr = CoInitialize(nullptr);
	if( FAILED( hr ) ) return hr;
	m_bIsCOM = true;

	// IDirectMusicLoader8IuWFNg̍쐬
	hr = CoCreateInstance(CLSID_DirectMusicLoader
		, nullptr
		, CLSCTX_INPROC
		, IID_IDirectMusicLoader8
		, (void**)&m_pLoader );
	if( FAILED( hr ) ) return hr;

	// IDirectMusicPerformance8IuWFNg̍쐬
	hr = CoCreateInstance(CLSID_DirectMusicPerformance
		, nullptr
		, CLSCTX_INPROC
		, IID_IDirectMusicPerformance8
		, (void**)&m_pPerformance );
	if( FAILED( hr ) ) return hr;

	// IDirectMusicComposer8IuWFNg̍쐬
	hr = CoCreateInstance(CLSID_DirectMusicComposer
		, nullptr
		, CLSCTX_INPROC
		, IID_IDirectMusicComposer8
		, (void**)&m_pComposer );
	if( FAILED( hr ) ) return hr;

	// ptH[}XIuWFNg̏
	hr = m_pPerformance->InitAudio(nullptr
		, &pDS
		, hWnd
		, dwFlags
		, dwPChannelCount
		, DMUS_AUDIOF_ALL
		, nullptr );
	return hr;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXMusic::Release(void)
{
	IRIS_SAFE_RELEASE( m_pLoader );
	// ptH[}XIuWFNg
	if( m_pPerformance != nullptr )	m_pPerformance->CloseDown();
	IRIS_SAFE_RELEASE( m_pPerformance );

	// R|[UIuWFNg̉
	IRIS_SAFE_RELEASE( m_pComposer );

	// COM̉
	if( m_bIsCOM == true ) CoUninitialize();
}

/**********************************************************************//**
 *
 * t@C烍[h
 *
 ----------------------------------------------------------------------
 * @param [in]	ppSegment	= EBhEnh
 * @param [in]	lpFileName	= t@C
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::LoadSegmentFromFile(IDirectMusicSegment8** ppSegment, LPWSTR lpFileName)
{
	IRIS_ASSERT( ppSegment != nullptr );
	IRIS_ASSERT( lpFileName != nullptr );
	HRESULT hr = S_OK;
	// ZOg̉
	if( (*ppSegment) != nullptr ) hr = (*ppSegment)->Unload(m_pPerformance);
	IRIS_SAFE_RELEASE( (*ppSegment) );

	// t@C̃[h
	hr = m_pLoader->LoadObjectFromFile(CLSID_DirectMusicSegment
		, IID_IDirectMusicSegment8
		, lpFileName
		, (void**)ppSegment );
	if( FAILED( hr ) ) return hr;
	return (*ppSegment)->Download( m_pPerformance );
}

/**********************************************************************//**
 *
 * }X^[{[̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lVolume	= }X^[{[
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::SetMasterVolume(LONG lVolume)
{
	if( m_pPerformance == nullptr ) return S_FALSE;
	return m_pPerformance->SetGlobalParam(GUID_PerfMasterVolume
		, &lVolume
		, sizeof(LONG) );
}

/**********************************************************************//**
 *
 * }X^[{[̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lVolume	= }X^[{[
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::GetMasterVolume(PLONG plVolume)
{
	if( m_pPerformance == nullptr ) return S_FALSE;
	return m_pPerformance->GetGlobalParam(GUID_PerfMasterVolume
		, plVolume
		, sizeof(LONG) );
}

/**********************************************************************//**
 *
 * }X^[e|̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	fTempo	= }X^[e|
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::SetMasterTempo(f32 fTempo)
{
	if( m_pPerformance == nullptr ) return S_FALSE;
	return m_pPerformance->SetGlobalParam(GUID_PerfMasterTempo
		, &fTempo
		, sizeof(f32) );
}

/**********************************************************************//**
 *
 * }X^[e|̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pfTempo	= }X^[e|
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::GetMasterTempo(f32 *pfTempo)
{
	if( m_pPerformance == nullptr ) return S_FALSE;
	return m_pPerformance->GetGlobalParam(GUID_PerfMasterTempo
		, pfTempo
		, sizeof(f32) );
}

/**********************************************************************//**
 *
 * pX̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	pPath	= pX
 * @param [in]	bClear	= TRUE:IuWFNgɊւSĂ̏̍폜
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::SetSearchDirectory(LPWSTR lpPath, BOOL bClear)
{
	if( m_pLoader == nullptr ) return S_FALSE;
	return m_pLoader->SetSearchDirectory(GUID_DirectMusicAllTypes, lpPath, bClear);
}

/**********************************************************************//**
 *
 * gpȂȂIuWFNgLbV폜
 *
*//***********************************************************************/
void CDXMusic::CollectGarbage(void)
{
	IRIS_ASSERT( m_pLoader != nullptr );
	m_pLoader->CollectGarbage();
}

/**********************************************************************//**
 *
 * SẲt̒~
 *
 ----------------------------------------------------------------------
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::StopAll(void)
{
	if( m_pPerformance == nullptr ) return S_FALSE;
	return m_pPerformance->Stop(nullptr, nullptr, 0, 0);
}

/**********************************************************************//**
 *
 * W̃I[fBIpX̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	ppAudioPath		= IDirectMusicAudioPathIuWFNg
 * @param [in]	dwType			= pX̃^Cv
 * @param [in]	dwPChannelCount	= `l
 * @param [in]	bActivate		= 쐬̃pX̏
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::CreateStandardAudioPath(IDirectMusicAudioPath** ppAudioPath, DWORD dwType
		, DWORD dwPChannelCount, BOOL bActivate)
{
	if( m_pPerformance == nullptr ) return S_FALSE;
	return m_pPerformance->CreateStandardAudioPath(dwType
		, dwPChannelCount
		, bActivate
		, ppAudioPath );
}

/**********************************************************************//**
 *
 * X[YȋȂ̕ύX
 *
 ----------------------------------------------------------------------
 * @param [in]	pSegment	= IDirectMusicSegment8IuWFNg
 * @param [in]	wCommand	= 
 * @param [in]	dwFlags		= tO
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXMusic::AutoTransition(IDirectMusicSegment *pSegment, WORD wCommand, DWORD dwFlags)
{
	if( m_pComposer == nullptr ) return S_FALSE;
	return m_pComposer->AutoTransition(m_pPerformance
		, pSegment
		, wCommand
		, dwFlags
		, nullptr
		, nullptr
		, nullptr
		, nullptr );
}

}	// end of namespace dx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "unit/UnitCore.h"
#include "DXMusicSegment.h"
#include "iris_using.h"

//======================================================================
// declare
UNITTEST_MAIN_FUNC(DXMusicUnitTest);

//======================================================================
// class
class CDXMusicUnitTest : public iris::unit::CUnitTest<CDXMusicUnitTest> {};
// `
IRIS_UNITTEST(CDXMusicUnitTest, DXMusicUnitTest);

//======================================================================
// typedef
typedef CDXMusicUnitTest	dbUnitTest;

/**********************************************************************//**
 *
 * UNITTEST_MAIN
 * 
 ----------------------------------------------------------------------
 * @return
*//***********************************************************************/
UNITTEST_MAIN_FUNC(DXMusicUnitTest)
{
	WCHAR			filename[]	= L"../../data/snd/sample.mid";
	CDXMusic		music;
	CDXMusicSegment	segment;

	music.Initialize();

	// ptH[}XIuWFNg̐ݒ
	segment.SetPerformance( music.GetPerformance() );

	// MIDIt@C̓ǂݍ
	if( SUCCEEDED(music.LoadSegmentFromFile( segment.GetSegment(), filename )) )
	{
		// MIDIt@C̍Đ
		segment.PlayEx();

		printf("Ȃɂ͂ƍĐI܂\n");
		getchar();

		// MIDIt@C̒~
		segment.StopEx();

		// MIDIt@C̃A[h
		segment.Unload();
	}

	// DirectMusic̉
	music.Release();

	return 0;
}

#endif	// #if (_IRIS_defined(UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif	// #ifdef _IRIS_DX_SUPPORT_DXMUSIC
