//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXKeyState.cpp
 * @brief		directX ̓L[ԃt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXKeyState_CPP_

//======================================================================
// include
#include "DXKeyState.h"

namespace iris {
namespace dx
{

//======================================================================
// class

//======================================================================
// CKeyState
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	key	= L[l
*//***********************************************************************/
CKeyState::CKeyState(BYTE key)
: m_Key(key)
, m_bHold(false)
, m_bPrev(false)
, m_bRept(false)
, m_fCnt(0.0f)
{
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	hold		= 
 * @param [in]	rept_first	= L[s[g
 * @param [in]	rept_loop	= L[s[g
*//***********************************************************************/
void CKeyState::Update(bool hold, f32 rept_first, f32 rept_loop)
{
	m_bPrev = m_bHold;
	m_bHold = hold;
	m_bRept = Trig();
	// s[g
	if( m_bRept )
		m_fCnt = rept_loop-rept_first;			// s[gJn
	if( m_bHold )
	{
		m_fCnt += 1.0f;
		if( m_fCnt >= rept_loop )
		{
			m_fCnt = 0.0f;
			m_bRept = true;
		}
	}
}

//======================================================================
// WCXeBbNNX

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	key	= L[l
*//***********************************************************************/
CDXJoyStickState::CDXJoyStickState(BYTE key)
: CDXJoyKeyState(key)
, m_OffsetX(DIJOFS_X)
, m_OffsetY(DIJOFS_Y)
, m_OffsetZ(DIJOFS_Z)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXJoyStickState::~CDXJoyStickState(void)
{
}

/**********************************************************************//**
 *
 * foCXԍXVʒm
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= WCpbhfoCX
*//***********************************************************************/
void CDXJoyStickState::UpdateDevice(LPDIRECTINPUTDEVICE8 pDevice)
{
	if( pDevice == nullptr ) return;
	DIPROPRANGE dipr;
	ZeroMemory(&dipr , sizeof(dipr));
	dipr.diph.dwSize		= sizeof(dipr); 
	dipr.diph.dwHeaderSize	= sizeof(dipr.diph); 
	dipr.diph.dwHow			= DIPH_BYOFFSET; 
	dipr.diph.dwObj			= m_OffsetX;
	pDevice->GetProperty( DIPROP_RANGE, &dipr.diph ); 
	m_Range.x = (f32)dipr.lMax;

	dipr.diph.dwObj			= m_OffsetY;
	pDevice->GetProperty( DIPROP_RANGE, &dipr.diph ); 
	m_Range.y = (f32)dipr.lMax;

	dipr.diph.dwObj			= m_OffsetZ;
	pDevice->GetProperty( DIPROP_RANGE, &dipr.diph ); 
	m_Range.z = (f32)dipr.lMax;
}

/**********************************************************************//**
 *
 * WCpbhXV
 *
 ----------------------------------------------------------------------
 * @param [in]	pJoyState	= WCpbh
 * @param [in]	rept_first	= L[s[g
 * @param [in]	rept_loop	= L[s[gԊu
*//***********************************************************************/
bool CDXJoyStickState::JoyUpdate(const DIJOYSTATE2* pJoyState, f32 rept_first, f32 rept_loop )
{
	const char* p = (const char*)(pJoyState);
	LONG lX = *((const LONG*)(p+m_OffsetX));
	LONG lY = *((const LONG*)(p+m_OffsetY));
	LONG lZ = *((const LONG*)(p+m_OffsetZ));
	m_Stick.x = lX / m_Range.x;
	m_Stick.y = lY / m_Range.y;
	m_Stick.x = lZ / m_Range.z;
	return true;
}

}	// end of namespace dx
}	// end of namespace iris
