//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXInuptDevice.h
 * @brief		directX ̓foCXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXInuptDevice_H_
#define INCG_IRIS_DXInuptDevice_H_

//======================================================================
// include
#include "fnd/container/FndObserver.h"
#include "DXKeyState.h"
#include <map>

#if	defined(_IRIS_SUPPORT_DXMOBILE)
#error not support.
#endif

namespace iris {
namespace dx
{

//======================================================================
// define
/// AiOXeBbN̕
#define DX_JOYAXIS_RANGE	(1000)
/// AiOXeBbN̂
#define DX_JOYAXIS_MARGIN	(300)
/// L[s[gԊu
#define	DX_KEY_REPEATLOOP	(4.0f)
/// L[s[gԊu
#define DX_KEY_REPEATFIRST	(1.0f)

//======================================================================
// declare
class CDXInput;
class IDXInputDevice;
class CDXJoyDevice;
class CDXKeyDevice;

//======================================================================
// class

//======================================================================
//! ̓foCXC^[tF[X
class IDXInputDevice : public fnd::CObserver<IDXInputDevice>
{
	friend class CDXInput;	//!< Ǘ҂̃ANZX
public:
	typedef LPDXJoyKeyState				LPKEYSTATE;
	typedef std::map<UINT, LPKEYSTATE>	CKeyMap;
	typedef std::pair<UINT, LPKEYSTATE>	CKeyPair;
	typedef CKeyMap::iterator			iterator;

protected:
	/// foCX
	LPDIRECTINPUTDEVICE8	m_pDevice;
	/// L[
	CKeyMap					m_Keys;
	/// L[s[gԊu
	f32						m_fRepeatLoop;
	/// L[s[gԊu
	f32						m_fRepeatFirst;

public:
	// RXgN^
	IDXInputDevice(void);
	// fXgN^
	virtual ~IDXInputDevice(void);
public:
	// WCpbhݒ
	virtual void	SetJoypadAxis(DWORD obj, LONG range=DX_JOYAXIS_RANGE, LONG margin=DX_JOYAXIS_MARGIN);

	// 
	virtual	void	Release(void);

public:
	// XV
	virtual	void	Update(void)	= 0;
	// foCXԂύXꂽƂʒm
	virtual void	UpdateDevice(void);

	/// ͏̃NA
	virtual void	Clear(void)		{ _Clear(m_Keys); }

public:
	// L[擾
	/// 
	bool			Hold(UINT uID)			{ LPKEYSTATE p = GetKey(uID); return (p != nullptr) ? p->Hold(): false; }
	/// u
	bool			Trig(UINT uID)			{ LPKEYSTATE p = GetKey(uID); return (p != nullptr) ? p->Trig(): false; }
	/// u
	bool			Free(UINT uID)			{ LPKEYSTATE p = GetKey(uID); return (p != nullptr) ? p->Free(): false; }
	/// s[g
	bool			Rept(UINT uID)			{ LPKEYSTATE p = GetKey(uID); return (p != nullptr) ? p->Rept(): false; }

public:
	// set, get
	// device
	LPDIRECTINPUTDEVICE8	GetDevice(void)		{ return m_pDevice; }

	// s[g
	void			SetRepeatLoop(f32 loop)		{ m_fRepeatLoop  = loop; }	//!< s[g̐ݒ
	f32				GetRepeatLoop(void)			{ return m_fRepeatLoop; }	//!< s[g̎擾
	void			SetRepeatFirst(f32 first)	{ m_fRepeatFirst = first; }	//!< 񃊃s[g̐ݒ
	f32				GetRepeatFirst(void)		{ return m_fRepeatFirst; }	//!< 񃊃s[g̎擾

public:
	// L[NX擾
	LPKEYSTATE		GetKey(UINT uID);

	/// L[ǉ
	template<class _TC>
	_TC*			RegisterKey(UINT uID, BYTE dik) 
	{
		_TC* p = new _TC(dik);
		_RegisterKey(m_Keys, uID, p);
		return p;
	}
	/// L[폜
	bool			EraseKey(UINT uID)
	{
		return _EraseKey( m_Keys, uID );
	}
	/// L[폜
	bool			EraseKey(LPKEYSTATE lpKey)
	{
		return _EraseKey( m_Keys, lpKey );
	}

protected:
	// NA
	virtual void		_Clear(CKeyMap& rMap);
	// o^
	virtual bool		_RegisterKey(CKeyMap& rMap, UINT uID, LPKEYSTATE lpKey);
	// 폜
	virtual bool		_EraseKey(CKeyMap& rMap, UINT uID);
	virtual bool		_EraseKey(CKeyMap& rMap, LPKEYSTATE lpKey);
};

//======================================================================
//! WCpbhfoCXNX
class CDXJoyDevice : public IDXInputDevice
{
public:
	// RXgN^
	CDXJoyDevice(void);
	// fXgN^
	virtual ~CDXJoyDevice(void);
public:
	// XV
	virtual	void	Update(void);
};

//======================================================================
//! L[{[hfoCXNX
class CDXKeyDevice : public IDXInputDevice
{
public:
	// RXgN^
	CDXKeyDevice(void);
	// fXgN^
	virtual ~CDXKeyDevice(void);
public:
	// XV
	virtual	void	Update(void);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
