//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXInupt.h
 * @brief		directX ̓foCXǗt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXInupt_H_
#define INCG_IRIS_DXInupt_H_

//======================================================================
// include
#include "DXInputDevice.h"

namespace iris {
namespace dx
{

//======================================================================
// declare

//======================================================================
// class

//======================================================================
//! ̓foCXǗNX
class CDXInput : public fnd::CSubject<IDXInputDevice>
{
public:
	// RXgN^
	CDXInput(void);
	// fXgN^
	virtual ~CDXInput(void);
public:
	// 
	virtual bool	Initialize(void);
	// 
	virtual	void	Release(void);

public:
	// XV
	virtual	void	Update(void);

public:
	// foCXǉ
	virtual void	RegisterDevice(IDXInputDevice* pDevice);
	// foCX폜
	virtual void	EraseDevice(IDXInputDevice* pDevice);

public:
	// L[{[hfoCX쐬
	virtual	bool	CreateKeyDevice(HWND hWnd, IDXInputDevice* pDevice);
	// WCpbhfoCX쐬
	virtual	bool	CreateJoyDevice(HWND hWnd, IDXInputDevice* pDevice);
public:
	// 
	BOOL CALLBACK 	EnumJoypadCallback(LPCDIDEVICEINSTANCE did, IDXInputDevice* pDevice);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
