//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DMXMath.h
 * @brief		directX w֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DMXMath_H_
#define INCG_IRIS_DMXMath_H_

//======================================================================
// include
#include "../dmx_inchead.h"

#if	defined(_IRIS_SUPPORT_DXMOBILE)

//======================================================================
// define
//#define D3DXVec3Unproject		D3DMXVec3Unproject
#define D3DXVec3Normalize		D3DMXVec3Normalize
#define D3DXVec3TransformCoord	D3DMXVec3Transform

#define D3DXMatrixTranslation				D3DMXMatrixTranslation
#define D3DXMatrixRotationQuaternion	
#define D3DXMatrixPerspectiveFovLH			D3DMXMatrixPerspectiveFovLHFxd

#define D3DXQuaternionSlerp		

//======================================================================
// struct
//--------------------------
// 3D Vector
//--------------------------
typedef struct D3DMXVECTOR2
{
#ifdef __cplusplus
public:
	D3DMXVECTOR2() {};
	D3DMXVECTOR2( CONST FLOAT * );
	D3DMXVECTOR2( CONST D3DMVECTOR& );
	D3DMXVECTOR2( FLOAT x, FLOAT y );

	// casting
	operator FLOAT* ();
	operator CONST FLOAT* () const;

	// assignment operators
	D3DMXVECTOR2& operator += ( CONST D3DMXVECTOR2& );
	D3DMXVECTOR2& operator -= ( CONST D3DMXVECTOR2& );
	D3DMXVECTOR2& operator *= ( FLOAT );
	D3DMXVECTOR2& operator /= ( FLOAT );

	// unary operators
	D3DMXVECTOR2 operator + () const;
	D3DMXVECTOR2 operator - () const;

	// binary operators
	D3DMXVECTOR2 operator + ( CONST D3DMXVECTOR2& ) const;
	D3DMXVECTOR2 operator - ( CONST D3DMXVECTOR2& ) const;
	D3DMXVECTOR2 operator * ( FLOAT ) const;
	D3DMXVECTOR2 operator / ( FLOAT ) const;

	friend D3DMXVECTOR2 operator * ( FLOAT, CONST struct D3DMXVECTOR2& );

	BOOL operator == ( CONST D3DMXVECTOR2& ) const;
	BOOL operator != ( CONST D3DMXVECTOR2& ) const;

#endif //__cplusplus
	FLOAT x, y, z;
} D3DMXVECTOR2, *LPD3DMXVECTOR2;


//======================================================================
// function
STATICINLINE D3DMXMATRIX*		D3DXMatrixIdentity(D3DMXMATRIX *pOut)		{ return D3DMXMatrixIdentity(pOut); }
STATICINLINE D3DMXMATRIXFXD*	D3DXMatrixIdentity(D3DMXMATRIXFXD *pOut)	{ return D3DMXMatrixIdentityFxd(pOut); }

STATICINLINE D3DMXMATRIX*		D3DXMatrixLookAtLH(D3DMXMATRIX* pOut, CONST D3DMXVECTOR3 *pEye
												   , CONST D3DMXVECTOR3 *pAt, CONST D3DMXVECTOR3 *pUp)			{ return D3DMXMatrixLookAtLH(pOut, pEye, pAt, pUp); }
STATICINLINE D3DMXMATRIXFXD*	D3DXMatrixLookAtLH(D3DMXMATRIXFXD* pOut, CONST D3DMXVECTOR3FXD *pEye
												   , CONST D3DMXVECTOR3FXD *pAt, CONST D3DMXVECTOR3FXD *pUp)	{ return D3DMXMatrixLookAtLHFxd(pOut, pEye, pAt, pUp); }

STATICINLINE D3DMXMATRIX*		D3DXMatrixRotationYawPitchRoll(D3DMXMATRIX *pOut
															   , FLOAT Yaw, FLOAT Pitch, FLOAT Roll)	{ return D3DMXMatrixRotationYawPitchRoll(pOut, Yaw, Pitch, Roll); }
STATICINLINE D3DMXMATRIXFXD*	D3DXMatrixRotationYawPitchRoll(D3DMXMATRIXFXD *pOut
															   , FIXED Yaw, FIXED Pitch, FIXED Roll)	{ return D3DMXMatrixRotationYawPitchRollFxd(pOut, Yaw, Pitch, Roll); }

#endif

#endif
