//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		dmx_support.h
 * @brief		T|[g}Nwb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_dmx_support_H_
#define INCG_IRIS_dmx_support_H_

//======================================================================
// include
#include "define/dmx_def_caps.h"
#include "define/dmx_def_color.h"
#include "define/dmx_def_env.h"
#include "define/dmx_def_err.h"
#include "define/dmx_def_flt.h"
#include "define/dmx_def_fvf.h"
#include "define/dmx_def_rs.h"

#if	defined(_IRIS_SUPPORT_DXMOBILE)

//======================================================================
// define

// }N
#define D3DXToDegree		D3DMXToDegree
#define D3DXToRadian		D3DMXToRadian

// 萔
// Options for clearing.

#define D3DCLEAR_TARGET		D3DMCLEAR_TARGET
#define D3DCLEAR_ZBUFFER	D3DMCLEAR_ZBUFFER
#define D3DCLEAR_STENCIL	D3DMCLEAR_STENCIL

#define D3DCLEAR_VALID		D3DMCLEAR_VALID

// Flags to construct D3DMRS_COLORWRITEENABLE

#define D3DCOLORWRITEENABLE_RED		D3DMCOLORWRITEENABLE_RED
#define D3DCOLORWRITEENABLE_GREEN	D3DMCOLORWRITEENABLE_GREEN
#define D3DCOLORWRITEENABLE_BLUE	D3DMCOLORWRITEENABLE_BLUE
#define D3DCOLORWRITEENABLE_ALPHA	D3DMCOLORWRITEENABLE_ALPHA

#define D3DCOLORWRITEENABLE_ALL		D3DMCOLORWRITEENABLE_ALL

// D3DMFORMAT
#define D3DFMT_UNKNOWN			D3DMFMT_UNKNOWN
#define D3DFMT_R8G8B8			D3DMFMT_R8G8B8
#define D3DFMT_A8R8G8B8			D3DMFMT_A8R8G8B8
#define D3DFMT_X8R8G8B8			D3DMFMT_X8R8G8B8
#define D3DFMT_R5G6B5			D3DMFMT_R5G6B5
#define D3DFMT_X1R5G5B5			D3DMFMT_X1R5G5B5
#define D3DFMT_A1R5G5B5			D3DMFMT_A1R5G5B5
#define D3DFMT_A4R4G4B4			D3DMFMT_A4R4G4B4
#define D3DFMT_R3G3B2			D3DMFMT_R3G3B2
#define D3DFMT_A8R3G3B2			D3DMFMT_A8R3G3B2
#define D3DFMT_X4R4G4B4			D3DMFMT_X4R4G4B4
#define D3DFMT_A8P8				D3DMFMT_A8P8
#define D3DFMT_P8				D3DMFMT_P8
#define D3DFMT_A8				D3DMFMT_A8
#define D3DFMT_UYVY				D3DMFMT_UYVY
#define D3DFMT_YUY2				D3DMFMT_YUY2
#define D3DFMT_DXT1				D3DMFMT_DXT1
#define D3DFMT_DXT2				D3DMFMT_DXT2
#define D3DFMT_DXT3				D3DMFMT_DXT3
#define D3DFMT_DXT4				D3DMFMT_DXT4
#define D3DFMT_DXT5				D3DMFMT_DXT5
#define D3DFMT_D32				D3DMFMT_D32
#define D3DFMT_D15S1			D3DMFMT_D15S1
#define D3DFMT_D24S8			D3DMFMT_D24S8
#define D3DFMT_D16				D3DMFMT_D16
#define D3DFMT_D24X8			D3DMFMT_D24X8
#define D3DFMT_D24X4S4			D3DMFMT_D24X4S4
#define D3DFMT_INDEX16			D3DMFMT_INDEX16
#define D3DFMT_INDEX32			D3DMFMT_INDEX32
#define D3DFMT_VERTEXDATA		D3DMFMT_VERTEXDATA
#define D3DFMT_D3DMVALUE_FLOAT	D3DMFMT_D3DMVALUE_FLOAT
#define D3DFMT_D3DMVALUE_FIXED	D3DMFMT_D3DMVALUE_FIXED
#define D3DFMT_NUMFORMAT		D3DMFMT_NUMFORMAT
#define D3DFMT_FORCE_ULONG		D3DMFMT_FORCE_ULONG

// D3DBLEND
#define D3DBLEND_ZERO			D3DMBLEND_ZERO
#define D3DBLEND_ONE			D3DMBLEND_ONE
#define D3DBLEND_SRCCOLOR		D3DMBLEND_SRCCOLOR
#define D3DBLEND_INVSRCCOLOR	D3DMBLEND_INVSRCCOLOR
#define D3DBLEND_SRCALPHA		D3DMBLEND_SRCALPHA
#define D3DBLEND_INVSRCALPHA	D3DMBLEND_INVSRCALPHA
#define D3DBLEND_DESTALPHA		D3DMBLEND_DESTALPHA
#define D3DBLEND_INVDESTALPHA	D3DMBLEND_INVDESTALPHA
#define D3DBLEND_DESTCOLOR		D3DMBLEND_DESTCOLOR
#define D3DBLEND_INVDESTCOLOR	D3DMBLEND_INVDESTCOLOR
#define D3DBLEND_SRCALPHASAT	D3DMBLEND_SRCALPHASAT
#define D3DBLEND_FORCE_ULONG	D3DMBLEND_FORCE_ULONG

// D3DBLENDOP
#define D3DBLENDOP_ADD			D3DMBLENDOP_ADD
#define D3DBLENDOP_SUBTRACT		D3DMBLENDOP_SUBTRACT
#define D3DBLENDOP_REVSUBTRACT	D3DMBLENDOP_REVSUBTRACT
#define D3DBLENDOP_MIN			D3DMBLENDOP_MIN
#define D3DBLENDOP_MAX			D3DMBLENDOP_MAX 
#define D3DBLENDOP_FORCE_ULONG	D3DMBLENDOP_FORCE_ULONG

// D3DCREATE
#define D3DCREATE_FPU_PRESERVE					0
#define D3DCREATE_MULTITHREADED					D3DMCREATE_MULTITHREADED

#define D3DCREATE_PUREDEVICE					0
#define D3DCREATE_SOFTWARE_VERTEXPROCESSING		0
#define D3DCREATE_HARDWARE_VERTEXPROCESSING		0
#define D3DCREATE_MIXED_VERTEXPROCESSING		0

#define D3DCREATE_DISABLE_DRIVER_MANAGEMENT		0
#define D3DCREATE_ADAPTERGROUP_DEVICE			0
#define D3DCREATE_DISABLE_DRIVER_MANAGEMENT_EX	0

#define D3DCREATE_NOWINDOWCHANGES				0

// D3DPOOL
#define D3DPOOL_VIDEOMEM		D3DMPOOL_VIDEOMEM
#define D3DPOOL_SYSTEMMEM		D3DMPOOL_SYSTEMMEM
#define D3DPOOL_MANAGED			D3DMPOOL_MANAGED
#define D3DPOOL_FORCE_ULONG		D3DMPOOL_FORCE_ULONG
#define D3DPOOL_FORCE_DWORD		D3DMPOOL_FORCE_ULONG

#define D3DPOOL_DEFAULT			D3DMPOOL_VIDEOMEM

// D3DUSAGE
#define D3DUSAGE_RENDERTARGET	D3DMUSAGE_RENDERTARGET
#define D3DUSAGE_TEXTURE		D3DMUSAGE_TEXTURE

#define D3DUSAGE_LOCKABLE		D3DMUSAGE_LOCKABLE
#define D3DUSAGE_DYNAMIC		D3DMUSAGE_DYNAMIC
#define D3DUSAGE_DONOTCLIP		D3DMUSAGE_DONOTCLIP
#define D3DUSAGE_WRITEONLY		D3DMUSAGE_WRITEONLY

#define D3DUSAGE_VALID			D3DMUSAGE_VALID


// D3DADAPTER
#define D3DADAPTER_DEFAULT				D3DMADAPTER_DEFAULT
#define D3DADAPTER_REGISTERED_DEVICE	D3DMADAPTER_REGISTERED_DEVICE

// D3DPRESENTFLAG
#define D3DPRESENTFLAG_LOCKABLE_BACKBUFFER	D3DMPRESENTFLAG_LOCKABLE_BACKBUFFER

// D3DX_DEFAULT
#define D3DX_DEFAULT			D3DMX_DEFAULT
#define D3DX_DEFAULT_FLOAT		D3DMX_DEFAULT_FLOAT

#endif

#endif
