//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		dmx_def_fvf.h
 * @brief		FVF `T|[g}Nwb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_dmx_def_fvf_H_
#define INCG_IRIS_dmx_def_fvf_H_

#if	defined(_IRIS_SUPPORT_DXMOBILE)

//======================================================================
// include
#include <d3dmx.h>

//======================================================================
// define
#define D3DFVF_POSITION_MASK		D3DMFVF_POSITION_MASK
#define D3DFVF_XYZ_FLOAT			D3DMFVF_XYZ_FLOAT
#define D3DFVF_XYZ_FIXED			D3DMFVF_XYZ_FIXED
#define D3DFVF_XYZRHW_FIXED			D3DMFVF_XYZRHW_FIXED
#define D3DFVF_XYZRHW_FLOAT			D3DMFVF_XYZRHW_FLOAT
#define D3DFVF_RESERVED_POSITION1	D3DMFVF_RESERVED_POSITION1
#define D3DFVF_RESERVED_POSITION2	D3DMFVF_RESERVED_POSITION2
#define D3DFVF_RESERVED_POSITION3	D3DMFVF_RESERVED_POSITION3
#define D3DFVF_RESERVED_POSITION4	D3DMFVF_RESERVED_POSITION4

#define	D3DFVF_XYZ					D3DMFVF_XYZ_FIXED
#define D3DFVF_XYZRHW				D3DFVF_XYZRHW_FIXED

#define D3DFVF_MAX_POSITION			D3DMFVF_MAX_POSITION

#define D3DFVF_NORMAL_MASK			D3DMFVF_NORMAL_MASK
#define D3DFVF_NORMAL_NONE			D3DMFVF_NORMAL_NONE
#define D3DFVF_NORMAL_FLOAT			D3DMFVF_NORMAL_FLOAT
#define D3DFVF_NORMAL_FIXED			D3DMFVF_NORMAL_FIXED
#define D3DFVF_RESERVED_NORMAL1		D3DMFVF_RESERVED_NORMAL1
#define D3DFVF_RESERVED_NORMAL2		D3DMFVF_RESERVED_NORMAL2
#define D3DFVF_RESERVED_NORMAL3		D3DMFVF_RESERVED_NORMAL3
#define D3DFVF_RESERVED_NORMAL4		D3DMFVF_RESERVED_NORMAL4
#define D3DFVF_RESERVED_NORMAL5		D3DMFVF_RESERVED_NORMAL5

#define D3DFVF_NORMAL				D3DFVF_NORMAL_FIXED

#define D3DFVF_MAX_NORMAL			D3DMFVF_MAX_NORMAL

#define D3DFVF_DIFFUSE				D3DMFVF_DIFFUSE
#define D3DFVF_SPECULAR				D3DMFVF_SPECULAR

#define D3DFVF_TEXCOUNT_MASK		D3DMFVF_TEXCOUNT_MASK
#define D3DFVF_TEXCOUNT_SHIFT		D3DMFVF_TEXCOUNT_SHIFT
#define D3DFVF_TEX0					D3DMFVF_TEX0
#define D3DFVF_TEX1					D3DMFVF_TEX1
#define D3DFVF_TEX2					D3DMFVF_TEX2
#define D3DFVF_TEX3					D3DMFVF_TEX3
#define D3DFVF_TEX4					D3DMFVF_TEX4

#define D3DFVF_MAX_TEXCOUNT			D3DMFVF_MAX_TEXCOUNT

#define D3DFVF_RESERVED				D3DMFVF_RESERVED

#define D3DFVF_TEXTURECOORDCOUNTS	D3DMFVF_TEXTURECOORDCOUNTS
#define D3DFVF_TEXTURECOORDFORMATS	D3DMFVF_TEXTURECOORDFORMATS

// Macros to set and read texture coordinate count bits in the FVF id.

#define D3DFVF_TEXCOORDCOUNT2	D3DMFVF_TEXCOORDCOUNT2			// Two values
#define D3DFVF_TEXCOORDCOUNT1	D3DMFVF_TEXCOORDCOUNT1			// One value
#define D3DFVF_TEXCOORDCOUNT3	D3DMFVF_TEXCOORDCOUNT3			// Three values

#define D3DFVF_TEXCOORDCOUNT_SHIFT(CoordIndex) ((CoordIndex)*2 + 16)

#define D3DFVF_TEXCOORDSIZE3(CoordIndex) (D3DMFVF_TEXCOORDCOUNT3 << D3DMFVF_TEXCOORDCOUNT_SHIFT(CoordIndex))
#define D3DFVF_TEXCOORDSIZE2(CoordIndex) (D3DMFVF_TEXCOORDCOUNT2)
#define D3DFVF_TEXCOORDSIZE1(CoordIndex) (D3DMFVF_TEXCOORDCOUNT1 << D3DMFVF_TEXCOORDCOUNT_SHIFT(CoordIndex))

#define D3DFVF_TEXCOORDCOUNT_MASK(CoordIndex) ((D3DMFVF_TEXCOORDCOUNT1 | D3DMFVF_TEXCOORDCOUNT2 | D3DMFVF_TEXCOORDCOUNT3) << D3DMFVF_TEXCOORDCOUNT_SHIFT(CoordIndex))

// Macros to set and read texture coordinate format bits in the FVF id.

#define D3DFVF_TEXCOORDFORMAT_FLOAT			D3DMFVF_TEXCOORDFORMAT_FLOAT
#define D3DFVF_TEXCOORDFORMAT_FIXED			D3DMFVF_TEXCOORDFORMAT_FIXED
#define D3DFVF_TEXCOORDFORMAT_RESERVED1		D3DMFVF_TEXCOORDFORMAT_RESERVED1
#define D3DFVF_TEXCOORDFORMAT_RESERVED2		D3DMFVF_TEXCOORDFORMAT_RESERVED2

#define D3DFVF_TEXCOORDFORMAT_SHIFT(CoordIndex) ((CoordIndex)*2 + 24)

#define D3DFVF_TEXCOORDFLOAT(CoordIndex) (D3DMFVF_TEXCOORDFORMAT_FLOAT)
#define D3DFVF_TEXCOORDFIXED(CoordIndex) (D3DMFVF_TEXCOORDFORMAT_FIXED << D3DMFVF_TEXCOORDFORMAT_SHIFT(CoordIndex))

#define D3DFVF_TEXCOORDFORMAT_MASK(CoordIndex) ((D3DMFVF_TEXCOORDFORMAT_FLOAT | D3DMFVF_TEXCOORDFORMAT_FIXED) << D3DMFVF_TEXCOORDFORMAT_SHIFT(CoordIndex))

#endif

#endif
