//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXIMath.h
 * @brief		DXIMath t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXIMath_H_
#define INCG_IRIS_DXIMath_H_

//======================================================================
// include
#include "dxi_inchead.h"

namespace iris {
namespace dx {
namespace intr
{

//======================================================================
// struct
/**
 * @brief	RECT \
*/
typedef struct tagDXIRECT : public IrisIRect
{
public:

#if		defined(DX_SDK_VERSION)
#  if	(_IRIS_DXSDK_TARGET_VER > 9)
#  else
	operator		D3DRECT*	(void)			{ return reinterpret_cast<D3DRECT*>(this); }
	operator const	D3DRECT*	(void)	const	{ return reinterpret_cast<const D3DRECT*>(this); }
#  endif
#endif

	operator RECT*			(void)			{ return (RECT*)this; }
	operator const RECT*	(void)	const	{ return (RECT*)this; }

} DXIRECT, *LPDXIRECT;
	
}	// end of namespace intr
}	// end of namespace dx
}	// end of namespace iris


#endif
