//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXRenderTarget.h
 * @brief		directX _O^[QbgeNX`NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXRenderTarget_H_
#define INCG_IRIS_DXRenderTarget_H_

//======================================================================
// include
#include "DXTexture.h"

namespace iris {
namespace dx
{

//======================================================================
// class
//! _O^[QbgNX
class CDXRenderTarget : public IDXTexture
{
protected:
	LPDXSURFACE		m_pStencil;	//!< XeVobt@
	D3DFORMAT		m_Format;	//!< tH[}bg

public:
	// RXgN^
	CDXRenderTarget(void);
	// fXgN^
	virtual ~CDXRenderTarget(void);
public:
	// 쐬
	virtual	bool	Create(UINT width, UINT height);
	virtual	bool	Create(D3DFORMAT format, UINT width, UINT height);
	// 
	virtual void	Release(void);

protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);

public:
	// ^[Qbgݒ
	virtual bool	SetRenderTarget(DWORD RenderTargetIndex=0);

	// HDC擾
	// LȃtH[}bg = D3DFMT_R5G6B5AD3DFMT_X1R5G5B5AD3DFMT_R8G8B8A D3DFMT_X8R8G8B8
	virtual HRESULT	GetDC(HDC* phdc)	{ return (m_pSurface == nullptr) ? S_FALSE : m_pSurface->GetDC(phdc); }
	virtual void	ReleaseDC(HDC hdc)	{ if( m_pSurface != nullptr ) m_pSurface->ReleaseDC(hdc); }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
