//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFog.cpp
 * @brief		tHONXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXFog_CPP_

//======================================================================
// include
#include "DXFog.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	rParam	= tHOp[^
*//***********************************************************************/
CDXFog::CDXFog(const DXFOGPARAM& rParam)
: m_Param(rParam)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	color	= tHOJ[
 * @param [in]	start	= tHOn_
 * @param [in]	end		= tHOI_
 * @param [in]	density	= 
 * @param [in]	liner	= 
 * @param [in]	pixel	= 
 * @param [in]	range	= 
*//***********************************************************************/
CDXFog::CDXFog(bool enable
				, intr::DXICOLOR color
				, f32 start
				, f32 end
				, f32 density
				, bool liner
				, bool pixel
				, bool range
				)
: m_Param(enable, color, start, end, density, liner, pixel, range)
{
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CDXFog::Draw(void)
{
	Activate();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXFog::Release(void)
{
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void CDXFog::Reset(void)
{
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void CDXFog::Restore(void)
{
	Activate();
}

/**********************************************************************//**
 *
 * K
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXFog::Activate(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return false;

	pDevice.SetRenderState(D3DRS_FOGCOLOR, (DWORD)m_Param.color);
	pDevice.SetRenderState(
		m_Param.pixel ? D3DRS_FOGTABLEMODE : D3DRS_FOGVERTEXMODE,
		m_Param.liner ? D3DFOG_LINEAR : D3DFOG_EXP);

	if(m_Param.liner)
	{
		pDevice.SetRenderState(D3DRS_FOGSTART, *(DWORD*)(&m_Param.start));
		pDevice.SetRenderState(D3DRS_FOGEND  , *(DWORD*)(&m_Param.end));
	}
	else
	{
		pDevice.SetRenderState(D3DRS_FOGDENSITY, *(DWORD*)(&m_Param.density));
	}

	if(!m_Param.pixel)
		pDevice.SetRenderState(D3DRS_RANGEFOGENABLE, m_Param.range);
	pDevice.SetRenderState(D3DRS_FOGENABLE, m_Param.enable);
	return true;
}


}	// end of namespace dx
}	// end of namespace iris
