//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMessage.h
 * @brief		directX bZ[WNXt@C
 *
 * @note		GȃNX݌vɂȂĂ܂BBB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMessage_H_
#define INCG_IRIS_DXMessage_H_

//======================================================================
// include
#include "DXMessageData.h"
#include "../font/DXFontResource.h"

namespace iris {
namespace dx
{

//======================================================================
//! bZ[WǗNX
class CDXMessageMgr : public IDXGXObject
{
public:
	typedef IDXFontResource					*LPFontResource;
	typedef std::map<UINT, LPFontResource>	CResMap;
	typedef std::pair<UINT, LPFontResource>	CResPair;
	typedef CResMap::iterator				res_iterator;

	typedef CDXMessage						*LPMessage;
	typedef std::map<UINT, LPMessage>		CMsgMap;
	typedef std::pair<UINT, LPMessage>		CMsgPair;
	typedef CMsgMap::iterator				msg_iterator;

	typedef enum
	{
		eERROR_ID = (UINT)-1,	//!< error ID
	} ERROR_ID;

protected:
	CResMap		m_Resource;	//!< \[XXg
	CMsgMap		m_Message;	//!< bZ[WXg

public:
	// RXgN^
	CDXMessageMgr(void);
	// fXgN^
	virtual ~CDXMessageMgr(void);

public:
	// 쐬
	virtual bool	Create(void)	{ return true; }
	// 
	virtual void	Release(void);
	// XV
	virtual void	Update(f32 time);
	// `
	virtual void	Draw(void);

protected:
	// Zbg
	virtual void	Reset(void)		{}
	// XgA
	virtual void	Restore(void)	{}
public:
	/// bZ[W쐬
	template<class _TC>
	_TC*			CreateMessage(UINT uID, UINT uResID)
	{
		if( GetMessage(uID) != nullptr ) return false;
		_TC* msg = new _TC(uResID);
		m_Message.insert( CMsgPair(uID, msg) );
		return msg;
	}
	/// bZ[W쐬
	CDXMessage*	CreateMessage(UINT uID, UINT uResID)
	{
		return CreateMessage<CDXMessage>(uID, uResID);
	}

	// bZ[W폜
	bool		DeleteMessage(UINT uID);
	// bZ[W擾
	LPMessage	GetMessage(UINT uID);

public:	
	/// tHg\[X쐬
	template<class _ResFont>
	_ResFont*	CreateResource(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
#ifdef UNICDOE
		return CreateResourceW<_ResFont>(uID, width, height, lpInfo);
#else
		return CreateResourceA<_ResFont>(uID, width, height, lpInfo);
#endif
	}
	/// tHg\[X쐬
	CDXHFontResource*	CreateResource(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		return CreateResource<CDXHFontResource>(uID, width, height, lpInfo);
	}

	// tHg\[X폜
	bool			DeleteResource(UINT uID);
	// \[X擾
	LPFontResource	GetResource(UINT uID);
	// \[X
	bool			WriteResourceA(UINT uID, LPCSTR  pString, size_t size);
	bool			WriteResourceW(UINT uID, LPCWSTR pString, size_t size);
#ifdef UNICODE
	virtual bool	WriteResource(UINT uID, LPCWSTR pString, size_t size)	{ return WriteResourceW(uID, pString, size); }
#else
	virtual bool	WriteResource(UINT uID, LPCSTR  pString, size_t size)	{ return WriteResourceA(uID, pString, size); }
#endif

public:
	/// tHg\[X쐬
	template<class _ResFont>
	_ResFont*	CreateResourceA(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		if( uID == eERROR_ID )			return nullptr;
		if( GetResource(uID) != nullptr )	return nullptr;
		_ResFont* res = new _ResFont;
		if( !RegisterResourceA(uID, width, height, lpInfo, res) )
		{
			delete res;
			res = nullptr;
		}
		return res;
	}
	/// tHg\[X쐬
	template<class _ResFont>
	_ResFont*	CreateResourceW(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		if( uID == eERROR_ID )			return nullptr;
		if( GetResource(uID) != nullptr )	return nullptr;
		_ResFont* res = new _ResFont;
		if( !RegisterResourceW(uID, width, height, lpInfo, res) )
		{
			delete res;
			res = nullptr;
		}
		return res;
	}
	/// tHg\[X쐬
	CDXHFontResource*	CreateResourceA(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		return CreateResourceA<CDXHFontResource>(uID, width, height, lpInfo);
	}
	/// tHg\[X쐬
	CDXHFontResource*	CreateResourceW(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		return CreateResourceW<CDXHFontResource>(uID, width, height, lpInfo);
	}


private:
	// \[Xo^
	bool			RegisterResource (UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo, LPFontResource pResFont);
	bool			RegisterResourceA(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo, LPFontResource pResFont);
	bool			RegisterResourceW(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo, LPFontResource pResFont);

};

}	// end of namespace dx
}	// end of namespace iris

#endif	
