//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMeshSimple.cpp
 * @brief		directX ȈՃbVNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXMeshSimple_CPP_

//======================================================================
// include
#include "DXMeshSimple.h"
#include "../DXDevice.h"

#include "iris_debug.h"
#include "../../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXMeshSimple::CDXMeshSimple(void)
: m_pMesh(nullptr)
, m_pMaterials(nullptr)
, m_dwNumMaterials(0)
, m_pTextures(nullptr)
, m_pfnCreateTexture(DXMeshDefaultCreateTexture)
, m_pfnDeleteTexture(DXMeshDefaultDeleteTexture)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CDXMeshSimple::~CDXMeshSimple(void)
{
	Release();
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void CDXMeshSimple::Draw(void)
{
	if( m_pMesh != nullptr )
	{
		CDXDeviceX pDevice = nullptr;
		m_pMesh->GetDevice(&pDevice);
		if( pDevice == nullptr ) return;
		SetupRenderState();
		pDevice.SetTransform(D3DTS_WORLD , &m_Mtx);

		DWORD NumMaterials = m_dwNumMaterials;
		LPDXMATERIAL pMeshMaterials = m_pMaterials;
		LPDXTEXTURE* pTextures = m_pTextures;

		// _O
		for( DWORD i = 0 ; i < NumMaterials; i++ )
		{
			pDevice.SetMaterial( &pMeshMaterials[i] );
			if( pTextures != nullptr )
				pDevice.SetTexture( 0 , pTextures[i] );
			else
				pDevice.SetTexture( 0 , nullptr ); 
			m_pMesh->DrawSubset( i );
		}	
	}
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void CDXMeshSimple::Release(void)
{
	IDXMesh::Release();
	// eNX`̉
	if(m_pTextures)
	{
		// œK
		DWORD NumMaterials = m_dwNumMaterials;
		for(DWORD i = 0 ; i < NumMaterials ; ++i)
		{
			if( m_pfnDeleteTexture != nullptr )
			{
				(*m_pfnDeleteTexture)( &m_pTextures[i] );
			}
			else
			{
				DX_SAFE_RELEASE( m_pTextures[i] );
			}
		}
		delete[] m_pTextures;
		m_pTextures = nullptr;
	}

	DX_SAFE_DELETE_ARRAY( m_pMaterials );
	DX_SAFE_RELEASE( m_pMesh );
}

/**********************************************************************//**
 *
 * xt@C̓ǂݍ
 * 
 ----------------------------------------------------------------------
 * @param [in]	filename	= t@C
 * @return	
*//***********************************************************************/
bool CDXMeshSimple::Load(LPCTSTR filename)
{
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr ) 
	{
		dprintf( TEXT("There is no device <%s>.\n"), filename );
		return false;
	}
	if( filename == nullptr ) return false;

	LPCDXDEVICE pDevice = pDxDevice->GetDevice();
	if( pDevice == nullptr ) return false;

	// œK
	DWORD NumMaterials;
	// Xt@C烁bV[h	
	LPD3DXBUFFER pD3DXMtrlBuffer = nullptr;

	if( FAILED( D3DXLoadMeshFromX( filename, D3DXMESH_SYSTEMMEM
			, pDevice, nullptr, &pD3DXMtrlBuffer, nullptr
			, &NumMaterials , &m_pMesh ) ) )
    {
		dprintf( TEXT("failed D3DXLoadMeshFromX <%s>.\n"), filename );
		return false;   
    }
	m_dwNumMaterials = NumMaterials;
	D3DXMATERIAL* d3dxMaterials = static_cast<D3DXMATERIAL*>(pD3DXMtrlBuffer->GetBufferPointer());
	m_pMaterials = new DXMATERIAL [NumMaterials];
	LPDXMATERIAL pMeshMaterials = m_pMaterials;
    m_pTextures  = new LPDXTEXTURE [m_dwNumMaterials];

	for( DWORD i = 0 ; i < NumMaterials ; ++i )
	{ 
		m_pTextures[i] = nullptr;
		pMeshMaterials[i] = d3dxMaterials[i].MatD3D;		
        //pMeshMaterials[i].Ambient = pMeshMaterials[i].Diffuse;
        if( d3dxMaterials[i].pTextureFilename != nullptr && m_pfnCreateTexture != nullptr )
        {   
			if( FAILED( (*m_pfnCreateTexture)(pDevice, d3dxMaterials[i].pTextureFilename, &m_pTextures[i]) ) )
			{
				dprintf( TEXT("failed D3DXCreateTextureFromFileEx <%s>.\n"), d3dxMaterials[i].pTextureFilename );
			}
        }
    }
	pD3DXMtrlBuffer->Release();
	return true;
}

/**********************************************************************//**
 *
 * ǂݍݍς݂ǂ
 * 
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CDXMeshSimple::IsValid(void)
{
	return (m_pMesh != nullptr);
}

}	// end of namespace dx
}	// end of namespace iris
