//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFontResource.cpp
 * @brief		directX tHg\[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXFontResource_CPP_

//======================================================================
// include
#include "DXFontResource.h"

namespace iris {
namespace dx
{

//======================================================================
// class

//======================================================================
// IDXFontResource

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXFontResource::IDXFontResource(void)
{
	m_Current.x = 0;
	m_Current.y = 0;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IDXFontResource::~IDXFontResource(void)
{
}

/**********************************************************************//**
 *
 * R[hNA
 *
*//***********************************************************************/
void IDXFontResource::ClearCode(void)
{
	m_CodeMap.clear(); 
	m_Current.x = 0;
	m_Current.y = 0; 
}

/**********************************************************************//**
 *
 * \[X
 *
 ----------------------------------------------------------------------
 * @param [in]	pString	= 
 * @param [in]	size	= 
 * @return	
*//***********************************************************************/
bool IDXFontResource::WriteResourceA(LPCSTR  pString, size_t size)
{
	bool ret = false;
	LPCSTR c = pString;
	LPCSTR e = c+size;
	for( ; c < e; )
	{
		LPCSTR tmp = c;
		UINT code;
		c += IDXFont::mbtocode(c,code);
		ret &= WriteCodeA( tmp, code );
	}
	return ret;
}
/// IDXFontResource::WriteResourceA Q
bool IDXFontResource::WriteResourceW(LPCWSTR pString, size_t size)
{
	bool ret = false;
	LPCWSTR c = pString;
	LPCWSTR e = c+size;
	for( ; c < e; ++c )
	{
		UINT code = *c;
		ret &= WriteCodeW( c, code );
	}
	return ret;
}

/**********************************************************************//**
 *
 * R[h`
 *
 ----------------------------------------------------------------------
 * @param [in]	c	= PR[h
 * @return	
*//***********************************************************************/
bool IDXFontResource::DrawCodeA(LPCSTR  c)
{
	UINT code;
	IDXFont::mbtocode(c,code);
	return DrawCode(code);
}
/// IDXFontResource::DrawCodeA Q
bool IDXFontResource::DrawCodeW(LPCWSTR c)
{
	UINT code = *c;
	return DrawCode(code);
}

/**********************************************************************//**
 *
 * R[h}bvXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= R[h
 * @return	Ce[^
*//***********************************************************************/
IDXFontResource::iterator IDXFontResource::FindCodeMap(UINT code)
{
	for( iterator it = m_CodeMap.begin(), end = m_CodeMap.end(); it != end; ++it )
	{
		if( it->first == code ) return it;
	}
	return m_CodeMap.end();
}

/**********************************************************************//**
 *
 * eNX`W擾
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= R[h
 * @param [in]	point	= eNX`W()
 * @return	
*//***********************************************************************/
bool IDXFontResource::GetCodePoint(UINT code, POINT& point)
{
	for( iterator it = m_CodeMap.begin(), end = m_CodeMap.end(); it != end; ++it )
	{
		if( it->first == code ) 
		{
			point = it->second;
			return true;
		}
	}
	return false;
}

}	// end of namespace dx
}	// end of namespace iris
