//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFVF.h
 * @brief		directX _tH[}bg̃x[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXFVF_H_
#define INCG_IRIS_DXFVF_H_

//======================================================================
// include
#include "../../dx_inchead.h"
#include "iris_object.h"

namespace iris {
namespace dx
{

//======================================================================
// class
//! _tH[}bgNX
template<u32 _FVF>
class CDXFVF : public IIrisObject
{
	typedef CDXFVF<_FVF>	_Myt;
protected:
	// vertex
	template<u32 _FVF, typename TMP>
	struct _fvf_vertex
	{
		enum { value = false, num = 0 };
	};
	template<typename TMP>
	struct _fvf_vertex<D3DFVF_XYZ, TMP>
	{
		enum { value = true, num = 3 };
	};
#ifdef D3DFVF_XYZW
	template<typename TMP>
	struct _fvf_vertex<D3DFVF_XYZW, TMP>
	{
		enum { value = true, num = 4 };
	};
#endif
	template<typename TMP>
	struct _fvf_vertex<D3DFVF_XYZRHW, TMP>
	{
		enum { value = true, num = 4 };
	};
#ifdef D3DFVF_XYZB1
	template<typename TMP>
	struct _fvf_vertex<D3DFVF_XYZB1, TMP>
	{
		enum { value = true, num = 4 };
	};
#endif
#ifdef D3DFVF_XYZB2
	template<typename TMP>
	struct _fvf_vertex<D3DFVF_XYZB2, TMP>
	{
		enum { value = true, num = 5 };
	};
#endif
#ifdef D3DFVF_XYZB3
	template<typename TMP>
	struct _fvf_vertex<D3DFVF_XYZB3, TMP>
	{
		enum { value = true, num = 6 };
	};
#endif
#ifdef D3DFVF_XYZB4
	template<typename TMP>
	struct _fvf_vertex<D3DFVF_XYZB4, TMP>
	{
		enum { value = true, num = 7 };
	};
#endif
#ifdef D3DFVF_XYZB5
	template<typename TMP>
	struct _fvf_vertex<D3DFVF_XYZB5, TMP>
	{
		enum { value = true, num = 8 };
	};
#endif

	// normal
	template<u32 _FVF, typename TMP>
	struct _fvf_normal
	{
		enum { value = false, num = 0 };
	};
	template<typename TMP>
	struct _fvf_normal<D3DFVF_NORMAL, TMP>
	{
		enum { value = true, num = 3 };
	};

	// diffuse
	template<u32 _FVF, typename TMP>
	struct _fvf_diffuse
	{
		enum { value = false, num = 0 };
	};
	template<typename TMP>
	struct _fvf_diffuse<D3DFVF_DIFFUSE, TMP>
	{
		enum { value = true, num = 1 };
	};

	// specular
	template<u32 _FVF, typename TMP>
	struct _fvf_specular
	{
		enum { value = false, num = 0 };
	};
	template<typename TMP>
	struct _fvf_specular<D3DFVF_SPECULAR, TMP>
	{
		enum { value = true, num = 1 };
	};

	// texture
	template<u32 _FVF, typename TMP>
	struct _fvf_texture
	{
		enum {
			value	= true,
			num		= ((_FVF & D3DFVF_TEXCOUNT_MASK) >> D3DFVF_TEXCOUNT_SHIFT) & 0xf
		};
	};
	template<typename TMP>
	struct _fvf_texture<D3DFVF_TEX0, TMP>
	{
		enum { value = false, num = 0 };
	};

	typedef	_fvf_vertex<_FVF & D3DFVF_POSITION_MASK, void>	fvf_vertex;
	typedef	_fvf_normal<_FVF & D3DFVF_NORMAL, void>			fvf_normal;
	typedef	_fvf_diffuse<_FVF & D3DFVF_DIFFUSE, void>		fvf_diffuse;
	typedef	_fvf_specular<_FVF & D3DFVF_SPECULAR, void>		fvf_specular;
	typedef	_fvf_texture<_FVF & D3DFVF_TEXCOUNT_MASK, void>	fvf_texture;

public:
	typedef typename float	vertex_type;	//!< vertex value type
	typedef typename float	normal_type;	//!< normal value type
	typedef typename DWORD	diffuse_type;	//!< diffuse value type
	typedef typename DWORD	specular_type;	//!< specular value type
	typedef typename float	texture_type;	//!< texture value type
	enum	
	{
		vertex_num		= fvf_vertex::num,							//!< vertex info num
		vertex_size		= fvf_vertex::num*sizeof(vertex_type),		//!< vertex info size

		normal_num		= fvf_normal::num,							//!< normal info num
		normal_size		= fvf_normal::num*sizeof(normal_type),		//!< normal info size

		diffuse_num		= fvf_diffuse::num,							//!< diffuse info num
		diffuse_size	= fvf_diffuse::num*sizeof(diffuse_type),	//!< diffuse info size

		specular_num	= fvf_specular::num,						//!< specular info num
		specular_size	= fvf_specular::num*sizeof(specular_type),	//!< specular info size

		texture_num		= fvf_texture::num,							//!< texture info num
		texture_size	= fvf_texture::num*sizeof(texture_type),	//!< texture info size
	};

	enum
	{
		FVF		= _FVF,	//!< FVF
		SIZE	= vertex_size + normal_size + diffuse_size + specular_size + texture_size,	//!< TCY
	};
public:
	u8	m_vtx[SIZE];

public:
	/// RXgN^
	CDXFVF(void) {}

	/// RXgN^
	//CDXFVF(void) {}

public:
	vertex_type&	x(void)		{ IRIS_ASSERT(vertex_num > 0); return *(reinterpret_cast<vertex_type*>(m_vtx)); }		//!< x
	vertex_type&	y(void)		{ IRIS_ASSERT(vertex_num > 1); return *(reinterpret_cast<vertex_type*>(m_vtx) + 1); }	//!< y
	vertex_type&	z(void)		{ IRIS_ASSERT(vertex_num > 2); return *(reinterpret_cast<vertex_type*>(m_vtx) + 2); }	//!< z
	vertex_type&	w(void)		{ IRIS_ASSERT(vertex_num > 3); return *(reinterpret_cast<vertex_type*>(m_vtx) + 3); }	//!< w
	vertex_type&	rhw(void)	{ IRIS_ASSERT(vertex_num > 3); return *(reinterpret_cast<vertex_type*>(m_vtx) + 3); }	//!< rhw
	vertex_type&	b1(void)	{ IRIS_ASSERT(vertex_num > 3); return *(reinterpret_cast<vertex_type*>(m_vtx) + 3); }	//!< b1
	vertex_type&	b2(void)	{ IRIS_ASSERT(vertex_num > 4); return *(reinterpret_cast<vertex_type*>(m_vtx) + 4); }	//!< b2
	vertex_type&	b3(void)	{ IRIS_ASSERT(vertex_num > 5); return *(reinterpret_cast<vertex_type*>(m_vtx) + 5); }	//!< b3
	vertex_type&	b4(void)	{ IRIS_ASSERT(vertex_num > 6); return *(reinterpret_cast<vertex_type*>(m_vtx) + 6); }	//!< b4
	vertex_type&	b5(void)	{ IRIS_ASSERT(vertex_num > 7); return *(reinterpret_cast<vertex_type*>(m_vtx) + 7); }	//!< b5

	normal_type&	nx(void)	{ IRIS_ASSERT(normal_num); return *(reinterpret_cast<normal_type*>(m_vtx + vertex_size)); }		//!< normal x
	normal_type&	ny(void)	{ IRIS_ASSERT(normal_num); return *(reinterpret_cast<normal_type*>(m_vtx + vertex_size) + 1); }	//!< normal y
	normal_type&	nz(void)	{ IRIS_ASSERT(normal_num); return *(reinterpret_cast<normal_type*>(m_vtx + vertex_size) + 2); }	//!< normal z

	diffuse_type&	diffuse(void)	{ IRIS_ASSERT(diffuse_num);  return *reinterpret_cast<diffuse_type*> (m_vtx + vertex_size + normal_size); }					//!< diffuse
	specular_type&	specular(void)	{ IRIS_ASSERT(specular_num); return *reinterpret_cast<specular_type*>(m_vtx + vertex_size + normal_size + diffuse_size); }	//!< specular

	texture_type&	u(int idx=0)	{ IRIS_ASSERT(texture_num > (idx<<1)); return *(reinterpret_cast<texture_type*>(m_vtx + vertex_size + normal_size + diffuse_size + specular_size) + idx*2); }		//!< u
	texture_type&	v(int idx=0)	{ IRIS_ASSERT(texture_num > (idx<<1)); return *(reinterpret_cast<texture_type*>(m_vtx + vertex_size + normal_size + diffuse_size + specular_size) + idx*2 + 1); }	//!< v

public:
	_Myt&	x(vertex_type x)		{ x() = x; return *this; }		//!< x
	_Myt&	y(vertex_type y)		{ y() = y; return *this; }		//!< y
	_Myt&	z(vertex_type z)		{ z() = z; return *this; }		//!< z
	_Myt&	w(vertex_type w)		{ w() = w; return *this; }		//!< w
	_Myt&	rhw(vertex_type rhw)	{ rhw() = rhw; return *this; }	//!< rhw
	_Myt&	b1(vertex_type b1)		{ b1() = b1; return *this; }	//!< b1
	_Myt&	b2(vertex_type b2)		{ b2() = b2; return *this; }	//!< b2
	_Myt&	b3(vertex_type b3)		{ b3() = b3; return *this; }	//!< b3
	_Myt&	b4(vertex_type b4)		{ b4() = b4; return *this; }	//!< b4
	_Myt&	b5(vertex_type b5)		{ b5() = b5; return *this; }	//!< b5

	_Myt&	nx(normal_type x)		{ nx() = x; return *this; }		//!< normal x
	_Myt&	ny(normal_type y)		{ ny() = y; return *this; }		//!< normal y
	_Myt&	nz(normal_type z)		{ nz() = z; return *this; }		//!< normal z

	_Myt&	diffuse(diffuse_type d)			{ diffuse() = d; return *this; }	//!< diffuse
	_Myt&	diffuse(u8 a, u8 r, u8 g, u8 b)	{ diffuse() = IRIS_ARGB(a, r, g, b); return *this; }	//!< diffuse
	_Myt&	specular(specular_type s)		{ specular() = s; return *this; }	//!< specular
	_Myt&	specular(u8 a, u8 r, u8 g, u8 b){ specular() = IRIS_ARGB(a, r, g, b); return *this; }	//!< diffuse

	_Myt&	u(texture_type u, int idx=0)	{ u(idx) = u; return *this; }	//!< u
	_Myt&	v(texture_type u, int idx=0)	{ v(idx) = v; return *this; }	//!< v


public:
	_Myt&	vertex(vertex_type x, vertex_type y, vertex_type z)
	{
		vertex_type* vtx = reinterpret_cast<vertex_type*>(m_vtx);
		*vtx++ = x; *vtx++ = y; *vtx = z;
		return *this;
	}
	_Myt&	vertex(vertex_type x, vertex_type y, vertex_type z, vertex_type w)
	{
		vertex_type* vtx = reinterpret_cast<vertex_type*>(m_vtx);
		*vtx++ = x; *vtx++ = y; *vtx++ = z; *vtx = w;
		return *this;
	}
	_Myt&	vertex_rhw(vertex_type x, vertex_type y, vertex_type z, vertex_type rhw)
	{
		vertex_type* vtx = reinterpret_cast<vertex_type*>(m_vtx);
		*vtx++ = x; *vtx++ = y; *vtx++ = z; *vtx = rhw;
		return *this;
	}
	_Myt&	vertex_blend(vertex_type x, vertex_type y, vertex_type z, vertex_type b1)
	{
		vertex_type* vtx = reinterpret_cast<vertex_type*>(m_vtx);
		*vtx++ = x; *vtx++ = y; *vtx++ = z; *vtx = b1;
		return *this;
	}
	_Myt&	vertex_blend(vertex_type x, vertex_type y, vertex_type z
		, vertex_type b1, vertex_type b2)
	{
		vertex_type* vtx = reinterpret_cast<vertex_type*>(m_vtx);
		*vtx++ = x; *vtx++ = y; *vtx++ = z; *vtx++ = b1; *vtx = b2;
		return *this;
	}
	_Myt&	vertex_blend(vertex_type x, vertex_type y, vertex_type z
		, vertex_type b1, vertex_type b2, vertex_type b3)
	{
		vertex_type* vtx = reinterpret_cast<vertex_type*>(m_vtx);
		*vtx++ = x; *vtx++ = y; *vtx++ = z; *vtx++ = b1; *vtx++ = b2; *vtx = b3;
		return *this;
	}
	_Myt&	vertex_blend(vertex_type x, vertex_type y, vertex_type z
		, vertex_type b1, vertex_type b2, vertex_type b3, vertex_type b4)
	{
		vertex_type* vtx = reinterpret_cast<vertex_type*>(m_vtx);
		*vtx++ = x; *vtx++ = y; *vtx++ = z; *vtx++ = b1; *vtx++ = b2; *vtx++ = b3; *vtx = b4;
		return *this;
	}
	_Myt&	vertex_blend(vertex_type x, vertex_type y, vertex_type z
		, vertex_type b1, vertex_type b2, vertex_type b3, vertex_type b4, vertex_type b5)
	{
		vertex_type* vtx = reinterpret_cast<vertex_type*>(m_vtx);
		*vtx++ = x; *vtx++ = y; *vtx++ = z; *vtx++ = b1; *vtx++ = b2; *vtx++ = b3; *vtx++ = b4; *vtx = b5;
		return *this;
	}
	_Myt&	normal(normal_type x, normal_type y, normal_type z)
	{ 
		normal_type* vtx = reinterpret_cast<normal_type*>(m_vtx + vertex_size);
		*vtx++ = x; *vtx++ = y; *vtx = z;
		return *this;
	}
	_Myt&	uv(texture_type u, texture_type v, int idx=0)
	{
		texture_type* uv = reinterpret_cast<texture_type*>(m_vtx + vertex_size + normal_size + diffuse_size + specular_size);
		uv += idx<<1;
		*uv++ = u; *uv++ = v;
		return *this;
	}
};

}	// end of namespace dx
}	// end of namespace iris

#endif	
