//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXObject.cpp
 * @brief		DirectXfoCXIuWF̃x[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXObject_CPP_

//======================================================================
// include
#include "DXObject.h"
#include "DXDevice.h"
#include "DXSwapChain.h"

#include "../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXGXObject::IDXGXObject(void)
: m_pDevice(nullptr)
, m_pSwapChain(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IDXGXObject::~IDXGXObject(void)
{
	if( m_pSwapChain != nullptr && m_pSwapChain != this )
	{
		m_pSwapChain->EraseLayerObjectForce(this);
		m_pSwapChain->EraseDeviceObject(this);
	}
	if( m_pDevice != nullptr )
	{
		m_pDevice->EraseDeviceObject(this);
	}
}

/**********************************************************************//**
 *
 * foCX̎擾
 * 
 ----------------------------------------------------------------------
 * @return	LPCDXDEVICE
*//***********************************************************************/
CDXDeviceX& IDXGXObject::GetDeviceX(void) const
{
	IRIS_ASSERT( m_pDevice != nullptr );
	return m_pDevice->GetDevice(); 
}

/**********************************************************************//**
 *
 * foCX̎擾
 * 
 ----------------------------------------------------------------------
 * @return	LPCDXDEVICE
*//***********************************************************************/
LPCDXDEVICE IDXGXObject::GetDevice(void) const
{
	if( m_pDevice == nullptr ) return nullptr;
	return m_pDevice->GetDevice(); 
}

/**********************************************************************//**
 *
 * XvCg̎擾
 * 
 ----------------------------------------------------------------------
 * @return	LPCDXSPRITE
*//***********************************************************************/
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
LPCDXSPRITE IDXGXObject::GetSprite(void) const
{
	if( m_pDevice == nullptr ) return nullptr;
	return m_pDevice->GetSprite(); 
}
#endif

/**********************************************************************//**
 *
 * D3DPRESENT_PARAMETERS̎擾
 * 
 ----------------------------------------------------------------------
 * @return	LPCDXPRESENT_PARAMETERS
*//***********************************************************************/
LPCDXPRESENT_PARAMETERS const IDXGXObject::GetPresent(void) const
{
	if( m_pDevice == nullptr ) return nullptr;
	if( m_pSwapChain != nullptr ) return m_pSwapChain->GetPresent();
	return m_pDevice->GetPresent(); 
}

/**********************************************************************//**
 *
 * foCX̓o^
 *		CDXDeviceĂ΂
 * 
 ----------------------------------------------------------------------
 * @param [in]	pDevice		= foCXǗNX
 * @param [in]	pSwapChain	= Xbv`F[NX
 * @return	
*//***********************************************************************/
void IDXGXObject::SetDevice(CDXDevice* pDevice, IDXSwapChain* pSwapChain)
{
#if 0
	if( pDevice == nullptr )
	{
		LPDXDEVICE p = GetDevice();
		if( p != nullptr ) p->Release();
	}
	else
	{
		LPDXDEVICE p = pDevice->GetDevice();
		if( p == nullptr ) return;
		p->AddRef();
	}
#endif
	m_pDevice = pDevice;
	m_pSwapChain = pSwapChain;
}

}	// end of namespace dx
}	// end of namespace iris
