//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXDevice.h
 * @brief		DirectXfoCXǗt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXDevice_H_
#define INCG_IRIS_DXDevice_H_

//======================================================================
// include
#include "../dx_inchead.h"
#include "../DXLib.h"
#include "DXSwapChain.h"
#include "scene/DXFog.h"
#include "env/DXRenderState.h"
#include "fnd/utility/FndLockObject.h"

namespace iris {
namespace dx
{

//======================================================================
// declare
class CDXLight;

//======================================================================
// class
//! OtBbN@\ǗNX
class CDXDevice : public INonCopyable<>
{
	friend class IDXGXObject;		//!< DXObjectꂩ̃ANZX
	friend class IDXSwapChain;	//!< Xbv`F[̃ANZX
public:
	//!< foCX
	typedef enum STATE_FLAG
	{
		DXDS_RESTORED		= 0x00000001,	//!< foCXXgAς
		DXDS_DEVICE_LOST	= 0x00008000,	//!< foCXXg

		// ݒ
		DXDS_ANTIALIAS		= 0x00010000,	//!< A`GCAX
		DXDS_STENCILBUFFER	= 0x00020000,	//!< XeVobt@
		DXDS_TERM
	} STATE_FLAG;

	//!< 쐬IvV
	typedef enum CREATE_FLAG
	{
		DXCF_FULLSCREEN		= 0x00000001,	//!< tXN[
		DXCF_ANTIALIAS		= 0x00000002,	//!< A`GCAX
		DXCF_STENCIL		= 0x00000004,	//!< XeVobt@
		DXCF_MULTI_THREAD	= 0x00000010,	//!< }`XbhZ[t
		DXCF_HIGH_FPU		= 0x00010000,	//!< highPrecisionFPU
		DXCF_PURE_SOFTWARTE	= 0x00020000,	//!< pureSoftware
	} CREATE_FLAG;

public:
	typedef	std::vector<IDXGXObject*>		vecObj;

private:
	// WindowHandle
	HWND						m_hWnd;		//!< EBhEnh
	DXCAPS						m_Caps;		//!< 
	CDXDeviceX					m_pDevice;	//!< Direct3DfoCX
	DXPRESENT_PARAMETERS		m_Present;	//!< 
	DXFOGPARAM					m_Fog;		//!< tHOp[^
	u32							m_State;	//!< 
	CDXRenderState				m_RenderState;	//!< ftHg_OXe[g

#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPDXSPRITE					m_pSprite;	//!< XvCg
#endif

private:
	vecObj						m_Objects;		//!< IuWFNgXg
	CDXDefaultSwapChain			m_SwapChain;	//!< ftHgXbv`F[

	fnd::CLockObject			m_Lock;			//!< bN

private:
	LPDXSURFACE			m_pBackBufferSurface;	//!< obNobt@T[tFCX

public:

	// RXgN^
	CDXDevice(void);
	explicit CDXDevice(HWND hWnd);
	// fXgN^
	virtual ~CDXDevice(void);
	
	// foCX
	bool		CreateDevice(UINT width, UINT height, u32 uFlag);
	bool		CreateDevice(UINT width, UINT height
							, bool fullscreen, bool antialias, bool stencilbuffer
							, bool highPrecisionFPU, bool pureSoftware, bool bMultiThread);
	// XvCg쐬
	bool		CreateSprite(void);
	// ̈̍XV
	bool		ReSize(UINT width, UINT height);

	// XV
	void		Update(f32 time);

	// `̊Jn
	bool		BeginScene(D3DCOLOR color=0xff101080, bool backbuffer=true, bool zbuffer=true);
	// `
	void		Draw(void);
	// `̏I
	bool		EndScene(void);
	// ]
	bool		Present(const RECT* pSrcRect=nullptr);
	// ]
	bool		PresentOverride(const RECT* pSrcRect=nullptr, HWND hDestWindowOverride=nullptr);

public:
	// _OXe[g̐ݒ
	void		SetDefaultRenderState(void);
	/// tHO̐ݒ
	void		SetFog(bool enable, intr::DXICOLOR color, f32 start, f32 end, f32 density, bool liner, bool pixel, bool range)	{ SetFog((DXFOGPARAM(enable, color, start, end, density, liner, pixel, range))); }
	/// tHO̐ݒ
	void		SetFog(const DXFOGPARAM& rFogParam)	{ m_Fog = rFogParam; }
	// tHO̍XV
	void		UpdateFogParam(void);

public:
	//
	// object
	/// IuWFNg̍쐬
	template<class _TC>
	_TC*		CreateObject(void)	{ return m_SwapChain.CreateObject<_TC>(); }

	// IuWFNg̓o^
	bool		RegisterDeviceObject(IDXGXObject* obj);
	// IuWFNg̓o^
	bool		RegisterDeviceObject(IDXGXObject* obj, IDXSwapChain* pSwapChain);
	// IuWFNg̍폜
	bool		EraseDeviceObject(IDXGXObject* obj);

	/// C[ɃIuWFNgǉ
	bool		RegisterLayerObject(int LayerID, IDXGXObject* obj)
						{ return m_SwapChain.RegisterLayerObject(LayerID, obj); }
	/// C[IuWFNg폜
	bool		EraseLayerObject(int LayerID, IDXGXObject* obj)
						{ return m_SwapChain.EraseLayerObject(LayerID, obj); }

	/// IuWFNg̓o^ + C[ɃIuWFNgǉ
	bool		RegisterObject(int LayerID, IDXGXObject* obj)
						{ if( !RegisterDeviceObject(obj) ) return false; return RegisterLayerObject(LayerID, obj); }
	/// IuWFNg̍폜 + C[IuWFNg폜
	bool		EraseObject(int LayerID, IDXGXObject* obj)
						{ bool ret = EraseDeviceObject(obj); ret &= EraseLayerObject(LayerID, obj); return ret; }
private:
	/// C[狭폜
	void		EraseLayerObjectForce(IDXGXObject* obj)		{ m_SwapChain.EraseLayerObjectForce(obj); }

public:
	//
	// Layer

	/// C[̒ǉ
	bool		RegisterLayer(int LayerID, IDXLayer* layer)	{ return m_SwapChain.RegisterLayer(LayerID, layer); }
	/// C[̍폜
	bool		EraseLayer(int LayerID)		{ return m_SwapChain.EraseLayer(LayerID); }		//!< call CDXLayerMgr::EraseLayer.
	bool		EraseLayer(IDXLayer* layer)	{ return m_SwapChain.EraseLayer(layer); }		//!< call CDXLayerMgr::EraseLayer.
	void		EraseLayerAll(void)			{ m_SwapChain.EraseLayerAll(); }				//!< call CDXLayerMgr::EraseLayerAll.
	/// C[̍폜ideletej
	bool		ReleaseLayer(int LayerID)	{ return m_SwapChain.ReleaseLayer(LayerID); }	//!< call CDXLayerMgr::ReleaseLayer.
	void		ReleaseLayerAll(void)		{ m_SwapChain.ReleaseLayerAll(); }				//!< call CDXLayerMgr::ReleaseLayerAll.

	/// C[̎擾
	IDXLayer*	GetLayer(int LayerID)		{ return m_SwapChain.GetLayer(LayerID); }		//!< call CDXLayerMgr::GetLayer.

	/// C[Ǘ̎擾
	CDXLayerMgr&	GetLayerMgr(void)		{ return m_SwapChain.GetLayerMgr(); }

public:

	//
	// Light
	// Cgݒ
	void		SetLight(DWORD index, CDXLight* light);
	void		GetCurrentLight(DWORD index, CDXLight* light);

	// ̐ݒ
	void		SetAmbient(D3DCOLOR ambient=D3DCOLOR_ARGB(0xff,0xff,0xff,0xff));

public:

	/**
	 * @name	ANZT
	 * @{
	*/

	// HWND
	bool								SetHWND(HWND hWnd);
	HWND								GetHWND(void)			{ return m_hWnd; }
	// device
	CDXDeviceX&							GetDevice(void)			{ return m_pDevice; }
	const CDXDeviceX&					GetDevice(void)	const	{ return m_pDevice; }
	bool								IsValid(void)	const	{ return (m_pDevice != nullptr); }
	// sprite
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPCDXSPRITE							GetSprite(void) const	{ return m_pSprite; }
#endif
	// present
	LPDXPRESENT_PARAMETERS				GetPresent(void)		{ return &m_Present; }
	LPCDXPRESENT_PARAMETERS const		GetPresent(void) const	{ return &m_Present; }
	// swap chain
	CDXDefaultSwapChain&				GetDXSwapChain(void)	{ return m_SwapChain; }

	// state
	bool		IsState(u32 state)		{ return (m_State & state) ? true : false; }
	bool		IsEqualState(u32 state)	{ return ((m_State & state) == state) ? true : false; }
	u32			GetState(void)			{ return m_State; }

	/**
	 * @}
	*/
private:
	void		EnableState(u32 state)	{ m_State |= state; }
	void		DisableState(u32 state)	{ m_State &= ~state; }
	void		SetState(u32 state, bool enable)	{ enable ? EnableState(state) : DisableState(state); }

public:
	// foCXԂ̃eXg
	HRESULT		TestCooperativeLevel(void);
	// foCX̕
	bool		RestoreDevice(void);
	// foCX̍č\z
	bool		RebuildDevice(void);
	// 
	void		Release(void);

public:
	// Device Context
	HRESULT		GetDC(HDC* phdc);
	HRESULT		ReleaseDC(HDC hdc);

	/**
	 * @name	wrap
	 * @{
	*/
	HRESULT		SetTransform(D3DTRANSFORMSTATETYPE State, const D3DMATRIX* pMatrix)	{ return m_pDevice.SetTransform(State, pMatrix); }
	HRESULT		GetTransform(D3DTRANSFORMSTATETYPE State, 	   D3DMATRIX* pMatrix)	{ return m_pDevice.GetTransform(State, pMatrix); }

	HRESULT		SetRenderState(D3DRENDERSTATETYPE State, DWORD   Value)	{ return m_pDevice.SetRenderState(State, Value); }
	HRESULT		GetRenderState(D3DRENDERSTATETYPE State, DWORD* pValue)	{ return m_pDevice.GetRenderState(State, pValue); }

	HRESULT		SetRenderTarget(DWORD RenderTargetIndex, LPDXSURFACE   pRenderTarget)	{ return m_pDevice.SetRenderTarget(RenderTargetIndex, pRenderTarget); }
	HRESULT		GetRenderTarget(DWORD RenderTargetIndex, LPDXSURFACE* ppRenderTarget)	{ return m_pDevice.GetRenderTarget(RenderTargetIndex, ppRenderTarget); }

	HRESULT		SetDepthStencilSurface(LPDXSURFACE lpSurface)	{ return m_pDevice.SetDepthStencilSurface(lpSurface); }
	/**
	 * @}
	*/
};

}	// end of namespace dx
}	// end of namespace iris

#endif
