//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WceWrapWindow.h
 * @brief		EBhEnh֌Wbv֐Q t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WceWrapWindow_CPP_

//======================================================================
// include
#include "WceWrapWindow.h"

#if	defined(IRIS_WIN32_WCE)

//======================================================================
// struct
typedef struct _tagEnumChildWindowsInfo
{
	HWND		hWnd;
	WNDENUMPROC	pfnProc;
	LPARAM		param;
	BOOL		bFind;
} _EnumChildWindowsInfo;

//======================================================================
// declare
BOOL _EnumChildWindowsProc(HWND, LPARAM);

//======================================================================
// function
/**********************************************************************//**
 * @internal
 *
 * FindWindowEx
 *
 -----------------------------------------------------------------------
 * @param [in]	hParent			= ΏېeEBhE
 * @param [in]	hChild			= JnqEBhẼnh(NULL ̏ꍇ́A擪猟)
 * @param [in]	lpszClassName	= NX
 * @param [in]	lpszWindowName	= EBhE
*//***********************************************************************/
HWND	WINAPI	FindWindowExA(HWND hParent, HWND hChild, LPCSTR  lpszClassName, LPCSTR  lpszWindowName)
{
	if( hParent == nullptr && hChild == nullptr ) return FindWindowA(lpszClassName, lpszWindowName);
	HWND hRoot = hParent;
	HWND hFind = nullptr;
	CHAR name[512];
	if( hChild != nullptr )
	{
		if( hParent != ::GetParent(hChild) ) return nullptr;
		hRoot = hChild;
	}
	if( hRoot == nullptr )
	{
		hRoot = ::GetDesktopWindow();
	}
	HWND hWnd = hRoot;
	for( ; hWnd != nullptr; hWnd = ::GetWindow(hWnd, GW_HWNDNEXT) )
	{
		::GetClassNameA(hWnd, name, 512);
		if( strcmp(name, lpszClassName) != 0 ) continue;
		::GetWindowTextA(hWnd, name, 512);
		if( strcmp(name, lpszWindowName) != 0 ) continue;
		return hWnd;
	}
	hWnd = hRoot;
	for( ; hWnd != nullptr; hWnd = ::GetWindow(hWnd, GW_HWNDNEXT) )
	{
		hFind = FindWindowExA(hWnd, nullptr, lpszClassName, lpszWindowName);
		if( hFind != nullptr ) return hFind;
	}
	return nullptr;
}

/**********************************************************************//**
 * @internal
 *
 * FindWindowEx
 *
 -----------------------------------------------------------------------
 * @param [in]	hParent			= ΏېeEBhE
 * @param [in]	hChild			= JnqEBhẼnh(NULL ̏ꍇ́A擪猟)
 * @param [in]	lpszClassName	= NX
 * @param [in]	lpszWindowName	= EBhE
*//***********************************************************************/
HWND	WINAPI	FindWindowExW(HWND hParent, HWND hChild, LPCWSTR lpszClassName, LPCWSTR lpszWindowName)
{
	if( hParent == nullptr && hChild == nullptr ) return FindWindowW(lpszClassName, lpszWindowName);
	HWND hRoot = hParent;
	HWND hFind = nullptr;
	WCHAR name[512];
	if( hChild != nullptr )
	{
		if( hParent != ::GetParent(hChild) ) return nullptr;
		hRoot = hChild;
	}
	if( hRoot == nullptr )
	{
		hRoot = ::GetDesktopWindow();
	}
	HWND hWnd = hRoot;
	for( ; hWnd != nullptr; hWnd = ::GetWindow(hWnd, GW_HWNDNEXT) )
	{
		::GetClassNameW(hWnd, name, 512);
		if( wcscmp(name, lpszClassName) != 0 ) continue;
		::GetWindowTextW(hWnd, name, 512);
		if( wcscmp(name, lpszWindowName) != 0 ) continue;
		return hWnd;
	}
	hWnd = hRoot;
	for( ; hWnd != nullptr; hWnd = ::GetWindow(hWnd, GW_HWNDNEXT) )
	{
		hFind = FindWindowExW(hWnd, nullptr, lpszClassName, lpszWindowName);
		if( hFind != nullptr ) return hFind;
	}
	return nullptr;
}

/**********************************************************************//**
 * @internal
 *
 * CreateIcon
 *
 -----------------------------------------------------------------------
 * @param [in]	hInst		= CX^Xnh
 * @param [in]	nWidth		= (pixel)
 * @param [in]	nHeight		= (pixel)
 * @param [in]	byPlanes	= XOR rbg}XÑJ[v[
 * @param [in]	byBItsPixel	= XOR rbg}XÑsNZ̃rbg
 * @param [in]	lpbANDbits	= AND rbg}XÑrbgf[^
 * @param [in]	lpbXORbits	= XOR rbg}XÑrbgf[^
 * @return	ACRnh
*//***********************************************************************/
HICON	WINAPI	CreateIcon(HINSTANCE hInst, int nWidth, int nHeight, BYTE byPlanes, BYTE byBitsPixel, const BYTE* lpbANDbits, const BYTE* lpbXORbits)
{
	ICONINFO ii;
	ii.fIcon	= TRUE;
	ii.hbmMask  = CreateBitmap(nWidth, nHeight, 1, 1, lpbANDbits);
	ii.hbmColor = CreateBitmap(nWidth, nHeight, byPlanes, byBitsPixel, lpbXORbits);
	ii.xHotspot = ii.yHotspot = 0;
	return CreateIconIndirect(&ii);
}

/**********************************************************************//**
 * @internal
 *
 * GetScrollRange
 *
 -----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	nBar		= o[̎
 * @param [out]	lpMinPos	= ŏl
 * @param [out]	lpMaxPos	= ől
 * @return	
*//***********************************************************************/
BOOL	WINAPI	GetScrollRange(HWND hWnd, int nBar, LPINT lpMinPos, LPINT lpMaxPos)
{
	SCROLLINFO si;
	if( !::GetScrollInfo(hWnd, nBar, &si) ) return FALSE;
	if( lpMinPos != nullptr ) *lpMinPos = si.nMin;
	if( lpMaxPos != nullptr ) *lpMaxPos = si.nMax;
	return TRUE;
}

/**********************************************************************//**
 * @internal
 *
 * SetScrollRange
 *
 -----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	nBar		= o[̎
 * @param [in]	nMinPos		= ŏl
 * @param [in]	nMaxPos		= ől
 * @param [in]	
 * @return	
*//***********************************************************************/
BOOL	WINAPI	GetScrollRange(HWND hWnd, int nBar, INT nMinPos, INT nMaxPos,  BOOL bRedraw)
{
	SCROLLINFO si;
	if( !::GetScrollInfo(hWnd, nBar, &si) ) return FALSE;
	si.nMin = nMinPos;
	si.nMax = nMaxPos;
	return ::SetScrollInfo(hWnd, nBar, &si, bRedraw);
}

/**********************************************************************//**
 * @internal
 *
 * EnumChildWindows
 *
 -----------------------------------------------------------------------
 * @param [in]	hWndParent	= ΏۃEBhEnh
 * @param [in]	lpEnumFunc	= R[obN֐
 * @param [in]	lParam		= R[obNɓn
 * @return	ACRnh
*//***********************************************************************/
BOOL	WINAPI	EnumChildWindows(HWND hWndParent, WNDENUMPROC lpEnumFunc, LPARAM lParam)
{
	_EnumChildWindowsInfo info = {0};
	info.hWnd	= hWndParent;
	info.pfnProc= lpEnumFunc;
	info.param	= lParam;
	return EnumWindows(_EnumChildWindowsProc, (LPARAM)&info);
}

BOOL	_EnumChildWindowsProc(HWND hWnd, LPARAM lParam)
{
	_EnumChildWindowsInfo* pi = (_EnumChildWindowsInfo*)lParam;
	if( pi->bFind )
	{
	}
	else
	{
		if( hWnd == pi->hWnd )
		{
			pi->bFind = TRUE;
			(*pi->pfnProc)(hWnd, pi->param);
		}
	}
	return TRUE;
}

#endif

