//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkWorld.cpp
 * @brief		Havok World t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_HvkWorld_CPP_

//======================================================================
// include
#include "HvkWorld.h"


#ifdef _IRIS_SUPPORT_HAVOK
#include "Physics/Collide/Dispatch/hkpAgentRegisterUtil.h"

//======================================================================
// link
#pragma comment	(lib, "hkpDynamics.lib")

namespace iris {
namespace havok
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CWorld::CWorld(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CWorld::~CWorld(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	simType		= V~[V^Cv
 * @param [in]	tolerance	= x덷i m Pʁj
 * @param [in]	worldSize	= [hTCYî̕ӂ̒j
 * @param [in]	solverType	= ՓˌvŽJԂ^Cv(hkpWorldCinfo::SOLVER_***)
 * @param [in]	gravity		= d̓xNg
 * @retrun	
*//***********************************************************************/
bool CWorld::Create(hkpWorldCinfo::SimulationType simType, hkReal tolerance, hkReal worldSize
					, hkpWorldCinfo::SolverType solverType, hkVector4& gravity)
{
	hkpWorldCinfo info;
	info.m_simulationType = simType;
	info.m_collisionTolerance = tolerance;
	info.setBroadPhaseWorldSize(worldSize);
	info.setupSolverInfo(solverType);
	info.m_gravity = gravity;
	return Create(info);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	info	= [h
 * @retrun	
*//***********************************************************************/
bool CWorld::Create(hkpWorldCinfo& info)
{
	Delete();
	m_ptr = new hkpWorld(info);
	if( m_ptr == nullptr ) return false;

	hkpAgentRegisterUtil::registerAllAgents(ptr()->getCollisionDispatcher());
	return true;
}

/**********************************************************************//**
 *
 * 폜s
 *
*//***********************************************************************/
void CWorld::Delete(void)
{
	if( m_ptr != nullptr )
	{
		value_ptr p = ptr();
		delete p;
		m_ptr = nullptr;
	}
}

/**********************************************************************//**
 *
 * XV
 *
 -----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CWorld::Update(xf32 time)
{
	if( m_ptr != nullptr )
	{
		ptr()->stepDeltaTime(XF_XF32_TO_F32(time));
	}
}

}	// end of namespace havok
}	// end of namespace iris

#endif
