//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkRigid.h
 * @brief		Havok Rigid t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_HvkRigid_H_
#define INCG_IRIS_HvkRigid_H_

//======================================================================
// include
#include "HvkRefObj.h"

#ifdef _IRIS_SUPPORT_HAVOK
#include "Physics/Dynamics/Entity/hkpRigidBody.h"

namespace iris {
namespace havok
{

//======================================================================
// class
/// Rigid NX
class CRigid : public CRefObj<hkpRigidBody>
{
public:
	// RXgN^
	CRigid(void);
	// fXgN^
	virtual ~CRigid(void);
public:
	// 쐬
	bool	Create(hkReal mass, hkpShape* pShape, hkpMotion::MotionType motionType, const hkVector4& position);
	bool	Create(hkpRigidBodyCinfo& info);
};


}	// end of namespace havok
}	// end of namespace iris

#endif

#endif
