//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_op.hpp
 * @brief		iris meta language operator t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_math_HPP_
#define INCG_IRIS_iml_math_HPP_

//======================================================================
// include
#include "../iris_stdint.h"
#include "./math/iml_abs.hpp"
#include "./math/iml_mul.hpp"
#include "./math/iml_pow.hpp"
#include "./math/iml_mask.hpp"
#include "./math/iml_shift.hpp"
#include "./math/iml_sign.hpp"

namespace iml
{

//======================================================================
// class
/**
 * @brief	ő(gcd)
 * @tparam _V1	= l1
 * @tparam _V2	= l2
*/
template<intmax_t _V1, intmax_t _V2>
class static_gcd
{
	static const intmax_t	m = _V1 < _V2 ? _V2 : _V1;
	static const intmax_t	n = _V1 < _V2 ? _V1 : _V2;
	template<intmax_t _T1, intmax_t _T2>
	struct gcd_impl
	{
		static const intmax_t	value = gcd_impl<_T2, _T1%_T2>::value;
	};
	template<intmax_t _T1>
	struct gcd_impl<_T1, 0>
	{
		static const intmax_t value = _T1;
	};
public:
	static const intmax_t value = gcd_impl<m, n>::value;	//!< gcd
};

/**
 * @brief	ŏ{(lcm)
 * @tparam _V1	= l1
 * @tparam _V2	= l2
*/
template<intmax_t _V1, intmax_t _V2>
struct static_lcm
{
	static const intmax_t value = _V1 / static_gcd<_V1, _V2>::value * _V2;
};

}	// end of namespace iml

#endif
