//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_detail.hpp
 * @brief		meta language detail t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD Limlnse is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_detail_HPP_
#define INCG_IRIS_iml_detail_HPP_

//======================================================================
// include

namespace iml {
namespace detail
{

//======================================================================
// struct
// true
typedef struct true_type
{
	static const bool value = true;
} true_type;

// false
typedef struct false_type
{
	static const bool value = false;
} false_type;

/**
 * @internal
 * yes type
*/
typedef struct yes_t
{ 
	char tmp[1];
} yes_t;

// yes type
typedef struct no_t
{ 
	char tmp[2];
} no_t;

//======================================================================
// define
#define is_iml_yes_t(x)	(sizeof(x) == sizeof(iml::detail::yes_t))
#define is_iml_no_t(x)	(sizeof(x) == sizeof(iml::detail::no_t))

}	// end of namespace detail
}	// end of namespace iml

#endif
