/* 
   A C-program for MT19937, with initialization improved 2002/1/26.
   Coded by Takuji Nishimura and Makoto Matsumoto.

   Before using, initialize the state by using init_genrand(seed)  
   or init_by_array(init_key, key_length).

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.							 

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

	 1. Redistributions of source code must retain the above copyright
		notice, this list of conditions and the following disclaimer.

	 2. Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.

	 3. The names of its contributors may not be used to endorse or promote 
		products derived from this software without specific prior written 
		permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.	 IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


   Any feedback is very welcome.
   http://www.math.keio.ac.jp/matumoto/emt.html
   email: matumoto@math.keio.ac.jp
*/
//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndMT19937ar.cpp
 * @brief		Zkt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_RndMT19937ar_CPP_

//======================================================================
// include
#include "RndMT19937ar.h"

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// define
/* Period parameters */	 
#define M 397
#define MATRIX_A	0x9908b0dfUL	/* constant vector a */
#define UPPER_MASK	0x80000000UL	/* most significant w-r bits */
#define LOWER_MASK	0x7fffffffUL	/* least significant r bits */

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMT19937ar::CMT19937ar(void)
: m_mti(N+1)
{
	SetSeed(5489UL);
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	seed	= 
*//***********************************************************************/
void CMT19937ar::SetSeed(u32 seed)
{
	IRand::SetSeed(seed);
	m_mt[0]= seed & 0xffffffffUL;
	u32 mti=1;
	for (mti=1; mti<N; ++mti) {
		m_mt[mti] = 
		(1812433253UL * (m_mt[mti-1] ^ (m_mt[mti-1] >> 30)) + mti); 
		/* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */
		/* In the previous versions, MSBs of the seed affect   */
		/* only MSBs of the array mt[].						   */
		/* 2002/01/09 modified by Makoto Matsumoto			   */
		//mt[mti] &= 0xffffffffUL;
		/* for >32 bit machines */
	}
	m_mti = mti;
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	seed	= 
 * @param [in]	size	= TCY
*//***********************************************************************/
void CMT19937ar::SetArraySeed(u32* seed, s32 size)
{
	int i, j;
	u32 k;
	SetSeed(19650218UL);
	i=1; j=0;
	k = (N>size ? N : size);
	for (; k; k--) {
		m_mt[i] = (m_mt[i] ^ ((m_mt[i-1] ^ (m_mt[i-1] >> 30)) * 1664525UL))
		  + seed[j] + j; /* non linear */
		m_mt[i] &= 0xffffffffUL; /* for WORDSIZE > 32 machines */
		i++; j++;
		if (i>=N) { m_mt[0] = m_mt[N-1]; i=1; }
		if (j>=size) j=0;
	}
	for (k=N-1; k; k--) {
		m_mt[i] = (m_mt[i] ^ ((m_mt[i-1] ^ (m_mt[i-1] >> 30)) * 1566083941UL))
		  - i; /* non linear */
		m_mt[i] &= 0xffffffffUL; /* for WORDSIZE > 32 machines */
		i++;
		if (i>=N) { m_mt[0] = m_mt[N-1]; i=1; }
	}

	m_mt[0] = 0x80000000UL; /* MSB is 1; assuring non-zero initial array */ 
}

/**********************************************************************//**
 *
 * 32bit ̐
 *
*//***********************************************************************/
u32 CMT19937ar::GenRand32(void)
{
	u32 y;
	static u32 mag01[2]={0x0UL, MATRIX_A};
	/* mag01[x] = x * MATRIX_A	for x=0,1 */

	if (m_mti >= N) { /* generate N words at one time */
		int kk;

		if (m_mti == N+1)	/* if init_genrand() has not been called, */
			SetSeed(5489UL); /* a default initial seed is used */

		for (kk=0;kk<N-M;kk++) {
			y = (m_mt[kk]&UPPER_MASK)|(m_mt[kk+1]&LOWER_MASK);
			m_mt[kk] = m_mt[kk+M] ^ (y >> 1) ^ mag01[y & 0x1UL];
		}
		for (;kk<N-1;kk++) {
			y = (m_mt[kk]&UPPER_MASK)|(m_mt[kk+1]&LOWER_MASK);
			m_mt[kk] = m_mt[kk+(M-N)] ^ (y >> 1) ^ mag01[y & 0x1UL];
		}
		y = (m_mt[N-1]&UPPER_MASK)|(m_mt[0]&LOWER_MASK);
		m_mt[N-1] = m_mt[M-1] ^ (y >> 1) ^ mag01[y & 0x1UL];

		m_mti = 0;
	}
  
	y = m_mt[m_mti++];

	/* Tempering */
	y ^= (y >> 11);
	y ^= (y << 7) & 0x9d2c5680UL;
	y ^= (y << 15) & 0xefc60000UL;
	y ^= (y >> 18);
	return y;
}

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris

