//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndBase.h
 * @brief		NXC^[tFCX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_RndBase_H_
#define INCG_IRIS_RndBase_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// class
/// NXC^[tFCX
class IRand : public IIrisObject
{
protected:
	u32	m_Seed;	//!< 

public:
	/// 
	void	Initialize(void)			{ SetSeed(m_Seed); }
	/// 
	void	Initialize(u32 seed)		{ SetSeed(seed); }
public:
	/// ̐ݒ
	virtual	void	SetSeed(u32 seed)	{ m_Seed = seed; }
	/// ̎擾
			u32		GetSeed(void)		{ return m_Seed; }

	/// ̐ݒ
	virtual void	SetArraySeed(u32* seed, s32 size)	{ SetSeed(*seed); IRIS_UNUSED_VARIABLE(size); }

public:
	/// 32bit ̐
	virtual	u32		GenRand32(void)		= 0;

public:
	/**
	 * @brief 32bit Ŗ߂
	 * @param [out]	ary	= o̓obt@
	 * @param [in]	len	= o̓obt@
	*/
	void	FillRand32(u32* ary, u32 len)
	{
		for( u32 i=0; i < len; ++i )
			ary[i] = GenRand32();
	}
	/**
	 * @brief 31bit ̐
	*/
	s32		GenRand31(void)		{ return static_cast<s32>(GenRand32()>>1); }

	/**
	 * @brief	͈̗͂̎擾
	 * @param [in]	max	= ͈͏
	 * @return	32bit[0,max)
	*/
	u32		GenRange32(u32 max)	{ return GenRand32()%max; }

	/**
	 * @brief	̎擾
	 * @return	float[0,1]
	*/
	f32		GenFloat0_1(void)		{ return (f32)GenRand32()*(1.0f/4294967295.0f); }

	/**
	 * @brief	̎擾
	 * @return	float[0,1)
	*/
	f32		GenFloat0_x1(void)		{ u32 ret = (0x3f800000) | ((GenRand32()>>8) & 0x007FFFFF); return ((*(f32*)(&ret)) - 1.0f); }

	/**
	 * @brief	̎擾
	 * @return	float(0,1)
	*/
	f32		GenFloat0x_x1(void)		{ return ((f32)GenRand32()+0.5f)*(1.0f/4294967296.0f); }

	/**
	 * @brief	̎擾
	 * @return	double[0,1]
	*/
	f64		GenReal0_1(void)		{ return (f64)GenRand32()*(1.0/4294967295.0); }

	/**
	 * @brief	̎擾
	 * @return	double[0,1)
	*/
	f64		GenReal0_x1(void)		{ return (f64)GenRand32()*(1.0/4294967296.0); }

	/**
	 * @brief	̎擾
	 * @return	double(0,1)
	*/
	f64		GenReal0x_x1(void)		{ return ((f64)GenRand32()+0.5)*(1.0/4294967296.0); }
};

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris


#endif
