//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndBBShub.cpp
 * @brief		blum-blum-shubt@C
 * @note		Í_IɈSȗ̐܂B
 *				ʏ̗ƂẮAd炵
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_RndBBShub_CPP_

#define __STDC_CONSTANT_MACROS

//======================================================================
// include
#include "RndBBShub.h"
#include "../../iris_debug.h"
#include "../../iris_inttypes.h"

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// define
// f(mod 4  3gcd(p-1,q-1)ق]܂)
#define FIRST_P U64_C(0x00ffffef)
#define FIRST_Q	U64_C(0x00e1e20f)

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CBBShubRand::CBBShubRand(void)
: m_m(FIRST_P*FIRST_Q)
{
	SetSeed(19860309);
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	seed	= 
*//***********************************************************************/
void CBBShubRand::SetSeed(u32 seed)
{
	IRand::SetSeed(seed);
	m_v = seed;
}

/**********************************************************************//**
 *
 * 32bit ̐
 *
*//***********************************************************************/
u32 CBBShubRand::GenRand32(void)
{
	u64 tmp = m_v * m_v;
	m_v = tmp % m_m;
	IRIS_ASSERT( m_v != 0 ); 
	return (u32)(m_v&0xFFFFFFFF);
}

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris

