//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathSHACommon.h
 * @brief		SHAt@Cʏt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathSHACommon_H_
#define INCG_IRIS_MathSHACommon_H_

//======================================================================
// include
#include "../../iris_inchead.h"
#include <stdio.h>

namespace iris {
namespace math
{

//======================================================================
// function

/**
 * @brief SHAnbVl當ϊ
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpSHA		= ̓obt@
 * @param [in]	uHashSize	= ̓obt@TCY
*/
STATICINLINE  LPSTR	SHAToStringA(LPSTR  lpString, size_t uSize, const u8* lpSHA, u32 uHashSize)
{
	if( lpString == nullptr ) return nullptr;
	if( lpSHA == nullptr ) return nullptr;
	const u8* src = lpSHA;
	LPSTR dst = lpString;
	for( u32 i=0, j=0; i < uHashSize; ++i, j+=2, dst+=2)
	{
		sprintf_s(dst, uSize-j, "%.2x", *src++);
	}
	return lpString;
}
STATICINLINE  LPWSTR	SHAToStringW(LPWSTR lpString, size_t uSize, const u8* lpSHA, u32 uHashSize)
{
	if( lpString == nullptr ) return nullptr;
	if( lpSHA == nullptr ) return nullptr;
	const u8* src = lpSHA;
	LPWSTR dst = lpString;
	for( u32 i=0, j=0; i < uHashSize; ++i, j+=2, dst+=2)
	{
		swprintf_s(dst, uSize-j, L"%.2x", *src++);
	}
	return lpString;
}
STATICINLINE  LPTSTR	SHAToString (LPTSTR lpString, size_t uSize, const u8* lpSHA, u32 uHashSize)
{
#ifdef UNICODE
	return SHAToStringW(lpString, uSize, lpSHA, uHashSize);
#else
	return SHAToStringA(lpString, uSize, lpSHA, uHashSize);
#endif
}

#ifdef INCG_IRIS_MathSHAPrivate_CPP_

//======================================================================
// define
// Vbt
#if 0
// RFC
#define _SHA_Ch(x, y, z)	(((x) & (y)) | (~(x) & (z)))
#define _SHA_Maj(x, y, z)	(((x) & (y)) | ((x) & (z)) | ((y) & (z)))
#else
// MODIFEID
#define _SHA_Ch(x, y, z)	(((x) & ((y) ^ (z))) ^ (z))
#define _SHA_Maj(x, y, z)	(((x) & ((y) | (z))) | ((y) & (z)))
#endif

//======================================================================
// function
/**
 * @private
 * @brief	32bitobt@->8bitobt@ϊ
*/
STATICINLINE void _SHAEncode32(u8* lpDst, const u32* lpSrc, size_t uLength)
{
#ifndef __BIG_ENDIAN__
	for( size_t i=0; i < uLength; i+=4, ++lpSrc )
	{
		*(lpDst++) = static_cast<u8>((*lpSrc >> 24) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc >> 16) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc >>  8) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc      ) & 0xFF);
	}
#else
	memcpy(lpDst, lpSrc, uLength);
#endif
}

/**
 * @private
 * @brief	64bitobt@->8bitobt@ϊ
*/
STATICINLINE void _SHAEncode64(u8* lpDst, const u64* lpSrc, size_t uLength)
{
#ifndef __BIG_ENDIAN__
	for( size_t i=0; i < uLength; i+=8, ++lpSrc )
	{
		*(lpDst++) = static_cast<u8>((*lpSrc >> 56) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc >> 48) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc >> 40) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc >> 32) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc >> 24) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc >> 16) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc >>  8) & 0xFF);
		*(lpDst++) = static_cast<u8>((*lpSrc      ) & 0xFF);
	}
#else
	memcpy(lpDst, lpSrc, uLength);
#endif
}

#endif

}	// end of namespace math
}	// end of namespace iris

#endif
