//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathSHA384.h
 * @brief		SHA384 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathSHA384_H_
#define INCG_IRIS_MathSHA384_H_

//======================================================================
// include
#include "MathSHA512.h"

namespace iris {
namespace math
{

//======================================================================
// define
//! SHA384nbVTCY
#define SHA384_HASHSIZE_IN		SHA512_HASHSIZE_IN
//! SHA384nbVTCY
#define SHA384_HASHSIZE			48
//! SHA512bZ[Wobt@TCY
#define SHA384_LENGTHBUFSIZE	SHA512_LENGTHBUFSIZE
//! SHA384bZ[WubNTCY
#define SHA384_MSGBLKSIZE		SHA512_MSGBLKSIZE

//======================================================================
// struct
typedef SHA512CONTEXT		SHA384CONTEXT;		//!< SHA384pReLXg
typedef LPSHA512CONTEXT		LPSHA384CONTEXT;	//!< SHA384pReLXg|C^[^
typedef LPCSHA512CONTEXT	LPCSHA384CONTEXT;	//!< SHA384pReLXg|C^[^

//! SHA384nbVo͌^
typedef struct tagSHA384DIGEST
{
	u8	hash[SHA384_HASHSIZE];		//!< obt@
} SHA384DIGEST, LPSHA384DIGEST;	//!< SHA384nbVo͌^

//======================================================================
// function
// SHA384pReLXg̏
void	SHA384InitContext(LPSHA384CONTEXT lpContext);
// SHA384pReLXg̃NA
void	SHA384ClearContext(LPSHA384CONTEXT lpContext);
// SHA384o
void	SHA384Output(LPCSHA384CONTEXT lpContext, u8* lpBuffer);
// SHA384܂Ƃ߂ČvZ
void	SHA384Encode(LPSHA384CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
// SHA384܂Ƃ߂ČvZ
void	SHA384Encode(u8* lpDst, const u8* lpBuffer, size_t uLength);
// SHA384o͒l𕶎ɕϊ
LPTSTR	SHA384ToString (LPTSTR lpString, size_t uSize, const u8* lpSHA384);
LPSTR	SHA384ToStringA(LPSTR  lpString, size_t uSize, const u8* lpSHA384);
LPWSTR	SHA384ToStringW(LPWSTR lpString, size_t uSize, const u8* lpSHA384);

/**
 * @brief	SHA384vZ
 * @note	iris::math::SHA512Update
*/
STATICINLINE	void	SHA384Update(LPSHA384CONTEXT lpContext, const u8* lpBuffer, size_t uLength)
{
	SHA512Update(lpContext, lpBuffer, uLength);
}
/**
 * @brief	ŏIISHA384vZ
 * @note	iris::math::SHA512Final
*/
STATICINLINE	void	SHA384Final(LPSHA384CONTEXT lpContext)
{
	SHA512Final(lpContext);
}


// template
/**
 * @brief	SHA384vZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA384Update(LPSHA384CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA384Update(lpContext, reinterpret_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA384܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA384Encode(LPSHA384CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA384Encode(lpContext, reinterpret_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA384܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA384Encode(u8* lpDst, const _TN* lpBuffer, size_t uLength)
{
	SHA384Encode(lpDst, reinterpret_cast<const u8*>(lpBuffer), uLength);
}

}	// end of namespace math
}	// end of namespace iris

#endif
