//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathSHA384.cpp
 * @brief		SHA384 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathSHA384_CPP_
#define INCG_IRIS_MathSHAPrivate_CPP_	// private֐gp

//======================================================================
// include
#include "MathSHA384.h"
#include "MathSHACommon.h"
#include "../../iris_debug.h"

namespace iris {
namespace math
{

//======================================================================
// define
#ifdef _IRIS_NOT_SUPPORT_LLONG
#define _SHA384Encode	_SHAEncode32
#else
#define _SHA384Encode	_SHAEncode64
#endif

//======================================================================
// function
/**********************************************************************//**
 *
 * SHA384pReLXg̏
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @return	
*//***********************************************************************/
void	SHA384InitContext(LPSHA384CONTEXT lpContext)
{
	IRIS_ASSERT( lpContext != nullptr );
	lpContext->uIndex = 0;
#ifdef _IRIS_NOT_SUPPORT_LLONG
	lpContext->uCount[0] = lpContext->uCount[1] = 
		lpContext->uCount[2] = lpContext->uCount[3] = 0;
	lpContext->uState[ 0] = 0xCBBB9D5D;
	lpContext->uState[ 1] = 0xC1059ED8;
	lpContext->uState[ 2] = 0x629A292A;
	lpContext->uState[ 3] = 0x367CD507;
	lpContext->uState[ 4] = 0x9159015A;
	lpContext->uState[ 5] = 0x3070DD17;
	lpContext->uState[ 6] = 0x152FECD8;
	lpContext->uState[ 7] = 0xF70E5939;
	lpContext->uState[ 8] = 0x67332667;
	lpContext->uState[ 9] = 0xFFC00B31;
	lpContext->uState[10] = 0x8EB44A87;
	lpContext->uState[11] = 0x68581511;
	lpContext->uState[12] = 0xDB0C2E0D;
	lpContext->uState[13] = 0x64F98FA7;
	lpContext->uState[14] = 0x47B5481D;
	lpContext->uState[15] = 0xBEFA4FA4;
#else
	lpContext->uCount[0] = lpContext->uCount[1] = 0;
	lpContext->uState[ 0] = 0xCBBB9D5DC1059ED8ll;
	lpContext->uState[ 1] = 0x629A292A367CD507ll;
	lpContext->uState[ 2] = 0x9159015A3070DD17ll;
	lpContext->uState[ 3] = 0x152FECD8F70E5939ll;
	lpContext->uState[ 4] = 0x67332667FFC00B31ll;
	lpContext->uState[ 5] = 0x8EB44A8768581511ll;
	lpContext->uState[ 6] = 0xDB0C2E0D64F98FA7ll;
	lpContext->uState[ 7] = 0x47B5481DBEFA4FA4ll;
#endif
	//ZeroMemory(lpContext->uBuffer, sizeof(lpContext->uBuffer));
}

/**********************************************************************//**
 *
 * SHA384pReLXg̃NA
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @return	
*//***********************************************************************/
void	SHA384ClearContext(LPSHA384CONTEXT lpContext)
{
	IRIS_ASSERT( lpContext != nullptr );
	SHA384InitContext(lpContext);
	ZeroMemory(lpContext->uBuffer, sizeof(lpContext->uBuffer));
}

/**********************************************************************//**
 *
 * SHA384o
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void	SHA384Output(LPCSHA384CONTEXT lpContext, u8* lpBuffer)
{
	_SHA384Encode(lpBuffer, lpContext->uState, SHA384_HASHSIZE);
}

/**********************************************************************//**
 *
 * SHA384܂Ƃ߂ČvZ(Init ` Final)
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@TCY
*//***********************************************************************/
void	SHA384Encode(LPSHA384CONTEXT lpContext, const u8* lpBuffer, size_t uLength)
{
	SHA384InitContext(lpContext);
	SHA384Update(lpContext, lpBuffer, uLength);
	SHA384Final(lpContext);
}

/**********************************************************************//**
 *
 * SHA384܂Ƃ߂ČvZ(Init ` Output)
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@TCY
*//***********************************************************************/
void	SHA384Encode(u8* lpDst, const u8* lpBuffer, size_t uLength)
{
	SHA384CONTEXT ctx;
	SHA384InitContext(&ctx);
	SHA384Update(&ctx, lpBuffer, uLength);
	SHA384Final(&ctx);
	SHA384Output(&ctx, lpDst);
}

/**********************************************************************//**
 *
 * SHA384o͒l𕶎ɕϊ
 * 
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpSHA384	= ̓obt@(SHA384)
*//***********************************************************************/
LPTSTR	SHA384ToString (LPTSTR lpString, size_t uSize, const u8* lpSHA384)
{
	return SHAToString(lpString, uSize, lpSHA384, SHA384_HASHSIZE);
}
LPSTR	SHA384ToStringA(LPSTR lpString, size_t uSize, const u8* lpSHA384)
{
	return SHAToStringA(lpString,  uSize, lpSHA384, SHA384_HASHSIZE);
}
LPWSTR	SHA384ToStringW(LPWSTR lpString, size_t uSize, const u8* lpSHA384)
{
	return SHAToStringW(lpString, uSize, lpSHA384, SHA384_HASHSIZE);
}

}	// end of namespace math
}	// end of namespace iris


#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/gt/gt_inchead.h"
#include "../../iris_using.h"

TEST(CMathSHA384Test, Function)
{
	char comm[256] = "";
	u8 out[SHA384_HASHSIZE];

	SHA384CONTEXT ctx;

	// TEST1
	strcpy_s(comm, 256, "abc");
	SHA384Encode(out, comm, strlen(comm));
	SHA384ToStringA(comm, 256, out);
	ASSERT_STREQ(
		"cb00753f45a35e8bb5a03d699ac65007272c32ab0eded163"
        "1a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7"
		, comm );

	// TEST2
	strcpy_s(comm, 256, "abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmn"
		"hijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu");
	SHA384Encode(out, comm, strlen(comm));
	SHA384ToStringA(comm, 256, out);
	ASSERT_STREQ(
        "09330c33f71147e83d192fc782cd1b4753111b173b3b05d2"
        "2fa08086e3b0f712fcc7c71a557e2db966c3e9fa91746039"
		, comm );

	// TEST3
	strcpy_s(comm, 256, "a");
	SHA384InitContext(&ctx);
	for( int i=0; i < 1000000; ++i )
		SHA384Update(&ctx, comm, strlen(comm));
	SHA384Final(&ctx);
	SHA384Output(&ctx, out);
	SHA384ToStringA(comm, 256, out);
	ASSERT_STREQ(
		"9d0e1809716474cb086e834e310a4a1ced149e9c00f24852"
        "7972cec5704c2a5b07b8b3dc38ecc4ebae97ddd87f3d8985"
		, comm );

	// TEST4
	strcpy_s(comm, 256, "01234567012345670123456701234567""01234567012345670123456701234567");
	SHA384InitContext(&ctx);
	for( int i=0; i < 10; ++i )
		SHA384Update(&ctx, comm, strlen(comm));
	SHA384Final(&ctx);
	SHA384Output(&ctx, out);
	SHA384ToStringA(comm, 256, out);
	ASSERT_STREQ(
		"2fc64a4f500ddb6828f6a3430b8dd72a368eb7f3a8322a70"
        "bc84275b9c0b3ab00d27a5cc3c2d224aa6b61a0d79fb4596"
		, comm );
}

#endif

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CMathSHA384UnitTest, MathSHA384UnitTest)
{
	char comm[256] = "";
	u8 out[SHA384_HASHSIZE];

	std::clog << "SHA384GR[h܂B" << std::endl;
	std::safe_cin >> comm;

	SHA384Encode(out, comm, strlen(comm));

	for( int i=0; i < SHA384_HASHSIZE; ++i )
		printf("%.2x", out[i]);
	std::cout << std::endl;
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

