//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPerspective.inl
 * @brief		t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPerspective_inl_
#define INCG_IRIS_MathPerspective_inl_

namespace iris {
namespace math
{

//======================================================================
// function
/**
 * @brief	_}gbNX̐
 * @param [out]	pm0			= o̓}gbNX
 * @param [in]	pvEye		= _ʒu
 * @param [in]	pvLookAt	= _̈ʒu
 * @param [in]	pvUp		= xNg
 * @return	o̓}gbNX
*/
IRIS_FPU_INLINE	IrisFMtx44*	FpuLookAtMatrix(IrisFMtx44* pm0, const IrisFVec4* pvEye, const IrisFVec4* pvLookAt, const IrisFVec4* pvUp)
{
	MATH_FPU_NULLASSERT( pm0 );
	IrisFVec4 vx, vy, vz, vtmp;
	FpuVec4Sub(&vz, pvEye, pvLookAt);
	FpuVec4NormalizeXYZ(&vz, &vz);
	FpuVec4OuterProductXYZ(&vx, pvUp, &vz);
	FpuVec4OuterProductXYZ(&vy, &vz, &vx);
	FpuVec4NormalizeXYZ(&vx, &vx);
	FpuVec4NormalizeXYZ(&vy, &vy);

	pm0->x.x = vx.x;
	pm0->x.y = vx.x;
	pm0->x.z = vx.x;
	pm0->x.w = 0.0f;
	pm0->y.x = vy.x;
	pm0->y.y = vy.x;
	pm0->y.z = vy.x;
	pm0->y.w = 0.0f;
	pm0->z.x = vz.x;
	pm0->z.y = vz.x;
	pm0->z.z = vz.x;
	pm0->z.w = 0.0f;
	pm0->w.x = pm0->w.y = pm0->w.z = 0.0f;
	pm0->w.w = 1.0f;

	FpuVec4Neg(&vtmp, pvEye);
	FpuMtx44TransformXYZ(&vtmp, pm0, &vtmp);
	vtmp.w =  1.0f;
	FpuMtx44Transfer(pm0, pm0, &vtmp);
	return pm0;
}

/**
 * @brief	ϊs̐
 * @param [out]	pm0			= o̓}gbNX
 * @param [in]	fovy		= J̉p(WA)
 * @param [in]	aspect		= ʂ̃AXyNg(c:/c)
 * @param [in]	r_near		= ʂ̑ONbv(_̋)
 * @param [in]	r_far		= ʂ̌Nbv(_̋)
 * @return	o̓}gbNX
*/
IRIS_FPU_INLINE	IrisFMtx44*	FpuPerspectiveMatrix(IrisFMtx44* pm0, f32 fovy, f32 aspect, f32 r_near, f32 r_far)
{
	MATH_FPU_NULLASSERT( pm0 );
	f32 f, asp, nf1, nf2;
	f = F32_Mul(fovy, 0.5f);
	f = F32_Div(F32_Cos(f), F32_Sin(f));

	asp = F32_Div(1.0f, aspect);
	nf1 = F32_Div(1.0f, (r_near - r_far));
	nf2 = r_near + r_far;
	pm0->x.x = F32_Mul(f, asp);
	pm0->x.y = 0.0f;
	pm0->x.z = 0.0f;
	pm0->x.w = 0.0f;
	pm0->y.x = 0.0f;
	pm0->y.y = f;
	pm0->y.z = 0.0f;
	pm0->y.w = 0.0f;
	pm0->z.x = 0.0f;
	pm0->z.y = 0.0f;
	pm0->z.z = F32_Mul(nf1, nf2);
	pm0->z.w = -1.0f;
	pm0->w.x = 0.0f;
	pm0->w.y = 0.0f;
	pm0->w.z = F32_Mul( F32_Mul(r_near, r_far), nf1) * 2;
	pm0->w.w = 0.0f;
	return pm0;
}

/**
 * @brief	ˉes̐
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	left	= ̐ς̍W
 * @param [in]	top		= ̐ς̏W
 * @param [in]	right	= ̐ς̉EW
 * @param [in]	bottom	= ̐ς̉W
 * @param [in]	r_near	= ̐ς̎OW
 * @param [in]	r_far	= ̐ς̉W
 * @return	o̓}gbNX
*/
IRIS_FPU_INLINE	IrisFMtx44*	FpuOrthoMatrix(IrisFMtx44* pm0, f32 left, f32 top, f32 right, f32 bottom, f32 r_near, f32 r_far)
{
	MATH_FPU_NULLASSERT( pm0 );
	f32	rl1, rl2;
	f32	tb1, tb2;
	f32	fn1, fn2;

	rl1 = F32_Div(1.0f, (right - left));
	rl2 = right + left;
	tb1 = F32_Div(1.0f, (top - bottom));
	tb2 = top + bottom;
	fn1 = F32_Div(1.0f, (r_far - r_near));
	fn2 = r_far + r_near;

	pm0->x.x = F32_Mul(2.0f, rl1);
	pm0->x.y = 0.0f;
	pm0->x.z = 0.0f;
	pm0->x.w = 0.0f;
	pm0->y.x = 0.0f;
	pm0->y.y = F32_Mul(2.0f, tb1);
	pm0->y.z = 0.0f;
	pm0->y.w = 0.0f;
	pm0->z.x = 0.0f;
	pm0->z.y = 0.0f;
	pm0->z.z = F32_Mul(-2.0f, fn1);
	pm0->z.w = 0.0f;
	pm0->w.x = F32_Mul(F32_Mul(-1.0f, rl2), rl1);
	pm0->w.y = F32_Mul(F32_Mul(-1.0f, tb2), tb1);
	pm0->w.z = F32_Mul(F32_Mul(-1.0f, fn2), fn1);
	pm0->w.w = 1.0f;
	return pm0;
}

/**
 * @brief	ˉes̐
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	left	= ̐ς̍W
 * @param [in]	top		= ̐ς̏W
 * @param [in]	right	= ̐ς̉EW
 * @param [in]	bottom	= ̐ς̉W
 * @param [in]	r_near	= ̐ς̎OW
 * @param [in]	r_far	= ̐ς̉W
 * @return	o̓}gbNX
*/
IRIS_FPU_INLINE	IrisFMtx44*	FpuFrustumMatrix(IrisFMtx44* pm0, f32 left, f32 top, f32 right, f32 bottom, f32 r_near, f32 r_far)
{
	MATH_FPU_NULLASSERT( pm0 );
	pm0->x.x =  F32_Div( F32_Mul(2.0f, r_near),  (right - left) );
	pm0->x.y =  0.0f;
	pm0->x.z =  0.0f;
	pm0->x.w =  0.0f;
	pm0->y.x =  0.0f;
	pm0->y.y =  F32_Div( F32_Mul(2.0f, r_near), (top - bottom) );
	pm0->y.z =  0.0f;
	pm0->y.w =  0.0f;
	pm0->z.x =  F32_Div((right + left)	, (right - left));
	pm0->z.y =  F32_Div((top   + bottom)	, (top   - bottom));
	pm0->z.z = -F32_Div((r_far + r_near)	, (r_far - r_near));
	pm0->z.w = -1.0f;
	pm0->w.x =  0.0f;
	pm0->w.y =  0.0f;
	pm0->w.z = -F32_Div( F32_Mul( F32_Mul(2.0f, r_far), r_near), (r_far - r_near) );
	pm0->w.w =  0.0f;
	return pm0;
}

/**
 * @brief	[hr[s̐
 * @note	_pv(0,0,0)ɁApzd(0,0,1)ɁApyd(0,1,0)ɂƕϊ悤ȍs߁Apm0ɕԂ܂B
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	pv		= ̐ς̍W
 * @param [in]	pzd		= _}gbNX
 * @param [in]	pyd		= }gbNX
 * @param [in]	bottom	= 
 * @return	o̓}gbNX
*/
IRIS_FPU_INLINE	IrisFMtx44*	FpuCameraMatrix(IrisFMtx44* pm0, const IrisFVec4* pv, const IrisFVec4* pzd, const IrisFVec4* pyd)
{
	MATH_FPU_NULLASSERT( pm0 );
	MATH_FPU_NULLASSERT( pv );
	MATH_FPU_NULLASSERT( pzd );
	MATH_FPU_NULLASSERT( pyd );
	IrisFMtx44 fm;
	IrisFVec4 xd;
	FpuMtx44Unit(&fm);
	FpuVec4OuterProductXYZ(&xd, pyd, pzd);
	FpuVec4NormalizeXYZ(&fm.x, &xd);
	FpuVec4NormalizeXYZ(&fm.z, pzd);
	FpuVec4OuterProductXYZ(&fm.y, &fm.z, &fm.x);
	FpuMtx44Transfer(&fm, &fm, pv);
	FpuMtx44Inverse(pm0, &fm);
	return pm0;
}

/**
 * @brief	r[XN[s̐
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	scrz	= XN[܂ł̋
 * @param [in]	ax		= XAXyNg
 * @param [in]	ay		= YAXyNg
 * @param [in]	cx		= XN[̒SXW
 * @param [in]	cy		= XN[̒SYW
 * @param [in]	zmin	= Zobt@ŏl
 * @param [in]	zmax	= Zobt@ől
 * @param [in]	nearz	= jANbvʂZ
 * @param [in]	farz	= t@[NbvʂZ
 * @return	o̓}gbNX
*/
IRIS_FPU_INLINE	IrisFMtx44*	FpuViewScreenMatrix(IrisFMtx44* pm0, f32 scrz, f32 ax, f32 ay, f32 cx, f32 cy
													, f32 zmin, f32 zmax, f32 nearz, f32 farz)
{
	MATH_FPU_NULLASSERT( pm0 );
	IrisFMtx44 mt;
	f32 cz = F32_Div( ( F32_Mul(-zmax, nearz) + F32_Mul(zmin, farz) ), (-nearz + farz));
	f32 az = F32_Div( F32_Mul( F32_Mul(farz, nearz), (-zmin + zmax) ), (-nearz + farz));
	FpuMtx44Unit(pm0);
	pm0->x.x = scrz;
	pm0->y.y = scrz;
	pm0->z.z = 0.0f;
	pm0->w.w = 0.0f;
	pm0->w.z = 1.0f;
	pm0->z.w = 1.0f;

	FpuMtx44Unit(&mt);
	mt.x.x = ax;
	mt.y.y = ay;
	mt.z.z = az;
	mt.w.x = cx;
	mt.w.y = cy;
	mt.w.z = cz;

	FpuMtx44Mul(pm0, &mt, pm0);
	return pm0;
}

/**
 * @brief	hbvVhEˉes̐
 * @param [out]	pm0		= o̓}gbNX
 * @param [in]	lp		= ̈ʒu
 * @param [in]	a		= e̓e
 * @param [in]	b		= e̓e
 * @param [in]	c		= e̓e
 * @param [in]	mode	= ̎(0: s 1: _)
 * @return	o̓}gbNX
*/
IRIS_FPU_INLINE	IrisFMtx44*	FpuDropShadowMatrix(IrisFMtx44* pm0, const IrisFVec4* lp, f32 a, f32 b, f32 c, int mode)
{
	MATH_FPU_NULLASSERT( pm0 );
	MATH_FPU_NULLASSERT( lp );
	if( mode )
	{
		// spot light
		f32 x = lp->x, y = lp->y, z = lp->z;
		f32 d = 1.0f - (F32_Mul(a, x) + F32_Mul(b, y) + F32_Mul(c, z));

		pm0->x.x = F32_Mul(a, x)+d;
		pm0->y.x = F32_Mul(b, x);
		pm0->z.x = F32_Mul(c, x);
		pm0->w.x = -x;
		pm0->x.y = F32_Mul(a, y);
		pm0->y.y = F32_Mul(b, y)+d;
		pm0->z.y = F32_Mul(c, y);
		pm0->w.y = -y;
		pm0->x.z = F32_Mul(a, z);
		pm0->y.z = F32_Mul(b, z);
		pm0->z.z = F32_Mul(c, z)+d;
		pm0->w.z = -z;
		pm0->x.w = a;
		pm0->y.w = b;
		pm0->z.w = c;
		pm0->w.w = d - 1.0f;
	}
	else
	{
		// parallel light
		f32 p  = lp->x, q = lp->y, r = lp->z;
		f32 n  = F32_Mul(a, p) + F32_Mul(b, q) + F32_Mul(c, r);
		f32 nr = F32_Div(-1.0f, n);

		pm0->x.x = F32_Mul(nr, F32_Mul(a, p)-n);
		pm0->y.x = F32_Mul(nr, F32_Mul(b, p));
		pm0->z.x = F32_Mul(nr, F32_Mul(c, p));
		pm0->w.x = F32_Mul(nr, (-p));
		pm0->x.y = F32_Mul(nr, F32_Mul(a, q));
		pm0->y.y = F32_Mul(nr, F32_Mul(b, q)-n);
		pm0->z.y = F32_Mul(nr, F32_Mul(c, q));
		pm0->w.y = F32_Mul(nr, (-q));
		pm0->x.z = F32_Mul(nr, F32_Mul(a, r));
		pm0->y.z = F32_Mul(nr, F32_Mul(b, r));
		pm0->z.z = F32_Mul(nr, F32_Mul(c, r)-n);
		pm0->w.z = F32_Mul(nr, (-r));
		pm0->x.w = 0.0f;
		pm0->y.w = 0.0f;
		pm0->z.w = 0.0f;
		pm0->w.w = F32_Mul(nr, (-n));
	}
	return pm0;
}

/**
 * @brief	ϊ
 * @param [out]	pv0		= o̓xNg
 * @param [in]	pm0		= }gbNX
 * @param [in]	pv1		= 
 * @return	o̓xNg
*/
IRIS_FPU_INLINE	IrisFVec4*		FpuRotTransPers(IrisFVec4* pv0, const IrisFMtx44* pm0, const IrisFVec4* pv1)
{
	MATH_FPU_NULLASSERT( pm0 );
	MATH_FPU_NULLASSERT( pv0 );
	MATH_FPU_NULLASSERT( pv1 );
	f32 x, y, z, w, q;

	x = F32_Mul(pm0->x.x, pv1->x) + F32_Mul(pm0->y.x, pv1->y) + F32_Mul(pm0->z.x, pv1->z) + F32_Mul(pm0->w.x, pv1->w);
	y = F32_Mul(pm0->x.y, pv1->x) + F32_Mul(pm0->y.y, pv1->y) + F32_Mul(pm0->z.y, pv1->z) + F32_Mul(pm0->w.y, pv1->w);
	z = F32_Mul(pm0->x.z, pv1->x) + F32_Mul(pm0->y.z, pv1->y) + F32_Mul(pm0->z.z, pv1->z) + F32_Mul(pm0->w.z, pv1->w);
	w = F32_Mul(pm0->x.w, pv1->x) + F32_Mul(pm0->y.w, pv1->y) + F32_Mul(pm0->z.w, pv1->z) + F32_Mul(pm0->w.w, pv1->w);
	q = F32_Div(1.0f, w);

	pv0->x = F32_Mul(x, q);
	pv0->y = F32_Mul(y, q);
	pv0->z = F32_Mul(z, q);
	pv0->w = q;
	return pv0;
}

/**
 * @brief	^ꂽn̒_XN[Wɓϊ
 * @param [out]	pXyz	= o̓obt@
 * @param [in]	pitch	= o̓obt@sb`
 * @param [in]	pm0		= }gbNX
 * @param [in]	pv0		= _z
 * @param [in]	n		= _zTCY
*/
IRIS_FPU_INLINE	int				FpuRotTransPersN(short* pXyz, int pitch, const IrisFMtx44* pm0, const IrisFVec4* pv0, int n)
{
	MATH_FPU_NULLASSERT( pXyz );
	MATH_FPU_NULLASSERT( pm0 );
	MATH_FPU_NULLASSERT( pv0 );
	for( int i=0; i < n; ++i )
	{
		f32 x, y, z, w, q;
		x = F32_Mul(pm0->x.x, pv0[i].x) + F32_Mul(pm0->y.x, pv0[i].y) + F32_Mul(pm0->z.x, pv0[i].z) + F32_Mul(pm0->w.x, pv0[i].w);
		y = F32_Mul(pm0->x.y, pv0[i].x) + F32_Mul(pm0->y.y, pv0[i].y) + F32_Mul(pm0->z.y, pv0[i].z) + F32_Mul(pm0->w.y, pv0[i].w);
		z = F32_Mul(pm0->x.z, pv0[i].x) + F32_Mul(pm0->y.z, pv0[i].y) + F32_Mul(pm0->z.z, pv0[i].z) + F32_Mul(pm0->w.z, pv0[i].w);
		w = F32_Mul(pm0->x.w, pv0[i].x) + F32_Mul(pm0->y.w, pv0[i].y) + F32_Mul(pm0->z.w, pv0[i].z) + F32_Mul(pm0->w.w, pv0[i].w);
		q = F32_Div(1.0f, w);

		pXyz[0] = (short)( F32_Mul(x, q) );
		pXyz[1] = (short)( F32_Mul(y, q) );
		pXyz[2] = (short)( F32_Mul(z, q) );
		pXyz = (short*)(void*)((char*)pXyz + pitch);
	}
	return 0;
}

}	// end of namespace math
}	// end of namespace iris

#endif
