//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathGalois.cpp
 * @brief		KÃNXeXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathGalois_CPP_

//======================================================================
// include
#include "MathGalois.h"

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CMathGaloisUnitTest, MathGaloisUnitTest)
{
	typedef CGF2N<32, u32> CGF32;
	typedef CGF2NTable<4, u8> CGFT;
	// table
	{
		CGFT gf;

		u32 idx=0;
		for( s32 i=0; i < (CGFT::ELEMENTS+7)/8; ++i )
		{
			for( s32 j=0; j < 8 && idx < CGFT::ELEMENTS; ++j, ++idx )
			{
				u32 g = static_cast<u32>(gf[idx]);
				std::clog << std::hex << std::setw(2) << g << " ";
			}
			std::clog << std::endl;
		}
	}

	//{
	//	u32 prim;
	//	std::clog << "32bit̃KÂo͂܂" << std::endl;
	//	std::clog << "͂ĂB" << std::endl;
	//	std::safe_cin >> prim;
	//}
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

