//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathBezierCurve.h
 * @brief		xWGȐt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathBezierCurve_H_
#define INCG_IRIS_MathBezierCurve_H_

//======================================================================
// include
#include "../../iris_inchead.h"

namespace iris {
namespace math
{

//======================================================================
// function
// xWGȐ
f32	BezierCurve(f32 t, s32 n, ...);
// xWGȐ
f32	BezierCurveArray(f32 t, s32 n, f32 pt[]);

// NxNg̃xWGȐ
f32*	BezierCurveN(f32* pV, s32 N, f32 t, s32 n, ...);
// NxNg̃xWGȐ
f32*	BezierCurveArrayN(f32* pV, s32 N, f32 t, s32 n, f32 pt[]);

}	// end of namespace math
}	// end of namespace iris

#endif
