//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPower.h
 * @brief		ׂt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPower_H_
#define INCG_IRIS_MathPower_H_

//======================================================================
// include
#include "../iris_math.h"

namespace iris {
namespace math
{

//======================================================================
// declare
// _TN1ׂ̂]
template<typename _TN1, typename _TN2, typename _TN3>
_TN1	mod_pow(const _TN1& a, const _TN2& n, const _TN3& m);
// _TN1ׂ̂
template<typename _TN1, typename _TN2>
_TN1	bin_pow(const _TN1& a, const _TN2& n);
// xf32ׂ̂
xf32	XF_Pow(xf32 a, s32 n);

//======================================================================
// function
/**********************************************************************//**
 * @brief ׂ]
*//***********************************************************************/
template<typename _TN1, typename _TN2>
_TN1	mod_pow(const _TN1& a, const _TN1& n, const _TN1& m)
{
	_TN1 ret = 1;
	_TN1 e = n;
	_TN2 p = a;
	while(e > 0)
	{
		if( (e & 1) == 1 ) ret = (_TN1)((p * ret) % m);
		e >>= 1;
		p = (p * p) % m;
	}
	return ret;
}

/**********************************************************************//**
 * @brief ׂ
 * oCi@ɂׂ
*//***********************************************************************/
template<typename _TN1, typename _TN2>
_TN1	bin_pow(const _TN1& a, const _TN2& n)
{
	_TN2 tmp = 0;
	_TN1 ret = 1;
	_TN1 p   = a;
	if( a < 2 ) return a;
	_TN2 bit = 1;
	while(tmp != n)
	{
		if( (bit & n) != 0 )
		{
			tmp |= bit;
			ret *= p;
		}
		p *= p;
		bit <<= 1;
	}
	return ret;
}

}	// end of namespace math
}	// end of namespace iris

#endif
