//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_variant.h
 * @brief		oAg^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 * 
 * @deprecated	VARIANT Wł͂ȂĤňړ\
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_variant_H_
#define INCG_IRIS_iris_variant_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris
{

//======================================================================
// class
class CVariant : public IIrisObject
{
private:
	VARIANT m_Var;	//!< oAg^

public:
	/// oAgێ^
	template<VARTYPE _Type>class Type
	{
		template<VARTYPE _TT>struct _type_impl		{ typedef void			type; };
		struct _type_impl : _type_impl<VT_I2>		{ typedef IrisS16		type; };
		struct _type_impl : _type_impl<VT_I4>		{ typedef IrisS32		type; };
		struct _type_impl : _type_impl<VT_R4>		{ typedef IrisF32		type; };
		struct _type_impl : _type_impl<VT_R8>		{ typedef IrisF64		type; };
		struct _type_impl : _type_impl<VT_CY>		{ typedef CY			type; };
		struct _type_impl : _type_impl<VT_BSTR>		{ typedef BSTR			type; };
		struct _type_impl : _type_impl<VT_DISPATCH>	{ typedef IDispatch		*type; };
		struct _type_impl : _type_impl<VT_BOOL>		{ typedef bool			type; };
		struct _type_impl : _type_impl<VT_VARIANT>	{ typedef CVariant		*type; };
		struct _type_impl : _type_impl<VT_UNKNOWN>	{ typedef IUnknown		*type; };
		struct _type_impl : _type_impl<VT_I1>		{ typedef IrisS8		type; };
		struct _type_impl : _type_impl<VT_UI1>		{ typedef IrisU8		type; };
		struct _type_impl : _type_impl<VT_UI2>		{ typedef IrisU16		type; };
		struct _type_impl : _type_impl<VT_UI4>		{ typedef IrisU32		type; };
		struct _type_impl : _type_impl<VT_I8>		{ typedef IrisS64		type; };
		struct _type_impl : _type_impl<VT_UI8>		{ typedef IrisU64		type; };
		struct _type_impl : _type_impl<VT_INT>		{ typedef IrisInt		type; };
		struct _type_impl : _type_impl<VT_UINT>		{ typedef IrisUInt		type; };
		struct _type_impl : _type_impl<VT_DECIMAL>	{ typedef DECIMAL		*type; };
		struct _type_impl : _type_impl<VT_ARRAY>	{ typedef SAFEARRAY		*type; };
		struct _type_impl : _type_impl<VT_VOID>		{ typedef void			type; };
		struct _type_impl : _type_impl<VT_PTR>		{ typedef void			*type; };
	};
	/// oAg^Cv
	template<typename _TN>class VT
	{
		template<typename _TT>struct _vt_impl
		{ 
			enum { value = VT_EMPTY };
		};
		struct _vt_impl : _vt_impl<signed short>		{ enum { value = VT_I2 }; };
		struct _vt_impl : _vt_impl<signed long>			{ enum { value = VT_I4 }; };
		struct _vt_impl : _vt_impl<float>				{ enum { value = VT_R4 }; };
		struct _vt_impl : _vt_impl<double>				{ enum { value = VT_R8 }; };
		struct _vt_impl : _vt_impl<CY>					{ enum { value = VT_CY }; };
		struct _vt_impl : _vt_impl<BSTR>				{ enum { value = VT_BSTR }; };
		//struct _vt_impl : _vt_impl<DATE>				{ enum { value = VT_DATE }; };
		struct _vt_impl : _vt_impl<IDispatch*>			{ enum { value = VT_DISPATCH }; };
		struct _vt_impl : _vt_impl<bool>				{ enum { value = VT_BOOL }; };
		struct _vt_impl : _vt_impl<CVariant*>			{ enum { value = VT_VARIANT }; };
		struct _vt_impl : _vt_impl<IUnknown*>			{ enum { value = VT_UNKNOWN }; };
		struct _vt_impl : _vt_impl<signed char>			{ enum { value = VT_I1 }; };
		struct _vt_impl : _vt_impl<unsigned char>		{ enum { value = VT_UI1 }; };
		struct _vt_impl : _vt_impl<unsigned short>		{ enum { value = VT_UI2 }; };
		struct _vt_impl : _vt_impl<unsigned long>		{ enum { value = VT_UI4 }; };
		struct _vt_impl : _vt_impl<signed LONGLONG>		{ enum { value = VT_I8 }; };
		struct _vt_impl : _vt_impl<unsigned LONGLONG>	{ enum { value = VT_UI8 }; };
		struct _vt_impl : _vt_impl<signed int>			{ enum { value = VT_INT }; };
		struct _vt_impl : _vt_impl<unsigned int>		{ enum { value = VT_UINT }; };
		struct _vt_impl : _vt_impl<DECIMAL*>			{ enum { value = VT_DECIMAL }; };
		struct _vt_impl : _vt_impl<SAFEARRAY*>			{ enum { value = VT_ARRAY }; };
		//struct _vt_impl : _vt_impl<void*>				{ enum { value = VT_VOID }; };
		struct _vt_impl : _vt_impl<void*>				{ enum { value = VT_PTR }; };

		template<typename _TT>struct _vt_impl<_TT*>
		{ 
			enum { value = _vt_impl<_TT>::value | VT_BYREF };
		};
		
	public:
		enum { value = _vt_impl<_TN>::value };
	};

public:
	/**
	 * @brief	RXgN^
	*/
	CVariant(void)
	{
		VariantInit(&m_Var);
	}
	/**
	 * @brief	RXgN^
	 * @tparam [in]	_TN	= l^
	 * @param [in]	v = l
	*/
	template<typename _TN>
	CVariant(_TN v)
	{
		Set(v);
	}
	/**
	 * @brief	RXgN^
	 * @param [in]	var = CVariant
	*/
	CVariant(CVariant& var)
	{
		VariantCopy(&m_Var, &var.m_Var);
	}

	/**
	 * @brief	fXgN^
	*/
	~CVariant(void)
	{
		VariantClear(&m_Var);
	}

public:
	/**
	 * l̐ݒ
	 * @tparam [in]	_TN	= ^
	 * @param [in]	val = l
	*/
	template<typename _TN>
	void	Set(_TN val)
	{
		VariantInit(&m_Var);
		GetVariable<_TN>() = val;
		m_Var.vt = VT<_TN>::value;
	}

public:
	/**
	 * @brief	l̎擾
	 * @tparam [in]	_TN	= o͌^
	 * @return	l
	*/
	template<typename _TN>
	_TN		GetValue(void)
	{
		return (_TN)(m_Var.uiVal);
	}

	/**
	 * @brief	ϐ̎擾
	 * @tparam [in]	_TN	= ϐ̌^
	 * @return	ϐ̎Qƌ^
	*/
	template<typename _TN>
	_TN&		GetVariable(void)
	{
		return *(reinterpret_cast<_TN*>(&m_Var.dblVal));
	}

	/**
	 * @brief	oAg^Cv
	 * @return	oAg^Cv
	*/
	VARTYPE		GetVarType(void)
	{
		return m_Var.vt;
	}

public:
	template<typename _TN>
	void	operator = (const _TN& v)		{ Set(v); }
	template<typename _TN>
	operator _TN	(void)					{ return GetValue<_TN>(); }

#if	!defined(IRIS_WIN32_WCE)
	CVariant	operator + (CVariant& v)	{ CVariant ret; VarAdd(&m_Var, &v.m_Var, &ret.m_Var); return ret; }
	CVariant&	operator += (CVariant& v)	{ VarAdd(&m_Var, &v.m_Var, &m_Var); return *this; }
	CVariant	operator - (CVariant& v)	{ CVariant ret; VarSub(&m_Var, &v.m_Var, &ret.m_Var); return ret; }
	CVariant&	operator -= (CVariant& v)	{ VarSub(&m_Var, &v.m_Var, &m_Var); return *this; }
#endif

};

}	// end of namespace iris

#endif
