//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_stdc.h
 * @brief		iris CW֐T|[g t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_stdc_H_
#define INCG_IRIS_iris_stdc_H_

//======================================================================
// include
#include "iris_types.h"
#include "iris_macros.h"

//======================================================================
// function
#if	IRIS_MSC_AT_LESS(1400) || defined(IRIS_MWERKS)
#include <string.h>
#include <stdio.h>
#if	!IRIS_STDC_VA_ARGS
STATICINLINE	int		vsnprintf(char* dst, size_t size, const char* format, va_list va)
{
	if( (size_t)_vscprintf(format, va) >= size ) return -1;
	return vsprintf_s(dst, size, format, va);
}
#endif

#if		IRIS_WCS

#if	!IRIS_STDC_VA_ARGS
STATICINLINE	int		vsnwprintf(wchar_t* dst, size_t size, const wchar_t* format, va_list va)
{
	if( (size_t)_vscwprintf(format, va) >= size ) return -1;
	return vswprintf_s(dst, size, format, va);
}
#endif
#endif

#endif

#if	(IRIS_STDC_VERSION < IRIS_STDC_C99)

// ۂ
STATICINLINE	float	roundf(float fs)
{
	long bias = 0x3F000000 | ((*(long*)&fs) & 0x80000000);
	return (float)( (int32_t)( fs + *(float*)&bias ));
}

#endif

#endif
