//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_macros.h
 * @brief		}Nt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_macros_H_
#define INCG_IRIS_iris_macros_H_

//======================================================================
// include
#include "preprocessor/PPBitCalc.h"
#include "preprocessor/PPColor.h"
#include "preprocessor/PPEndian.h"
#include "preprocessor/PPString.h"
#include "preprocessor/PPUnit.h"
#include "preprocessor/PPWarning.h"
#include "preprocessor/program/PPClass.h"
#include "iris_pragma.h"

//======================================================================
// macros
//----------------------------------------
// }N
//#define IRIS_SAFE_DELETE(a)  		do { if(a) { delete (a); (a) = nullptr; } } while(0)
//#define IRIS_SAFE_DELETE_ARRAY(a)	do { if(a) { delete [] (a); (a) = nullptr; } } while(0)
#define IRIS_SAFE_DELETE(a)  		do { delete (a); (a) = nullptr; } while(0)
#define IRIS_SAFE_DELETE_ARRAY(a)	do { delete [] (a); (a) = nullptr; } while(0)
#define IRIS_SAFE_RELEASE(a)	 	do { if(a) { (a)->Release(); (a) = nullptr; } } while(0)

//----------------------------------------
// bool -> BOOL
#define IRIS_TO_BOOL(b)			((b) ? TRUE : FALSE)
// BOOL -> bool
#define IRIS_TO_bool(B)			((B) != FALSE)

#if	!defined(__cplusplus)
// max
#  ifndef	max
#    define max(a, b)	(((a) < (b)) ? (b) : (a))
#  endif
// min
#  ifndef	min
#    define min(a, b)	(((b) < (a)) ? (b) : (a))
#  endif
#endif

// ZeroMemory
#ifndef ZeroMemory
#  define ZeroMemory(Destination,Length)	memset((Destination),0,(Length))
#endif

#ifdef UNICODE
#  define _tstring	wstring	//!< std::(w)string
#else
#  define _tstring	string	//!< std::(w)string
#endif

// extern "C"
#ifndef EXTERN_C
#  if defined(__cplusplus)
#    define EXTERN_C	extern "C"
#  else
#    define EXTERN_C	extern 
#  endif
#endif

// extern "C" scope
#ifndef EXTERN_C_BEGIN
#  if defined(__cplusplus)
#    define EXTERN_C_BEGIN	extern "C" {
#  else
#    define EXTERN_C_BEGIN
#  endif
#endif

#ifndef EXTERN_C_END
#  if defined(__cplusplus)
#    define EXTERN_C_END	}
#  else
#    define EXTERN_C_END
#  endif
#endif

// extern "C++"
#ifndef EXTERN_CPP
#  if defined(__cplusplus)
#    define EXTERN_CPP	extern 
#  else
#    define EXTERN_CPP	extern "C++"
#  endif
#endif

#ifndef EXTERN_CPP_BEGIN
#  if defined(__cplusplus)
#    define EXTERN_CPP_BEGIN
#  else
#    define EXTERN_CPP_BEGIN	extern "C++" {
#  endif
#endif

#ifndef EXTERN_CPP_END
#if defined(__cplusplus)
#define EXTERN_CPP_END
#else
#define EXTERN_CPP_END	}
#endif
#endif

#endif
